/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiregbin.model.devices;

import com.hisilicon.hiregbin.model.devices.IDeviceSetting;
import com.hisilicon.hiregbin.utility.FileUtils;

public class UnknownDevice
implements IDeviceSetting {
    static final String DEVICE_SETTING_FOLDER = "Resources/Common/ChipProperties/";
    static final String AES_KEY = "HiReg-5D765B15-8F5B-46DC-9B7C-80322B8F74E4";
    private String name;
    private boolean isValid;
    private int emmcType;
    private int nandIPVer;
    private int spinandIPVer;
    private int emmcWriteCommand;
    private static boolean isOpenLightDebug;

    public UnknownDevice(String name) {
        this.name = name;
        this.loadChipProperties();
    }

    public static void loadLightDebug(String chipName) {
        String propertiesFile = DEVICE_SETTING_FOLDER + chipName + ".chip";
        if (FileUtils.toAbsolutePath(propertiesFile) == null) {
            return;
        }
        if (!FileUtils.isExists(FileUtils.toAbsolutePath(propertiesFile))) {
            return;
        }
    }

    private void loadChipProperties() {
        String propertiesFile = DEVICE_SETTING_FOLDER + this.name + ".chip";
        if (FileUtils.toAbsolutePath(propertiesFile) == null) {
            return;
        }
        if (!FileUtils.isExists(FileUtils.toAbsolutePath(propertiesFile))) {
            this.isValid = false;
            return;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getNandIPVer() {
        return this.nandIPVer;
    }

    public int getSpinandIPVer() {
        return this.spinandIPVer;
    }

    public int getEmmcWriteCmdType() {
        return this.emmcWriteCommand;
    }

    public void setEmmcType(int type) {
        this.emmcType = type;
    }

    public int getEmmcType() {
        return this.emmcType;
    }

    public static boolean isOpenLightDebug() {
        return isOpenLightDebug;
    }

    public static void setOpenLightDebug(boolean isOpenLightDebug) {
        UnknownDevice.isOpenLightDebug = isOpenLightDebug;
    }
}

