/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import java.math.BigInteger;

public class StringUtil {
    public static boolean hexInRange(String value, String min, String max) {
        BigInteger v = StringUtil.toBigInteger(value);
        BigInteger a = StringUtil.toBigInteger(min);
        BigInteger b = StringUtil.toBigInteger(max);
        return v.compareTo(a) >= 0 && v.compareTo(b) <= 0;
    }

    public static BigInteger toBigInteger(String text) {
        boolean hex = text.startsWith("0x") || text.startsWith("0X");
        BigInteger textInteger = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return textInteger;
    }

    public static String removeQuotes(String fileName) {
        if (fileName.startsWith("\"") && fileName.endsWith("\"")) {
            return fileName.substring(1, fileName.length() - 1);
        }
        if (fileName.startsWith("'") && fileName.endsWith("'")) {
            return fileName.substring(1, fileName.length() - 1);
        }
        return fileName;
    }

    public static String toHexString(long value, int len) {
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        String str = Integer.toHexString((int)value);
        int i = str.length();
        while (i < len) {
            sb.append("0");
            ++i;
        }
        sb.append(str);
        return sb.toString();
    }

    public static String toHexStr(long value, int len) {
        StringBuilder sb = new StringBuilder();
        String str = Integer.toHexString((int)value);
        int i = str.length();
        while (i < len) {
            sb.append("0");
            ++i;
        }
        if (str.length() == 8) {
            sb.append(str.subSequence(6, 8));
        } else {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String convertString(String value, int len) {
        StringBuilder sb = new StringBuilder();
        if (value.startsWith("0x") || value.startsWith("0X")) {
            sb.append("0x");
            String str = value.substring(2);
            int i = str.length();
            while (i < len) {
                sb.append("0");
                ++i;
            }
            sb.append(str);
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static long convertString(String str) {
        if (str.trim().isEmpty()) {
            return 0L;
        }
        if (str.startsWith("0x") || str.startsWith("0X")) {
            return Long.parseLong(str.substring(2), 16);
        }
        return Long.parseLong(str, 10);
    }

    public static String addQuote(String str) {
        return String.valueOf('\"') + str + '\"';
    }

    public static String convertUnit(long num) {
        String unit = "";
        if (num == 0L) {
            return "0";
        }
        if (num % 1024L != 0L) {
            return String.valueOf(num);
        }
        unit = "K";
        if ((num /= 1024L) < 1024L) {
            return String.valueOf(num) + unit;
        }
        if (num % 1024L != 0L) {
            return String.valueOf(num) + unit;
        }
        unit = "M";
        return String.valueOf(num /= 1024L) + unit;
    }

    public static long convertToNumber(String strNum) {
        if (strNum == null || strNum.trim().length() == 0) {
            return -1L;
        }
        strNum = strNum.toLowerCase();
        long unit = 1L;
        int index = strNum.length();
        index = strNum.indexOf("g");
        if (index != -1) {
            unit = 0x40000000L;
        } else {
            index = strNum.indexOf("k");
            if (index != -1) {
                unit = 1024L;
            } else {
                index = strNum.indexOf("m");
                if (index != -1) {
                    unit = 0x100000L;
                } else {
                    index = strNum.indexOf("b");
                    if (index != -1) {
                        unit = 1L;
                    } else {
                        index = strNum.length();
                    }
                }
            }
        }
        try {
            return Long.parseLong(strNum.substring(0, index)) * unit;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static void printByte(byte[] tsStreamByte) {
        System.out.print("[");
        byte[] byArray = tsStreamByte;
        int n = tsStreamByte.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            System.out.print("0x" + Integer.toHexString(b & 0xFF) + " ");
            ++n2;
        }
        System.out.println("]");
    }
}

