/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.controler.Builder;
import com.hisilicon.hiloader.controler.GlobleControler;
import com.hisilicon.hiloader.struct.CableMode;
import com.hisilicon.hiloader.struct.CodeDownloadDescriptor;
import com.hisilicon.hiloader.struct.DbFrontEnd;
import com.hisilicon.hiloader.struct.DeliverySysDescriptor;
import com.hisilicon.hiloader.struct.DownloadMode;
import com.hisilicon.hiloader.struct.FlashType;
import com.hisilicon.hiloader.struct.HeadTsPacket;
import com.hisilicon.hiloader.struct.LoaderDatagramData;
import com.hisilicon.hiloader.struct.LoaderDownloadControl;
import com.hisilicon.hiloader.struct.LoaderDownloadInfo;
import com.hisilicon.hiloader.struct.LoaderDownloadPartitionControl;
import com.hisilicon.hiloader.struct.LoaderDownloadPartitionControlInfoFlash;
import com.hisilicon.hiloader.struct.LoaderDownloadPartitionModeFlash;
import com.hisilicon.hiloader.struct.NetworkNameDescriptor;
import com.hisilicon.hiloader.struct.NitSection;
import com.hisilicon.hiloader.struct.PartFile;
import com.hisilicon.hiloader.struct.SectionHead;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.struct.ssu.SsuUpgradeInfo;
import com.hisilicon.hiloader.util.Crc32;
import com.hisilicon.hiloader.util.FileHelper;
import com.hisilicon.hiloader.util.FileUtil;
import com.hisilicon.hiloader.util.HiLoaderException;
import com.hisilicon.hiloader.util.RandomFileOutputStream;
import com.hisilicon.hiloader.util.ssu.SsuPackageOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.WorkbenchEncoding;

public class HisiTsPackageBuilder
implements Builder {
    public static final String UPGRADE_FILE_NAME = "packer.ts";
    private static boolean TOTAL_DATA_CRC_ENBALE = true;
    private static final int SIZE_OF_U16 = 2;
    public static final int HI_MAGICNUM_SIZE = 4;
    private static DownloadMode enDownloadMode = DownloadMode.MODE_FLASH;
    private static long g_u32DataTotleLen = 0L;
    private static int g_u32DataCrc = 0;
    private static long g_u32DataMagicNum = -1430532899L;
    private static int g_u16SecResvDataLen = 0;
    private static long g_appVersion = 0x1010101L;
    private static long g_softwareVersion = 0x1010101L;
    private static long g_FactoryIdFlag = 3L;
    private static long g_HardwareVersion = 1L;
    private static long g_start_sn = 0L;
    private static long g_end_sn = -1L;
    private static long g_download_date = 537460993L;
    private static DbFrontEnd g_struFrontend;
    private static List<PartFile> partFiles;
    private static short partitionNum;
    private static boolean is32Bit;
    private static boolean hi3798CV200;
    private int count = 0;
    static byte[] tempSectionData;
    private byte[] tempByte = new byte[6144];

    static {
        tempSectionData = new byte[992];
    }

    public static long getG_softwareVersion() {
        return g_softwareVersion;
    }

    public static void setG_softwareVersion(long g_softwareVersion) {
        HisiTsPackageBuilder.g_softwareVersion = g_softwareVersion;
    }

    public static long getG_FactoryIdFlag() {
        return g_FactoryIdFlag;
    }

    public static void setG_FactoryIdFlag(long g_FactoryIdFlag) {
        HisiTsPackageBuilder.g_FactoryIdFlag = g_FactoryIdFlag;
    }

    public static long getG_HardwareVersion() {
        return g_HardwareVersion;
    }

    public static void setG_HardwareVersion(long g_HardwareVersion) {
        HisiTsPackageBuilder.g_HardwareVersion = g_HardwareVersion;
    }

    public static long getG_start_sn() {
        return g_start_sn;
    }

    public static void setG_start_sn(long g_start_sn) {
        HisiTsPackageBuilder.g_start_sn = g_start_sn;
    }

    public static long getG_end_sn() {
        return g_end_sn;
    }

    public static void setG_end_sn(long g_end_sn) {
        HisiTsPackageBuilder.g_end_sn = g_end_sn;
    }

    public static DbFrontEnd getG_struFrontend() {
        return g_struFrontend;
    }

    public static void setG_struFrontend(DbFrontEnd g_struFrontend) {
        HisiTsPackageBuilder.g_struFrontend = g_struFrontend;
    }

    public static List<PartFile> getPartFiles() {
        return partFiles;
    }

    public static void setPartFiles(List<PartFile> partFiles) {
        HisiTsPackageBuilder.partFiles = partFiles;
    }

    public static short getPartitionNum() {
        return partitionNum;
    }

    public static void setPartitionNum(int partitionNum) {
        HisiTsPackageBuilder.partitionNum = (short)partitionNum;
    }

    public static void setIs32Bit(boolean is32Bit) {
        HisiTsPackageBuilder.is32Bit = is32Bit;
    }

    public static boolean isIs32Bit() {
        return is32Bit;
    }

    public static void setHi3798CV200(boolean hi3798cv200) {
        hi3798CV200 = hi3798cv200;
    }

    public static boolean isHi3798CV200() {
        return hi3798CV200;
    }

    private static long getRandomU32() {
        Random r = new Random(System.currentTimeMillis());
        int r1 = r.nextInt();
        int r2 = r.nextInt();
        long guid = r1 & 0xFFFF | r2 << 16 & 0xFFFF0000;
        return guid;
    }

    private static int SEC_RESERVED_DATA_LEN() {
        return 2 + g_u16SecResvDataLen;
    }

    private static int putFourByte(int value, byte[] buffer, int offset) {
        buffer[offset] = (byte)((value & 0xFF000000) >>> 24);
        buffer[offset + 1] = (byte)((value & 0xFF0000) >>> 16);
        buffer[offset + 2] = (byte)((value & 0xFF00) >>> 8);
        buffer[offset + 3] = (byte)(value & 0xFF);
        return offset + 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus createPackage(List<UpgradeFileInfo> files, UpgradeInfo info, String strFilePathName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        monitor.setTaskName("Validate upgrade file list..");
        boolean success = FileHelper.validateUpdateFilesList(files, 0x1E000000L);
        HisiTsPackageBuilder.setIs32Bit(GlobleControler.intance.isIs32Bit());
        HisiTsPackageBuilder.setHi3798CV200(GlobleControler.intance.isHi3798CV200());
        if (!success) {
            return Status.CANCEL_STATUS;
        }
        monitor.setTaskName("Analysis of the part file");
        files = FileHelper.getRealBurnFileList(files, 0x1E000000L);
        if (64 < files.size()) {
            throw new HiLoaderException(String.format(Messages.HiLoaderComposite_MaxPartFile, 64));
        }
        monitor.beginTask("Packaged part files", 100 * files.size() + 20 + 20);
        HisiTsPackageBuilder.setG_softwareVersion(info.getSoftwareVersion());
        HisiTsPackageBuilder.setG_FactoryIdFlag(info.getManufacturerId());
        HisiTsPackageBuilder.setG_HardwareVersion(info.getHardwareVersion());
        HisiTsPackageBuilder.setG_start_sn(info.getStartSn());
        HisiTsPackageBuilder.setG_end_sn(info.getEndSn());
        HisiTsPackageBuilder.setG_struFrontend(new DbFrontEnd());
        HisiTsPackageBuilder.getG_struFrontend().u32Frequency.set(674000L);
        HisiTsPackageBuilder.getG_struFrontend().u32SymbolRate.set(6875000L);
        HisiTsPackageBuilder.getG_struFrontend().enModulation.set((Enum)CableMode.valueOf(2));
        HisiTsPackageBuilder.getG_struFrontend().u16TsPID.set((long)info.getDownloadPid());
        HisiTsPackageBuilder.getG_struFrontend().u8TableID.set((short)info.getDownloadTableId());
        monitor.worked(5);
        byte[] tsBuffer = new byte[184];
        int lenDatagram = 0;
        int lenPartInfo = 0;
        int lenDownloadCtrl = 0;
        int offset = 0;
        LoaderDownloadControl loaderControl = new LoaderDownloadControl();
        LoaderDownloadPartitionControl partitionControl = new LoaderDownloadPartitionControl();
        HeadTsPacket tsHead = new HeadTsPacket();
        tsHead.synByte.set(71L);
        tsHead.transportErrorIndicator.set(0L);
        tsHead.payloadUnitStartIndicator.set(1L);
        tsHead.transportPriority.set(0L);
        tsHead.transportScramblingControl.set(0L);
        tsHead.adaptationFieldControl.set(1L);
        Arrays.fill(tsBuffer, (byte)-1);
        RandomFileOutputStream out = HisiTsPackageBuilder.newOutputStream(strFilePathName);
        if (out == null) {
            return Status.CANCEL_STATUS;
        }
        monitor.worked(5);
        int dataPackage = info.getDataPackage();
        try {
            monitor.setTaskName("Compute all of part file crc");
            HisiTsPackageBuilder.setPartFiles(HisiTsPackageBuilder.fillFileDataStruct(files));
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            monitor.worked(10);
            HisiTsPackageBuilder.setPartitionNum(HisiTsPackageBuilder.getPartFiles().size());
            monitor.setTaskName("Package Part file..");
            int partIndex = 0;
            while (partIndex < HisiTsPackageBuilder.getPartitionNum()) {
                PartFile partFile = HisiTsPackageBuilder.getPartFiles().get(partIndex);
                long[] values = new long[]{partFile.getSectionNum(), partFile.getLastDiagramDataLength(), partFile.datagramNum.get()};
                tsHead.pid.set(HisiTsPackageBuilder.getG_struFrontend().u16TsPID.get());
                monitor.worked(20);
                long sectionCount = values[0];
                SubProgressMonitor subProgressMonitor = null;
                try {
                    subProgressMonitor = new SubProgressMonitor(monitor, 80, 4);
                    subProgressMonitor.beginTask("", (int)sectionCount);
                    subProgressMonitor.setTaskName("Package all information to ts file...");
                    int sectionIndex = 0;
                    while ((long)sectionIndex < sectionCount) {
                        byte[] buffer;
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        if (sectionIndex % dataPackage == 0) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            HisiTsPackageBuilder.fillDownloadControlSecContext(loaderControl);
                            buffer = loaderControl.secBufAddr;
                            offset = 0;
                            lenDownloadCtrl = (int)loaderControl.secLen.get();
                            int i = 0;
                            while (i < 2) {
                                this.count = HisiTsPackageBuilder.fillTsPackage(out, tsHead, buffer, offset, lenDownloadCtrl, this.count, tsBuffer);
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                ++i;
                            }
                            int partitionIndex2 = 0;
                            while (partitionIndex2 < HisiTsPackageBuilder.getPartitionNum()) {
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                HisiTsPackageBuilder.fillDownloadPartitionSecContext(partitionControl, partitionIndex2);
                                buffer = partitionControl.secBufAddr;
                                offset = 0;
                                lenPartInfo = (int)partitionControl.secLen.get();
                                int i2 = 0;
                                while (i2 < 2) {
                                    this.count = HisiTsPackageBuilder.fillTsPackage(out, tsHead, buffer, offset, lenPartInfo, this.count, tsBuffer);
                                    if (monitor.isCanceled()) {
                                        IStatus iStatus = Status.CANCEL_STATUS;
                                        return iStatus;
                                    }
                                    ++i2;
                                }
                                ++partitionIndex2;
                            }
                        }
                        LoaderDatagramData loaderDatagram = new LoaderDatagramData();
                        HisiTsPackageBuilder.loadingDiagramData(loaderDatagram, partFile, partIndex, sectionIndex, values);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        buffer = loaderDatagram.struLoaderDatagramFrag[0].secBufAddr;
                        offset = 0;
                        lenDatagram = (int)loaderDatagram.struLoaderDatagramFrag[0].secLen.get();
                        Arrays.fill(this.tempByte, (byte)0);
                        int[] temp = HisiTsPackageBuilder.fillTsPackage(this.tempByte, tsHead, buffer, offset, lenDatagram, this.count, tsBuffer);
                        this.count = temp[0];
                        int len = temp[1];
                        try {
                            out.write(this.tempByte, 0, len);
                        }
                        catch (Exception e) {
                            HisiTsPackageBuilder.closeStream(out);
                            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
                        }
                        HisiTsPackageBuilder.fflush(out);
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        subProgressMonitor.worked(1);
                        ++sectionIndex;
                    }
                }
                finally {
                    if (subProgressMonitor != null) {
                        subProgressMonitor.done();
                    }
                }
                ++partIndex;
            }
            return Status.OK_STATUS;
        }
        finally {
            monitor.worked(20);
            try {
                out.close();
                if (monitor.isCanceled()) {
                    FileUtil.deleteFile(strFilePathName);
                }
            }
            catch (Exception e) {
                throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
            }
        }
    }

    private static void loadingDiagramData(LoaderDatagramData partDatagram, PartFile partFile, int partIndex, int sectionIndex, long[] values) {
        int u32SectionHeadLen = 9;
        int u32DataTopSize = 7 + HisiTsPackageBuilder.SEC_RESERVED_DATA_LEN();
        long dataLength = 0L;
        int u32CRClen = 4;
        long sectionNum = values[0];
        long lastSectionLength = values[1];
        long dataGramNum = values[2];
        RandomAccessFile file = null;
        try {
            try {
                file = new RandomAccessFile(new File(partFile.fileName), "r");
                partDatagram.newLoaderDatagram(1);
                partDatagram.u32DatagramFragNum.set(sectionNum);
                short u8TableId = HisiTsPackageBuilder.getG_struFrontend().u8TableID.get();
                short u8LastSectionNum = 0;
                u8LastSectionNum = (long)(sectionIndex / 8 + 1) < dataGramNum ? (short)8 : (short)((short)(sectionNum % 8L == 0L ? 8L : sectionNum % 8L));
                HisiTsPackageBuilder.fillDownloadDatagramSecHead(partDatagram.struLoaderDatagramFrag[0].stSecHead, u8TableId, sectionIndex / 8 + 1, (short)partIndex, u8LastSectionNum);
                dataLength = sectionNum - 1L == (long)sectionIndex ? lastSectionLength : 992L;
                int u32TotleLen = (int)((long)(u32SectionHeadLen + u32DataTopSize) + dataLength + (long)(2 * u32CRClen));
                partDatagram.struLoaderDatagramFrag[0].secBufAddr = new byte[u32TotleLen];
                HisiTsPackageBuilder.memset(partDatagram.struLoaderDatagramFrag[0].secBufAddr, 0, u32TotleLen);
                partDatagram.struLoaderDatagramFrag[0].secLen.set((long)u32TotleLen);
                partDatagram.struLoaderDatagramFrag[0].stSecHead.sectionLength.set((long)(u32TotleLen - 4));
                HisiTsPackageBuilder.fillSecHead(partDatagram.struLoaderDatagramFrag[0].stSecHead, partDatagram.struLoaderDatagramFrag[0].secBufAddr);
                HisiTsPackageBuilder.fillDownloadDatagramData(partDatagram.struLoaderDatagramFrag[0].secBufAddr, u32SectionHeadLen, file, (long)sectionIndex * 992L, (short)(sectionIndex % 8 + 1), (int)dataLength, tempSectionData);
                int crc = Crc32.compute(partDatagram.struLoaderDatagramFrag[0].secBufAddr, 1, u32TotleLen - 1 - u32CRClen);
                HisiTsPackageBuilder.alterU32ToU8(partDatagram.struLoaderDatagramFrag[0].secBufAddr, u32TotleLen - u32CRClen, crc);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static RandomFileOutputStream newOutputStream(String strFilePathName) throws FileNotFoundException, HiLoaderException {
        FileUtil.deleteFile(strFilePathName);
        if (!FileUtil.canWriteFile(strFilePathName, Messages.TsPackageBuilder_CreateError)) {
            return null;
        }
        RandomFileOutputStream fp = null;
        try {
            fp = new RandomFileOutputStream(strFilePathName);
        }
        catch (Exception e) {
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
        return fp;
    }

    public static void writeByte(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    private static void construct_TsHead(byte[] out, HeadTsPacket pstrHeadTsPak, int destPos) throws HiLoaderException {
        byte[] headBuf = new byte[]{(byte)pstrHeadTsPak.synByte.get(), (byte)(0L | pstrHeadTsPak.transportErrorIndicator.get() << 7 | pstrHeadTsPak.payloadUnitStartIndicator.get() << 6 | pstrHeadTsPak.transportPriority.get() << 5 | pstrHeadTsPak.pid.get() >>> 8 & 0x1FL), (byte)(pstrHeadTsPak.pid.get() & 0xFFL), (byte)(0L | pstrHeadTsPak.transportScramblingControl.get() << 6 | pstrHeadTsPak.adaptationFieldControl.get() << 4 | pstrHeadTsPak.continuityCounter.get())};
        HisiTsPackageBuilder.writeByte(headBuf, 0, out, destPos, headBuf.length);
    }

    private static int[] fillTsPackage(byte[] fp, HeadTsPacket strHeadTsPak, byte[] pTmp, int pTempOffset, int lenDownloadCtrl, int count, byte[] tsBuf) throws HiLoaderException, IOException {
        int oldLen = 0;
        strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
        if (count > 15) {
            count = 0;
        }
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        HisiTsPackageBuilder.construct_TsHead(fp, strHeadTsPak, 0);
        pTempOffset += 4;
        if (lenDownloadCtrl > 184) {
            while (lenDownloadCtrl > 184) {
                HisiTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, 184);
                lenDownloadCtrl -= 184;
                oldLen += 184;
                strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
                if (count > 15) {
                    count = 0;
                }
                strHeadTsPak.payloadUnitStartIndicator.set(0L);
                HisiTsPackageBuilder.construct_TsHead(fp, strHeadTsPak, pTempOffset += 184);
                pTempOffset += 4;
            }
            HisiTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, lenDownloadCtrl);
            HisiTsPackageBuilder.writeByte(tsBuf, 0, fp, pTempOffset += lenDownloadCtrl, 184 - lenDownloadCtrl);
            pTempOffset += 184 - lenDownloadCtrl;
        } else {
            HisiTsPackageBuilder.writeByte(pTmp, oldLen, fp, pTempOffset, lenDownloadCtrl);
            HisiTsPackageBuilder.writeByte(tsBuf, 0, fp, pTempOffset += lenDownloadCtrl, 184 - lenDownloadCtrl);
            pTempOffset += 184 - lenDownloadCtrl;
        }
        int[] temp = new int[]{count, pTempOffset};
        return temp;
    }

    private static int fillTsPackage(RandomFileOutputStream fp, HeadTsPacket strHeadTsPak, byte[] pTmp, int pTempOffset, int lenDownloadCtrl, int count, byte[] tsBuf) throws HiLoaderException, IOException {
        strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
        if (count > 15) {
            count = 0;
        }
        strHeadTsPak.payloadUnitStartIndicator.set(1L);
        try {
            HisiTsPackageBuilder.fillTsHead(fp, strHeadTsPak);
            if (lenDownloadCtrl > 184) {
                while (lenDownloadCtrl > 184) {
                    fp.write(pTmp, pTempOffset, 184);
                    lenDownloadCtrl -= 184;
                    strHeadTsPak.continuityCounter.set((long)(count++ & 0xF));
                    if (count > 15) {
                        count = 0;
                    }
                    strHeadTsPak.payloadUnitStartIndicator.set(0L);
                    HisiTsPackageBuilder.fillTsHead(fp, strHeadTsPak);
                    pTempOffset += 184;
                }
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            } else {
                fp.write(pTmp, pTempOffset, lenDownloadCtrl);
                fp.write(tsBuf, 0, 184 - lenDownloadCtrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HisiTsPackageBuilder.closeStream(fp);
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
        HisiTsPackageBuilder.fflush(fp);
        return count;
    }

    private static void fflush(RandomFileOutputStream fp) throws HiLoaderException {
        try {
            fp.flush();
        }
        catch (IOException e) {
            throw new HiLoaderException(Messages.TsPackageBuilder_CreateError);
        }
    }

    private static void closeStream(RandomFileOutputStream fp) {
        try {
            fp.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void fillDownloadControlDownInfo(LoaderDownloadInfo pDownloadInfo) {
        int u32CrcVal = 0;
        boolean reserverd_tag = true;
        int reserverd_data_length = 8;
        int u32LoaderDownloadInfoLen = 29;
        pDownloadInfo.downloadInfoTag.set(234L);
        pDownloadInfo.downloadTableId.set(HisiTsPackageBuilder.getG_struFrontend().u8TableID.get());
        pDownloadInfo.keyControl.set((short)31);
        pDownloadInfo.stbManufacturerId.set(HisiTsPackageBuilder.getG_FactoryIdFlag());
        pDownloadInfo.hardwareVer.set(HisiTsPackageBuilder.getG_HardwareVersion());
        pDownloadInfo.softwareVer.set(HisiTsPackageBuilder.getG_softwareVersion());
        pDownloadInfo.serialNumberStart.set(HisiTsPackageBuilder.getG_start_sn());
        pDownloadInfo.serialNumberEnd.set(HisiTsPackageBuilder.getG_end_sn());
        pDownloadInfo.downloadDate.set(g_download_date);
        if (1 == (pDownloadInfo.keyControl.get() & 1)) {
            pDownloadInfo.webBrowserVer.set(g_appVersion);
            u32LoaderDownloadInfoLen += 4;
        }
        if (2 == (pDownloadInfo.keyControl.get() & 2)) {
            pDownloadInfo.kernelVer.set(1L);
            u32LoaderDownloadInfoLen += 4;
        }
        if (4 == (pDownloadInfo.keyControl.get() & 4)) {
            pDownloadInfo.caVer.set(1L);
            u32LoaderDownloadInfoLen += 4;
        }
        if (8 == (pDownloadInfo.keyControl.get() & 8)) {
            pDownloadInfo.bootLoaderVer.set(1L);
            u32LoaderDownloadInfoLen += 4;
        }
        if (16 == (pDownloadInfo.keyControl.get() & 0x10)) {
            pDownloadInfo.loaderVer.set(1L);
            u32LoaderDownloadInfoLen += 4;
        }
        byte[] au8ProductHardName = new byte[40];
        Arrays.fill(au8ProductHardName, (byte)0);
        HisiTsPackageBuilder.memcpy(au8ProductHardName, 0, "hisilion001", 40L);
        pDownloadInfo.hardwareStringLen.set(HisiTsPackageBuilder.strlen(au8ProductHardName));
        pDownloadInfo.hardwareStringDescriptor = au8ProductHardName;
        if (enDownloadMode == DownloadMode.MODE_FLASH) {
            LoaderDownloadPartitionModeFlash struDLPartitionModeFlash = new LoaderDownloadPartitionModeFlash();
            struDLPartitionModeFlash.downloadPartInfoTag.set((short)235);
            struDLPartitionModeFlash.partitionCount.set(HisiTsPackageBuilder.getPartitionNum());
            struDLPartitionModeFlash.reserved.set((short)255);
            int part_descritption_length = 0;
            part_descritption_length = HisiTsPackageBuilder.isHi3798CV200() ? HisiTsPackageBuilder.getPartitionNum() * 18 : HisiTsPackageBuilder.getPartitionNum() * 14;
            struDLPartitionModeFlash.partDescritptionLength.set(part_descritption_length);
            int i = 0;
            while (i < HisiTsPackageBuilder.getPartitionNum()) {
                struDLPartitionModeFlash.partDescritption[i].downloadMode.set((short)DownloadMode.MODE_FLASH.ordinal());
                if (HisiTsPackageBuilder.isHi3798CV200()) {
                    struDLPartitionModeFlash.partDescritption[i].downloadModeDataLen.set((short)16);
                } else {
                    struDLPartitionModeFlash.partDescritption[i].downloadModeDataLen.set((short)12);
                }
                PartFile partFile = HisiTsPackageBuilder.getPartFiles().get(i);
                struDLPartitionModeFlash.partDescritption[i].downloadModeFlash.setDownloadAddr(partFile.getBurnAddr());
                struDLPartitionModeFlash.partDescritption[i].downloadModeFlash.downloadSize.set(partFile.fileSize.get());
                struDLPartitionModeFlash.partDescritption[i].downloadModeFlash.downloadCrc32.set(partFile.crcValue.get());
                g_u32DataTotleLen += partFile.fileSize.get();
                ++i;
            }
            struDLPartitionModeFlash.setDownloadDataTotalSize(g_u32DataTotleLen);
            byte[] au8UpgrdDesInfo = new byte[40];
            HisiTsPackageBuilder.memset(au8UpgrdDesInfo, 0, 40);
            HisiTsPackageBuilder.memcpy(au8UpgrdDesInfo, 0, "product update 2007!", 40L);
            struDLPartitionModeFlash.downloadDescriptionLength.set(HisiTsPackageBuilder.strlen(au8UpgrdDesInfo));
            struDLPartitionModeFlash.downloadDescriptionString = au8UpgrdDesInfo;
            if (HisiTsPackageBuilder.isHi3798CV200()) {
                struDLPartitionModeFlash.downloadPartInfoLen.set((short)(8 + part_descritption_length + 1 + struDLPartitionModeFlash.downloadDescriptionLength.get() + 11));
            } else if (HisiTsPackageBuilder.isIs32Bit()) {
                struDLPartitionModeFlash.downloadPartInfoLen.set((short)(8 + part_descritption_length + 1 + struDLPartitionModeFlash.downloadDescriptionLength.get() + 11));
            } else {
                struDLPartitionModeFlash.downloadPartInfoLen.set((short)(12 + part_descritption_length + 1 + struDLPartitionModeFlash.downloadDescriptionLength.get() + 11));
            }
            byte[] au8UpgrdPartInfo = null;
            if (HisiTsPackageBuilder.isHi3798CV200()) {
                au8UpgrdPartInfo = new byte[1218];
                HisiTsPackageBuilder.memset(au8UpgrdPartInfo, 0, 1218);
            } else if (HisiTsPackageBuilder.isIs32Bit()) {
                au8UpgrdPartInfo = new byte[962];
                HisiTsPackageBuilder.memset(au8UpgrdPartInfo, 0, 962);
            } else {
                au8UpgrdPartInfo = new byte[966];
                HisiTsPackageBuilder.memset(au8UpgrdPartInfo, 0, 966);
            }
            byte[] pu8Temp = au8UpgrdPartInfo;
            int offset = 0;
            pu8Temp[offset++] = (byte)struDLPartitionModeFlash.downloadPartInfoTag.get();
            pu8Temp[offset++] = (byte)struDLPartitionModeFlash.downloadPartInfoLen.get();
            offset = HisiTsPackageBuilder.isHi3798CV200() ? HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDLPartitionModeFlash.getDownloadDataTotalSize()) : (HisiTsPackageBuilder.isIs32Bit() ? HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDLPartitionModeFlash.getDownloadDataTotalSize()) : HisiTsPackageBuilder.alterU64ToU8(pu8Temp, offset, struDLPartitionModeFlash.getDownloadDataTotalSize()));
            pu8Temp[offset++] = (byte)struDLPartitionModeFlash.partitionCount.get();
            pu8Temp[offset++] = (byte)struDLPartitionModeFlash.reserved.get();
            offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)struDLPartitionModeFlash.partDescritptionLength.get());
            int i2 = 0;
            while (i2 < HisiTsPackageBuilder.getPartitionNum()) {
                pu8Temp[offset++] = (byte)struDLPartitionModeFlash.partDescritption[i2].downloadMode.get();
                pu8Temp[offset++] = (byte)struDLPartitionModeFlash.partDescritption[i2].downloadModeDataLen.get();
                offset = HisiTsPackageBuilder.isHi3798CV200() ? HisiTsPackageBuilder.alterU64ToU8(pu8Temp, offset, struDLPartitionModeFlash.partDescritption[i2].downloadModeFlash.getDownloadAddr()) : HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDLPartitionModeFlash.partDescritption[i2].downloadModeFlash.getDownloadAddr());
                offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDLPartitionModeFlash.partDescritption[i2].downloadModeFlash.downloadSize.get());
                offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDLPartitionModeFlash.partDescritption[i2].downloadModeFlash.downloadCrc32.get());
                ++i2;
            }
            pu8Temp[offset++] = (byte)struDLPartitionModeFlash.downloadDescriptionLength.get();
            HisiTsPackageBuilder.memcpy(pu8Temp, offset, struDLPartitionModeFlash.downloadDescriptionString, struDLPartitionModeFlash.downloadDescriptionLength.get());
            offset += struDLPartitionModeFlash.downloadDescriptionLength.get();
            if (TOTAL_DATA_CRC_ENBALE) {
                pu8Temp[offset++] = (byte)(reserverd_tag ? 1 : 0);
                offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)reserverd_data_length);
                offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, g_u32DataCrc);
                offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)g_u32DataMagicNum);
            }
            u32CrcVal = Crc32.compute(au8UpgrdPartInfo, 2, struDLPartitionModeFlash.downloadPartInfoLen.get());
            offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, u32CrcVal);
            pDownloadInfo.downloadPartInfo = au8UpgrdPartInfo;
            pDownloadInfo.downloadInfoLen.set((long)(u32LoaderDownloadInfoLen - 2 + pDownloadInfo.hardwareStringLen.get()));
            g_u32DataTotleLen = 0L;
        }
    }

    private static void memcpy(byte[] pu8Temp, int offset, byte[] downloadDescriptionString, short len) {
        System.arraycopy(downloadDescriptionString, 0, pu8Temp, offset, len);
    }

    private static void memset(byte[] buf, int value, int len) {
        assert (buf.length == len);
        Arrays.fill(buf, (byte)value);
    }

    private static short strlen(byte[] au8ProductHardName) {
        int i = 0;
        while (i < au8ProductHardName.length) {
            if (au8ProductHardName[i] == 0) {
                return (short)i;
            }
            ++i;
        }
        return (short)au8ProductHardName.length;
    }

    private static void fillTsHead(OutputStream out, HeadTsPacket pstrHeadTsPak) throws HiLoaderException {
        byte[] headBuf = new byte[]{(byte)pstrHeadTsPak.synByte.get(), (byte)(0L | pstrHeadTsPak.transportErrorIndicator.get() << 7 | pstrHeadTsPak.payloadUnitStartIndicator.get() << 6 | pstrHeadTsPak.transportPriority.get() << 5 | pstrHeadTsPak.pid.get() >>> 8 & 0x1FL), (byte)(pstrHeadTsPak.pid.get() & 0xFFL), (byte)(0L | pstrHeadTsPak.transportScramblingControl.get() << 6 | pstrHeadTsPak.adaptationFieldControl.get() << 4 | pstrHeadTsPak.continuityCounter.get())};
        try {
            out.write(headBuf);
            out.flush();
        }
        catch (IOException e) {
            throw new HiLoaderException(Messages.TsPackageBuilder_FillError);
        }
    }

    private static void fillSecHead(SectionHead pSecHead, byte[] secBuf) {
        secBuf[0] = 0;
        secBuf[1] = (byte)pSecHead.tableId.get();
        secBuf[2] = (byte)(0L | pSecHead.sectionSyntaxIndicator.get() << 7 | 0x70L | (pSecHead.sectionLength.get() & 0xF00L) >> 8);
        secBuf[3] = (byte)(pSecHead.sectionLength.get() & 0xFFL);
        secBuf[4] = (byte)((pSecHead.tableIdExtension.get() & 0xFF00L) >> 8);
        secBuf[5] = (byte)(pSecHead.tableIdExtension.get() & 0xFFL);
        secBuf[6] = (byte)pSecHead.versionNumber.get();
        secBuf[7] = (byte)pSecHead.sectionNumber.get();
        secBuf[8] = (byte)pSecHead.lastSectionNumber.get();
    }

    private static int alterU64ToU8(byte[] pu8Data, int offset, long u64Data) {
        pu8Data[offset] = (byte)(u64Data >> 56 & 0xFFL);
        pu8Data[offset + 1] = (byte)(u64Data >> 48 & 0xFFL);
        pu8Data[offset + 2] = (byte)(u64Data >> 40 & 0xFFL);
        pu8Data[offset + 3] = (byte)(u64Data >> 32 & 0xFFL);
        pu8Data[offset + 4] = (byte)(u64Data >> 24 & 0xFFL);
        pu8Data[offset + 5] = (byte)(u64Data >> 16 & 0xFFL);
        pu8Data[offset + 6] = (byte)(u64Data >> 8 & 0xFFL);
        pu8Data[offset + 7] = (byte)(u64Data & 0xFFL);
        return offset += 8;
    }

    private static int alterU32LowToU8(byte[] pu8Data, int offset, int u32Data) {
        pu8Data[offset] = 0;
        pu8Data[offset + 1] = 0;
        pu8Data[offset + 2] = 0;
        pu8Data[offset + 3] = (byte)(u32Data & 0xFF);
        return offset + 4;
    }

    private static int alterU32ToU8(byte[] pu8Data, int offset, int u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF000000) >>> 24);
        pu8Data[offset + 1] = (byte)((u32Data & 0xFF0000) >>> 16);
        pu8Data[offset + 2] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 3] = (byte)(u32Data & 0xFF);
        return offset + 4;
    }

    private static int alterU16ToU8(byte[] pu8Data, int offset, short u32Data) {
        pu8Data[offset] = (byte)((u32Data & 0xFF00) >>> 8);
        pu8Data[offset + 1] = (byte)(u32Data & 0xFF);
        return offset + 2;
    }

    private static void fillDownloadDatagramData(byte[] pu8DesData, int offset, RandomAccessFile fileConetent, long srcOffset, short u8DatagramCurSecNum, int u32DataLen, byte[] temp) {
        int destOffset = offset;
        destOffset = HisiTsPackageBuilder.alterU32ToU8(pu8DesData, destOffset, (int)g_u32DataMagicNum);
        destOffset = HisiTsPackageBuilder.alterU16ToU8(pu8DesData, destOffset, (short)g_u16SecResvDataLen);
        pu8DesData[destOffset++] = (byte)(0x80 | u8DatagramCurSecNum);
        destOffset = HisiTsPackageBuilder.alterU16ToU8(pu8DesData, destOffset, (short)u32DataLen);
        try {
            fileConetent.seek(srcOffset);
            int read = fileConetent.read(temp, 0, u32DataLen);
            System.arraycopy(temp, 0, pu8DesData, destOffset, read);
            destOffset += read;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int u32Crc = Crc32.compute(pu8DesData, offset + 3 + 4 + HisiTsPackageBuilder.SEC_RESERVED_DATA_LEN(), u32DataLen);
        HisiTsPackageBuilder.alterU32ToU8(pu8DesData, destOffset, u32Crc);
    }

    public static void fillDownloadDatagramData(byte[] pu8DesData, int offset, byte[] fileConetent, int srcOffset, short u8DatagramCurSecNum, int u32DataLen) {
        int destOffset = offset;
        destOffset = HisiTsPackageBuilder.alterU32ToU8(pu8DesData, destOffset, (int)g_u32DataMagicNum);
        destOffset = HisiTsPackageBuilder.alterU16ToU8(pu8DesData, destOffset, (short)g_u16SecResvDataLen);
        pu8DesData[destOffset++] = (byte)(0x80 | u8DatagramCurSecNum);
        destOffset = HisiTsPackageBuilder.alterU16ToU8(pu8DesData, destOffset, (short)u32DataLen);
        System.arraycopy(fileConetent, srcOffset, pu8DesData, destOffset, u32DataLen);
        int u32Crc = Crc32.compute(pu8DesData, offset + 3 + 4 + HisiTsPackageBuilder.SEC_RESERVED_DATA_LEN(), u32DataLen);
        HisiTsPackageBuilder.alterU32ToU8(pu8DesData, destOffset += u32DataLen, u32Crc);
    }

    private static void fillDownloadDatagramSecHead(SectionHead pSectionHead, short u8TableId, int u16TableExId, short u8SectionNum, short last_section_number) {
        pSectionHead.tableId.set((long)u8TableId);
        pSectionHead.sectionSyntaxIndicator.set(1L);
        pSectionHead.tableIdExtension.set((long)u16TableExId);
        pSectionHead.versionNumber.set(0L);
        pSectionHead.sectionNumber.set((long)(u8SectionNum + 1));
        pSectionHead.lastSectionNumber.set((long)last_section_number);
    }

    private static void fillDownloadPartitionSecHead(SectionHead sectionHead, short tableId, short partitionIndex) {
        sectionHead.tableId.set((long)tableId);
        sectionHead.sectionSyntaxIndicator.set(1L);
        sectionHead.tableIdExtension.set(0L);
        sectionHead.versionNumber.set(0L);
        sectionHead.sectionNumber.set((long)(partitionIndex + 1));
        sectionHead.lastSectionNumber.set(1L);
    }

    private static void fillDownloadControlSecHead(SectionHead pSectionHead) {
        pSectionHead.tableId.set(254L);
        pSectionHead.sectionSyntaxIndicator.set(1L);
        pSectionHead.tableIdExtension.set(0L);
        pSectionHead.versionNumber.set(0L);
        pSectionHead.sectionNumber.set(0L);
        pSectionHead.lastSectionNumber.set(1L);
    }

    private static void fillCableDeliveryDescriptor(DeliverySysDescriptor pDeliDeptor) {
        pDeliDeptor.desTag.set((short)68);
        pDeliDeptor.fre.set(307000L);
        pDeliDeptor.fecInner.set(15);
        pDeliDeptor.fecOuter.set(2);
        pDeliDeptor.modulate.set(2);
        pDeliDeptor.symrate.set(6875000L);
        pDeliDeptor.desLen.set((short)11);
    }

    private static void fillCodeDownloadDescriptor(CodeDownloadDescriptor pDLDesptor) {
        pDLDesptor.descriptorTag.set(161L);
        pDLDesptor.downloadPid.set(22L);
        pDLDesptor.downloadType.set(0L);
        pDLDesptor.keyControl.set((short)63);
        pDLDesptor.hardwareVer.set(2L);
        pDLDesptor.softwareVer.set(0L);
        pDLDesptor.stbManufacturerId.set(1L);
        pDLDesptor.webbrowserVer.set(4L);
        pDLDesptor.kernelVer.set(5L);
        pDLDesptor.caVer.set(6L);
        pDLDesptor.bootLoaderVer.set(7L);
        pDLDesptor.loaderVer.set(8L);
        pDLDesptor.updateDate.set(4369L);
        pDLDesptor.logoVer.set(9L);
        pDLDesptor.serialNumberStart.set(1L);
        pDLDesptor.serialNumberEnd.set(5L);
        pDLDesptor.string.set("hisilion001");
        pDLDesptor.stringLen.set((long)pDLDesptor.string.get().length());
        pDLDesptor.privateDataLen.set(pDLDesptor.stringLen.get() + 1L + 44L + 1L);
        pDLDesptor.descriptorLen.set(pDLDesptor.privateDataLen.get() + 1L + 2L + 13L + 2L);
    }

    private static void fillDownloadPartitionControlInfoFlash(LoaderDownloadPartitionControlInfoFlash pstruDownloadPartitionControlInfoFlash, int uPartNum, List<PartFile> headers) {
        PartFile g_struPartFile = headers.get(uPartNum);
        pstruDownloadPartitionControlInfoFlash.partHeadTag.set((short)236);
        if (HisiTsPackageBuilder.isHi3798CV200()) {
            pstruDownloadPartitionControlInfoFlash.partNewVer.set(g_struPartFile.partitionVersion.get());
            String name = g_struPartFile.getPartitionName();
            if (name == null || name.isEmpty()) {
                pstruDownloadPartitionControlInfoFlash.downloadstringLength.set(0);
                pstruDownloadPartitionControlInfoFlash.setDownloadstring_char(null);
                int partitionLength = 4;
                pstruDownloadPartitionControlInfoFlash.partHeadDataLen.set((short)(53 + partitionLength));
            } else {
                pstruDownloadPartitionControlInfoFlash.downloadstringLength.set(name.length());
                pstruDownloadPartitionControlInfoFlash.setDownloadstring_char(g_struPartFile.getPartitionName());
                int partitionLength = 4 + name.length();
                pstruDownloadPartitionControlInfoFlash.partHeadDataLen.set((short)(53 + partitionLength));
            }
            pstruDownloadPartitionControlInfoFlash.partitionVerifyTag.set(g_struPartFile.partitionVerifyTag.get());
        } else {
            pstruDownloadPartitionControlInfoFlash.partNewVer.set(1L);
            if (HisiTsPackageBuilder.isIs32Bit()) {
                pstruDownloadPartitionControlInfoFlash.partHeadDataLen.set((short)45);
            } else {
                pstruDownloadPartitionControlInfoFlash.partHeadDataLen.set((short)53);
            }
        }
        pstruDownloadPartitionControlInfoFlash.downloadType.set((short)DownloadMode.MODE_FLASH.ordinal());
        pstruDownloadPartitionControlInfoFlash.reserved.set((short)255);
        pstruDownloadPartitionControlInfoFlash.partDatagramNumber.set((int)g_struPartFile.datagramNum.get());
        pstruDownloadPartitionControlInfoFlash.partTotalSize.set(g_struPartFile.fileSize.get());
        pstruDownloadPartitionControlInfoFlash.partOriSize.set(400L);
        pstruDownloadPartitionControlInfoFlash.partOldVerStart.set(0L);
        pstruDownloadPartitionControlInfoFlash.partOldVerEnd.set(0L);
        pstruDownloadPartitionControlInfoFlash.setStartAddr(g_struPartFile.getBurnAddr());
        pstruDownloadPartitionControlInfoFlash.uFlashType.set((long)((FlashType)g_struPartFile.uFlashType.get()).ordinal());
        pstruDownloadPartitionControlInfoFlash.lFlashIndex.set(g_struPartFile.lFlashIndex.get());
        pstruDownloadPartitionControlInfoFlash.setuPartitionEndAddr(g_struPartFile.getuPartitionEndAddr());
    }

    private static void fillNitSecContext(NitSection pNitSec) {
        DeliverySysDescriptor deliveryDescriptor = new DeliverySysDescriptor();
        NetworkNameDescriptor networkNameDescriptor = new NetworkNameDescriptor();
        CodeDownloadDescriptor codeDownloadDescriptor = new CodeDownloadDescriptor();
        int u32CrcVal = 0;
        networkNameDescriptor.descriptorTag.set(64L);
        try {
            networkNameDescriptor.pString = "Topway Cable TV".getBytes(WorkbenchEncoding.getWorkbenchDefaultEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return;
        }
        networkNameDescriptor.descriptorLen.set((long)networkNameDescriptor.pString.length);
        HisiTsPackageBuilder.fillCableDeliveryDescriptor(deliveryDescriptor);
        HisiTsPackageBuilder.fillCodeDownloadDescriptor(codeDownloadDescriptor);
        pNitSec.stSecHead.tableId.set(64L);
        pNitSec.stSecHead.sectionSyntaxIndicator.set(1L);
        pNitSec.stSecHead.tableIdExtension.set(1L);
        pNitSec.stSecHead.versionNumber.set(g_softwareVersion);
        pNitSec.stSecHead.sectionNumber.set(0L);
        pNitSec.stSecHead.lastSectionNumber.set(0L);
        codeDownloadDescriptor.setDeliverySysDescriptor(deliveryDescriptor);
        pNitSec.networkDescriptorLen.set((int)(2L + networkNameDescriptor.descriptorLen.get() + 2L + codeDownloadDescriptor.descriptorLen.get()));
        pNitSec.transportStreamsLen.set((short)0);
        int len = 2 + pNitSec.networkDescriptorLen.get() + 2 + pNitSec.transportStreamsLen.get() + 4 + 5;
        pNitSec.stSecHead.sectionLength.set((long)len);
        int totalLen = len + 3 + 1;
        pNitSec.secBufAddr = new byte[totalLen];
        Arrays.fill(pNitSec.secBufAddr, (byte)0);
        byte[] pTmp = pNitSec.secBufAddr;
        int offset = 9;
        pTmp[offset++] = (byte)(240 + ((pNitSec.networkDescriptorLen.get() & 0xF00) >>> 8));
        pTmp[offset++] = (byte)(pNitSec.networkDescriptorLen.get() & 0xFF);
        pTmp[offset++] = (byte)networkNameDescriptor.descriptorTag.get();
        pTmp[offset++] = (byte)networkNameDescriptor.descriptorLen.get();
        System.arraycopy(networkNameDescriptor.pString, 0, pTmp, offset, (int)networkNameDescriptor.descriptorLen.get());
        offset = (int)((long)offset + networkNameDescriptor.descriptorLen.get());
        pTmp[offset++] = (byte)codeDownloadDescriptor.descriptorTag.get();
        pTmp[offset++] = (byte)codeDownloadDescriptor.descriptorLen.get();
        pTmp[offset++] = (byte)((codeDownloadDescriptor.stbManufacturerId.get() & 0xFF00L) >>> 8);
        pTmp[offset++] = (byte)(codeDownloadDescriptor.stbManufacturerId.get() & 0xFFL);
        pTmp[offset++] = (byte)deliveryDescriptor.desTag.get();
        pTmp[offset++] = (byte)deliveryDescriptor.desLen.get();
        offset = HisiTsPackageBuilder.putFourByte((int)deliveryDescriptor.fre.get(), pTmp, offset);
        pTmp[offset++] = -1;
        pTmp[offset++] = (byte)(0xF0 | deliveryDescriptor.fecOuter.get() & 0xF);
        pTmp[offset++] = (byte)deliveryDescriptor.modulate.get();
        pTmp[offset++] = (byte)((deliveryDescriptor.symrate.get() & 0xFF00000L) >>> 20);
        pTmp[offset++] = (byte)((deliveryDescriptor.symrate.get() & 0xFF0L) >>> 4);
        pTmp[offset++] = (byte)((deliveryDescriptor.symrate.get() & 0xFL) << 4 | (long)(deliveryDescriptor.fecInner.get() & 0xF));
        pTmp[offset++] = (byte)((codeDownloadDescriptor.downloadPid.get() & 0x1FE0L) >>> 5);
        pTmp[offset++] = (byte)((codeDownloadDescriptor.downloadPid.get() & 0x1FL) << 3 | codeDownloadDescriptor.downloadType.get() & 7L);
        pTmp[offset++] = (byte)codeDownloadDescriptor.privateDataLen.get();
        pTmp[offset++] = (byte)codeDownloadDescriptor.keyControl.get();
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.hardwareVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.softwareVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.webbrowserVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.kernelVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.caVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.bootLoaderVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.loaderVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.logoVer.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.serialNumberStart.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.serialNumberEnd.get(), pTmp, offset);
        offset = HisiTsPackageBuilder.putFourByte((int)codeDownloadDescriptor.updateDate.get(), pTmp, offset);
        pTmp[offset++] = (byte)codeDownloadDescriptor.stringLen.get();
        HisiTsPackageBuilder.memcpy(pTmp, offset, codeDownloadDescriptor.string.get(), codeDownloadDescriptor.stringLen.get());
        offset = (int)((long)offset + codeDownloadDescriptor.stringLen.get());
        HisiTsPackageBuilder.fillSecHead(pNitSec.stSecHead, pTmp);
        u32CrcVal = Crc32.compute(pTmp, 1, totalLen - 4 - 1);
        HisiTsPackageBuilder.alterU32ToU8(pTmp, totalLen - 4, u32CrcVal);
        pNitSec.secLen.set((long)totalLen);
    }

    private static void fillDownloadPartitionSecContext(LoaderDownloadPartitionControl partitionControl, int partIndex) {
        short tableId = HisiTsPackageBuilder.getG_struFrontend().u8TableID.get();
        LoaderDownloadPartitionControlInfoFlash struDownloadPartitionControlInfoFlash = new LoaderDownloadPartitionControlInfoFlash();
        int sectionHeadLength = 9;
        int partitionControlInfoFlashLength = 0;
        int u32CRClen = 4;
        int totalLength = 0;
        HisiTsPackageBuilder.fillDownloadPartitionSecHead(partitionControl.stSecHead, tableId, (short)partIndex);
        HisiTsPackageBuilder.fillDownloadPartitionControlInfoFlash(struDownloadPartitionControlInfoFlash, partIndex, HisiTsPackageBuilder.getPartFiles());
        partitionControlInfoFlashLength = struDownloadPartitionControlInfoFlash.partHeadDataLen.get() + 2;
        totalLength = sectionHeadLength + partitionControlInfoFlashLength + u32CRClen;
        partitionControl.secBufAddr = new byte[totalLength];
        Arrays.fill(partitionControl.secBufAddr, (byte)0);
        partitionControl.secLen.set((long)totalLength);
        partitionControl.stSecHead.sectionLength.set((long)(totalLength - 4));
        HisiTsPackageBuilder.fillSecHead(partitionControl.stSecHead, partitionControl.secBufAddr);
        byte[] pu8Temp = partitionControl.secBufAddr;
        int offset = sectionHeadLength;
        pu8Temp[offset++] = (byte)struDownloadPartitionControlInfoFlash.partHeadTag.get();
        pu8Temp[offset++] = (byte)struDownloadPartitionControlInfoFlash.partHeadDataLen.get();
        pu8Temp[offset++] = (byte)struDownloadPartitionControlInfoFlash.downloadType.get();
        pu8Temp[offset++] = (byte)struDownloadPartitionControlInfoFlash.reserved.get();
        offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)struDownloadPartitionControlInfoFlash.partDatagramNumber.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partTotalSize.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partOriSize.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partOldVerStart.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partOldVerEnd.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partNewVer.get());
        offset = HisiTsPackageBuilder.isIs32Bit() ? HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.getStartAddr()) : HisiTsPackageBuilder.alterU64ToU8(pu8Temp, offset, struDownloadPartitionControlInfoFlash.getStartAddr());
        if (HisiTsPackageBuilder.isHi3798CV200()) {
            int length = struDownloadPartitionControlInfoFlash.downloadstringLength.get();
            if (length == 0) {
                offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)0);
            } else {
                offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)length);
                String name = struDownloadPartitionControlInfoFlash.getDownloadstring_char();
                short len = (short)name.length();
                try {
                    HisiTsPackageBuilder.memcpy(pu8Temp, offset, name.getBytes(System.getProperty("file.encoding")), len);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                offset += len;
            }
        } else {
            offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)0);
        }
        pu8Temp[offset++] = 1;
        offset = HisiTsPackageBuilder.alterU16ToU8(pu8Temp, offset, (short)16);
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.uFlashType.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.lFlashIndex.get());
        offset = HisiTsPackageBuilder.isIs32Bit() ? HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.getuPartitionEndAddr()) : HisiTsPackageBuilder.alterU64ToU8(pu8Temp, offset, struDownloadPartitionControlInfoFlash.getuPartitionEndAddr());
        if (HisiTsPackageBuilder.isHi3798CV200()) {
            offset = HisiTsPackageBuilder.alterU32LowToU8(pu8Temp, offset, (int)struDownloadPartitionControlInfoFlash.partitionVerifyTag.get());
        }
        int u32CrcVal = Crc32.compute(partitionControl.secBufAddr, 1, totalLength - u32CRClen - 1);
        HisiTsPackageBuilder.alterU32ToU8(partitionControl.secBufAddr, totalLength - u32CRClen, u32CrcVal);
    }

    private static void fillDownloadControlSecContext(LoaderDownloadControl pstruDownloadControl) {
        int u32TotleLen = 0;
        LoaderDownloadInfo struDownloadInfo = new LoaderDownloadInfo();
        int u32SecHeadLen = 9;
        int u32CrcLen = 4;
        int u32ParLen = 0;
        int u32CrcVal = 0;
        HisiTsPackageBuilder.fillDownloadControlSecHead(pstruDownloadControl.stSecHead);
        HisiTsPackageBuilder.fillDownloadControlDownInfo(struDownloadInfo);
        if (HisiTsPackageBuilder.isHi3798CV200()) {
            u32ParLen = struDownloadInfo.downloadPartInfo[6] * 18;
            u32ParLen += 10;
        } else if (HisiTsPackageBuilder.isIs32Bit()) {
            u32ParLen = struDownloadInfo.downloadPartInfo[6] * 14;
            u32ParLen += 10;
        } else {
            u32ParLen = struDownloadInfo.downloadPartInfo[10] * 14;
            u32ParLen += 14;
        }
        u32ParLen += struDownloadInfo.downloadPartInfo[u32ParLen] + 1 + 11 + 4;
        u32TotleLen = (int)((long)u32SecHeadLen + struDownloadInfo.downloadInfoLen.get() + (long)u32ParLen + 2L + (long)u32CrcLen);
        pstruDownloadControl.secBufAddr = new byte[u32TotleLen];
        Arrays.fill(pstruDownloadControl.secBufAddr, (byte)0);
        pstruDownloadControl.secLen.set((long)u32TotleLen);
        pstruDownloadControl.stSecHead.sectionLength.set((long)(u32TotleLen - 4));
        HisiTsPackageBuilder.fillSecHead(pstruDownloadControl.stSecHead, pstruDownloadControl.secBufAddr);
        byte[] pu8Temp = pstruDownloadControl.secBufAddr;
        int offset = u32SecHeadLen;
        pu8Temp[offset++] = (byte)struDownloadInfo.downloadInfoTag.get();
        pu8Temp[offset++] = (byte)struDownloadInfo.downloadInfoLen.get();
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.stbManufacturerId.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.hardwareVer.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.softwareVer.get());
        pu8Temp[offset++] = (byte)struDownloadInfo.downloadTableId.get();
        pu8Temp[offset++] = (byte)struDownloadInfo.keyControl.get();
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.serialNumberStart.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.serialNumberEnd.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.downloadDate.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.webBrowserVer.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.kernelVer.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.caVer.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.bootLoaderVer.get());
        offset = HisiTsPackageBuilder.alterU32ToU8(pu8Temp, offset, (int)struDownloadInfo.loaderVer.get());
        pu8Temp[offset++] = (byte)struDownloadInfo.hardwareStringLen.get();
        System.arraycopy(struDownloadInfo.hardwareStringDescriptor, 0, pu8Temp, offset, struDownloadInfo.hardwareStringLen.get());
        System.arraycopy(struDownloadInfo.downloadPartInfo, 0, pu8Temp, offset += struDownloadInfo.hardwareStringLen.get(), u32ParLen);
        u32CrcVal = Crc32.compute(pstruDownloadControl.secBufAddr, 1, u32TotleLen - u32CrcLen - 1);
        HisiTsPackageBuilder.alterU32ToU8(pstruDownloadControl.secBufAddr, u32TotleLen - u32CrcLen, u32CrcVal);
        pstruDownloadControl.secLen.set((long)u32TotleLen);
    }

    private static void memcpy(byte[] pTmp, int offset, String string, long len) {
        if (len > (long)string.length()) {
            len = string.length();
        }
        int i = 0;
        while ((long)i < len) {
            pTmp[offset++] = (byte)string.charAt(i);
            ++i;
        }
    }

    private static List<PartFile> fillFileDataStruct(List<UpgradeFileInfo> files) {
        g_u32DataMagicNum = HisiTsPackageBuilder.getRandomU32();
        g_u32DataCrc = -1;
        ArrayList<PartFile> headers = new ArrayList<PartFile>(files.size());
        int i = 0;
        while (i < files.size()) {
            PartFile partFile = new PartFile();
            headers.add(partFile);
            partFile.init(files.get(i));
            long fileLength = new File(partFile.fileName).length();
            long lastSectionLength = 992L;
            long sectionNum = fileLength / 992L;
            if (0L != fileLength % 992L) {
                lastSectionLength = fileLength % 992L;
                ++sectionNum;
            }
            long datagramNum = (sectionNum & 8L) == 0L ? sectionNum / 8L : sectionNum / 8L + 1L;
            partFile.setLastDiagramDataLength(lastSectionLength);
            partFile.datagramNum.set(datagramNum);
            partFile.setSectionNum(sectionNum);
            try {
                int[] crc = Crc32.compute(partFile.fileName, g_u32DataCrc);
                partFile.crcValue.set((long)crc[0]);
                g_u32DataCrc = crc[1];
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return headers;
    }

    @Override
    public IStatus createPackage(List<UpgradeFileInfo> fileInfoList, SsuUpgradeInfo info, SsuPackageOptions packageOtions, String tsFileName, IProgressMonitor monitor) throws IOException, HiLoaderException {
        return null;
    }
}

