/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.util;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.struct.UpgradeFileInfo;
import com.hisilicon.hiloader.ui.DialogUtil;
import com.hisilicon.hiloader.util.InvalidDataFormatException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileUtil {
    public static boolean canReadFile(String fileName, String errorMsg) {
        boolean res;
        File f = new File(fileName);
        boolean bl = res = f.exists() && f.canRead();
        if (!res && errorMsg != null) {
            DialogUtil.displayError(errorMsg);
        }
        return res;
    }

    public static boolean canWriteFile(String fileName, String errorMsg) {
        boolean res;
        File f = new File(fileName);
        try {
            boolean bl = res = f.createNewFile() || f.canWrite();
            if (!res && errorMsg != null) {
                DialogUtil.displayError(errorMsg);
            }
        }
        catch (IOException e) {
            if (errorMsg != null) {
                DialogUtil.displayError(errorMsg);
            }
            return false;
        }
        return res;
    }

    public static void deleteListFile(List<UpgradeFileInfo> infoList) {
        if (infoList == null || infoList.size() == 0) {
            return;
        }
        for (UpgradeFileInfo info : infoList) {
            FileUtil.deleteFile(info.getFileName());
        }
    }

    public static boolean deleteFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        File file = new File(fileName);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        long outTime = 5000L;
        while (!file.delete() && System.currentTimeMillis() - startTime < outTime) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return !file.exists();
    }

    public static boolean checkAddressConflict(UpgradeFileInfo newFile, List<UpgradeFileInfo> files) throws InvalidDataFormatException {
        if (files == null || files.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < files.size()) {
            UpgradeFileInfo file = files.get(i);
            if (file != null && !file.equals(newFile) && file.getFlashType() == newFile.getFlashType() && (file.getFlashIndex() & 0xFFFF) == (newFile.getFlashIndex() & 0xFFFF) && (file.getStartAddress() <= newFile.getStartAddress() && newFile.getStartAddress() < file.getEndAddress() || newFile.getStartAddress() <= file.getStartAddress() && file.getStartAddress() < newFile.getEndAddress())) {
                throw new InvalidDataFormatException(Messages.SelectFileDialog_39);
            }
            ++i;
        }
        return false;
    }

    public static boolean isContinue(String path) {
        File file = new File(path);
        boolean isOverWrite = true;
        if (file.isDirectory() || file.getPath().length() == 1) {
            MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.InvalidFileName);
            return false;
        }
        if (file.exists()) {
            isOverWrite = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.Information, (String)Messages.IsOverWrite);
        }
        return isOverWrite;
    }

    public static void setWidthForOS(GridData gridData, int windowsWidth, int linuxWidth) {
        String osName = System.getProperties().getProperty("os.name");
        gridData.widthHint = osName.toLowerCase().startsWith("windows") ? windowsWidth : linuxWidth;
    }
}

