/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import com.hisilicon.hiloader.Messages;
import com.hisilicon.hiloader.struct.UpgradeInfo;
import com.hisilicon.hiloader.ui.LabelTextField;
import com.hisilicon.hiloader.util.IniFileParser;
import com.hisilicon.hiloader.util.StringUtil;
import java.math.BigInteger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UpgradeInfoGroup {
    private LabelTextField downloadPid;
    private LabelTextField tableId;
    private LabelTextField manufacturerId;
    private LabelTextField hardwareId;
    private LabelTextField softwareId;
    private LabelTextField startSn;
    private LabelTextField endSn;
    private UpgradeInfo input;
    private static final String manufacturerIdMin = "0x0000";
    private static final String manufacturerIdMax = "0xFFFF";
    private static final String hardwareIdMin = "0x00000000";
    private static final String hardwareIdMax = "0xFFFFFFFF";
    private static final int labelWidth = 200;

    public UpgradeInfoGroup(Composite parent) {
        this.createControls(parent);
    }

    private void createControls(Composite group) {
        this.downloadPid = new LabelTextField(group, Messages.UpgradeInfoGroup_1, 200, null, "0x1b58", "0x20~0x1FFE");
        this.tableId = new LabelTextField(group, Messages.UpgradeInfoGroup_3, 200, null, "0xdd", "0x40~0xFF");
        this.manufacturerId = new LabelTextField(group, Messages.UpgradeInfoGroup_5, 200, null, "0x0003", "0x0000~0xFFFF");
        this.hardwareId = new LabelTextField(group, Messages.UpgradeInfoGroup_7, 200, null, "0x00000001", "0x00000000~0xFFFFFFFF");
        this.softwareId = new LabelTextField(group, Messages.UpgradeInfoGroup_9, 200, null, "0x01010101", "0x00000000~0xFFFFFFFF");
        this.startSn = new LabelTextField(group, Messages.UpgradeInfoGroup_Start_Sn, 200, null, hardwareIdMin, "0x00000000~0xFFFFFFFF");
        this.endSn = new LabelTextField(group, Messages.UpgradeInfoGroup_End_Sn, 200, null, "0xffffffff", "0x00000000~0xFFFFFFFF");
    }

    public void setInput(IniFileParser parse, UpgradeInfo info) {
        this.input = info;
        if (parse.getDownloadPid() != null) {
            this.downloadPid.getTextControl().setText(parse.getDownloadPid());
        }
        if (parse.getDownloadTableId() != null) {
            this.tableId.getTextControl().setText(parse.getDownloadTableId());
        }
        if (parse.getManufacturerId() != null) {
            this.manufacturerId.getTextControl().setText(parse.getManufacturerId());
        }
        if (parse.getHardwareVersion() != null) {
            this.hardwareId.getTextControl().setText(parse.getHardwareVersion());
        }
        if (parse.getSoftwareVersion() != null) {
            this.softwareId.getTextControl().setText(parse.getSoftwareVersion());
        }
        if (parse.getStartSn() != null) {
            this.startSn.getTextControl().setText(parse.getStartSn());
        }
        if (parse.getEndSn() != null) {
            this.endSn.getTextControl().setText(parse.getEndSn());
        }
    }

    public UpgradeInfo getInput() {
        if (this.input == null) {
            this.input = new UpgradeInfo();
        }
        this.input.setDownloadPid((int)StringUtil.convertString(this.getDownloadPid()));
        this.input.setDownloadTableId((int)StringUtil.convertString(this.getDownloadTableId()));
        this.input.setManufacturerId((int)StringUtil.convertString(this.getManufacturerId()));
        this.input.setHardwareVersion((int)StringUtil.convertString(this.getHardwareVersion()));
        this.input.setSoftwareVersion((int)StringUtil.convertString(this.getSoftwareVersion()));
        this.input.setStartSn((int)StringUtil.convertString(this.getStartSn()));
        this.input.setEndSn((int)StringUtil.convertString(this.getEndSn()));
        return this.input;
    }

    public boolean validateInput() {
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    try {
                                        if (StringUtil.hexInRange(this.downloadPid.getText(), "0x20", "0x1FFE")) break block10;
                                        this.showError(Messages.UpgradeInfoGroup_23);
                                        return false;
                                    }
                                    catch (NumberFormatException e) {
                                        this.showError(Messages.UpgradeInfoGroup_InputInvalid);
                                        return false;
                                    }
                                }
                                if (StringUtil.hexInRange(this.tableId.getText(), "0x40", "0xFF")) break block11;
                                this.showError(Messages.UpgradeInfoGroup_26);
                                return false;
                            }
                            if (StringUtil.hexInRange(this.manufacturerId.getText(), manufacturerIdMin, manufacturerIdMax)) break block12;
                            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_29, (Object[])new Object[]{manufacturerIdMin, manufacturerIdMax}));
                            return false;
                        }
                        if (StringUtil.hexInRange(this.hardwareId.getText(), hardwareIdMin, hardwareIdMax)) break block13;
                        this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_32, (Object[])new Object[]{hardwareIdMin, hardwareIdMax}));
                        return false;
                    }
                    if (StringUtil.hexInRange(this.softwareId.getText(), hardwareIdMin, hardwareIdMax)) break block14;
                    this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_35, (Object[])new Object[]{hardwareIdMin, hardwareIdMax}));
                    return false;
                }
                if (StringUtil.hexInRange(this.startSn.getText(), hardwareIdMin, hardwareIdMax)) break block15;
                this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_StartSnInputError, (Object[])new Object[]{hardwareIdMin, hardwareIdMax}));
                return false;
            }
            if (StringUtil.hexInRange(this.endSn.getText(), hardwareIdMin, hardwareIdMax)) break block16;
            this.showError(NLS.bind((String)Messages.UpgradeInfoGroup_EndSnInputError, (Object[])new Object[]{hardwareIdMin, hardwareIdMax}));
            return false;
        }
        BigInteger sn = StringUtil.toBigInteger(this.startSn.getText());
        BigInteger en = StringUtil.toBigInteger(this.endSn.getText());
        if (sn.compareTo(en) >= 0) {
            this.showError(Messages.UpgradeInfoGroup_StartSnAndEndSnInputError);
            return false;
        }
        return true;
    }

    private void showError(String message) {
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UpgradeInfoGroup_36, (String)message);
    }

    public boolean hasInputText() {
        return this.downloadPid.hasInputText(Messages.UpgradeInfoGroup_2) && this.tableId.hasInputText(Messages.UpgradeInfoGroup_4) && this.manufacturerId.hasInputText(Messages.UpgradeInfoGroup_13) && this.hardwareId.hasInputText(Messages.UpgradeInfoGroup_14) && this.softwareId.hasInputText(Messages.UpgradeInfoGroup_15) && this.startSn.hasInputText(Messages.UpgradeInfoGroup_start_sn_isEmpty) && this.endSn.hasInputText(Messages.UpgradeInfoGroup_end_sn_isEmpty);
    }

    public String getDownloadPid() {
        return this.downloadPid.getText();
    }

    public String getDownloadTableId() {
        return this.tableId.getText();
    }

    public String getManufacturerId() {
        return this.manufacturerId.getText();
    }

    public String getSoftwareVersion() {
        return this.softwareId.getText();
    }

    public String getHardwareVersion() {
        return this.hardwareId.getText();
    }

    public String getStartSn() {
        return this.startSn.getText();
    }

    public String getEndSn() {
        return this.endSn.getText();
    }
}

