/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.hiloader.ui;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ControlFactory {
    private static FormToolkit toolkit;

    public static Composite createComposite(Composite parent, int numColumns) {
        return ControlFactory.createCompositeEx(parent, numColumns, 768);
    }

    public static Composite createCompositeEx(Composite parent, int numColumns, int layoutMode) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(numColumns, true));
        composite.setLayoutData((Object)new GridData(layoutMode));
        ControlFactory.adapt((Control)composite);
        return composite;
    }

    public static Composite createStackComposite(Composite parent, int layoutMode) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new StackLayout());
        composite.setLayoutData((Object)new GridData(layoutMode));
        ControlFactory.adapt((Control)composite);
        return composite;
    }

    public static Label createLabel(Composite parent, String text, int widthHint, int heightHint, int style) {
        Label label = new Label(parent, style);
        label.setFont(parent.getFont());
        label.setText(text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = widthHint;
        gd.heightHint = heightHint;
        label.setLayoutData((Object)gd);
        ControlFactory.adapt((Control)label);
        return label;
    }

    public static Label createLabel(Composite parent, String text) {
        return ControlFactory.createLabel(parent, text, -1, -1, 16384);
    }

    public static Button createRadioButton(Composite group, String label, String value, SelectionListener listener) {
        Button button = new Button(group, 16400);
        button.setFont(group.getFont());
        button.setText(label);
        button.setData((Object)(value == null ? label : value));
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        data.widthHint = 80;
        button.setLayoutData((Object)data);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        ControlFactory.adapt((Control)button);
        return button;
    }

    public static Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        ControlFactory.adapt((Control)button);
        return button;
    }

    public static Text createTsTextField(Composite parent, int style, int width) {
        Text text = new Text(parent, style);
        GridData data = new GridData();
        data.widthHint = width;
        text.setLayoutData((Object)data);
        ControlFactory.adapt((Control)text);
        return text;
    }

    public static Text createTextField(Composite parent, int style) {
        Text text = new Text(parent, style);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        text.setLayoutData((Object)data);
        ControlFactory.adapt((Control)text);
        return text;
    }

    public static Group createGroup(Composite parent, String label, int nColumns) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setText(label);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        ControlFactory.adapt((Control)group);
        return group;
    }

    public static void adapt(Control control) {
        if (toolkit != null) {
            toolkit.adapt(control, false, false);
        }
    }

    public static void adaptComposit(Control control) {
        if (toolkit == null) {
            return;
        }
        toolkit.adapt(control, false, false);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                ControlFactory.adaptComposit(child);
                ++n2;
            }
        }
    }

    public static CCombo createSelectCCombo(Composite parent, String[] strdata, String selData, int style) {
        CCombo combo = new CCombo(parent, style);
        combo.setFont(parent.getFont());
        int i = 0;
        while (i < strdata.length) {
            combo.add(strdata[i]);
            ++i;
        }
        if (selData == null) {
            combo.select(0);
        } else {
            ControlFactory.selectCCombo(combo, selData);
        }
        ControlFactory.adapt((Control)combo);
        return combo;
    }

    public static void selectCCombo(CCombo combo, String selData) {
        int n_sel = combo.indexOf(selData);
        if (n_sel < 0) {
            n_sel = 0;
        }
        combo.select(n_sel);
    }

    public static void setFormToolkit(FormToolkit toolkit) {
        ControlFactory.toolkit = toolkit;
    }
}

