/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.model.Music.MusicParam;
import com.hisilicon.fastplay.model.Setting;
import com.hisilicon.fastplay.processor.MusicParamProcess;
import com.hisilicon.fastplay.processor.PrepareSetting;
import com.hisilicon.fastplay.ui.SettingComposite;
import com.hisilicon.fastplay.utility.HiToolUtils;
import java.io.File;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class MusicComposite
extends SettingComposite {
    private static final int MUSIC_VOLUME_MIN = 0;
    private static final int MUSIC_VOLUME_MAX = 100;
    private static final int MUSIC_VOLUME_INIT = 50;
    private static final int SPINNER_INC_VALUE = 1;
    private static final int SPINNER_PAGEINC_VALUE = 1;
    private static final int SPINNER_DIGITS_VALUE = 0;
    private static final int MUSIC_ACTUAL_TIME_MIN = 0;
    private static final int MUSIC_ACTUAL_TIME_MAX = 8000;
    private static final int WIDTH_HINT_10 = 10;
    private static final int WIDTH_HINT_30 = 30;
    private static final int WIDTH_HINT_60 = 60;
    private static final int WIDTH_HINT_80 = 80;
    private static final int U32_SAMPLE_SIZE = 48000;
    private static final int u32_BITRATE = 16;
    private Text musicFileText;
    private Combo comboMusicSwitch;
    private Spinner spinnerMusicVolume;
    private Text textMusicActualTime;
    private Text textMusicPlayTime;
    private String musicFilePath;
    private Button btnBindPlayTime;
    private String converFilePath;
    protected String[] musicSuffix = new String[]{".mp3", ".pcm", ".wav"};

    public MusicComposite(Composite parent, Setting setting) {
        super(parent, setting);
        this.paramServer = new MusicParamProcess();
    }

    @Override
    public PrepareSetting getSetting() {
        return (PrepareSetting)super.getSetting();
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout fatherGrid = new GridLayout(1, false);
        fatherGrid.marginHeight = 20;
        fatherGrid.verticalSpacing = 20;
        control.setLayout((Layout)fatherGrid);
        Group group = new Group(control, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.MusicComposite_Music_Param);
        group.setLayoutData((Object)new GridData(4, 1, true, false));
        Composite paramComposite = new Composite((Composite)group, 0);
        GridLayout paramLayout = new GridLayout(12, false);
        paramComposite.setLayout((Layout)paramLayout);
        paramComposite.setLayoutData((Object)new GridData(1808));
        Label lblMusicFile = new Label(paramComposite, 0);
        lblMusicFile.setText(Messages.MusicComposite_Music_File);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 10;
        this.musicFileText = new Text(paramComposite, 2048);
        this.musicFileText.setLayoutData((Object)gridData);
        this.musicFileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MusicComposite.this.musicFilePath = MusicComposite.this.musicFileText.getText();
            }
        });
        Button button = new Button(paramComposite, 0);
        button.setText(Messages.MusicComposite_Add_Button);
        gridData = new GridData();
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog dialog = new FileDialog(MusicComposite.this.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*", "*.mp3", "*.pcm", "*.wav"});
                dialog.setFileName(MusicComposite.this.musicFileText.getText());
                String filePath = dialog.open();
                if (filePath == null) {
                    return;
                }
                if (MusicComposite.this.checkMusicPath(filePath)) {
                    File converFile;
                    MusicParam musicParam = new MusicParam();
                    MusicComposite.this.musicFileText.setText(filePath);
                    musicParam.setMusicFilePath(filePath);
                    if (MusicComposite.this.paramServer.paramProcess(musicParam) == Status.OK_STATUS) {
                        MusicComposite.this.converFilePath = (String.valueOf(HiToolUtils.getInstallPath()) + "Resources/HiFastplay/AudioConvertTool" + File.separator + "auto.pcm").replace("\\", "/");
                        converFile = new File(MusicComposite.this.converFilePath);
                        if (!converFile.exists()) {
                            MusicComposite.this.musicFileText.setText("");
                            MessageDialog.openInformation((Shell)MusicComposite.this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_Convert_Fail);
                            return;
                        }
                    } else {
                        MusicComposite.this.musicFileText.setText("");
                        MessageDialog.openInformation((Shell)MusicComposite.this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_Convert_Fail);
                        return;
                    }
                    long fileLen = converFile.length();
                    int filePlayTime = MusicComposite.this.calculatePlayTime(fileLen, 48000.0, 16.0);
                    if (filePlayTime <= 0) {
                        MessageDialog.openInformation((Shell)MusicComposite.this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_Calculate_PlayTime_Fail);
                        return;
                    }
                    MusicComposite.this.textMusicActualTime.setText(String.valueOf(filePlayTime));
                    if (MusicComposite.this.btnBindPlayTime.getSelection()) {
                        MusicComposite.this.textMusicPlayTime.setText(String.valueOf(filePlayTime));
                    } else {
                        MusicComposite.this.textMusicPlayTime.setText(MusicComposite.this.textMusicPlayTime.getText());
                    }
                } else {
                    MusicComposite.this.musicFileText.setText("");
                }
            }
        });
        Label lblMusicSwitch = new Label(paramComposite, 0);
        lblMusicSwitch.setText(Messages.MusicComposite_Switch_INHIBIT);
        this.comboMusicSwitch = new Combo(paramComposite, 8);
        this.comboMusicSwitch.setItems(new String[]{"OFF", "ON"});
        this.comboMusicSwitch.select(1);
        this.comboMusicSwitch.setData((Object)MusicParam.BASE_MUSIC_PARAM.musicSwitch.name());
        gridData = new GridData();
        gridData.horizontalIndent = 10;
        gridData.widthHint = 30;
        this.comboMusicSwitch.setLayoutData((Object)gridData);
        Label lblMusicVolume = new Label(paramComposite, 0);
        lblMusicVolume.setText(Messages.MusicComposite_Volume);
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        lblMusicVolume.setLayoutData((Object)gridData);
        this.spinnerMusicVolume = this.createSpinner(paramComposite, 2048, 0, 50, 100, 1, 1, 0);
        this.spinnerMusicVolume.setData((Object)MusicParam.BASE_MUSIC_PARAM.musicVolume.name());
        gridData = new GridData();
        gridData.widthHint = 30;
        this.spinnerMusicVolume.setLayoutData((Object)gridData);
        this.addModifyListenerForSpinner(this.spinnerMusicVolume);
        Label lblMusicActualTime = new Label(paramComposite, 0);
        lblMusicActualTime.setText(Messages.MusicComposite_PlayTime);
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        lblMusicActualTime.setLayoutData((Object)gridData);
        this.textMusicPlayTime = new Text(paramComposite, 2048);
        this.textMusicPlayTime.setText("3000");
        this.textMusicPlayTime.setTextLimit(4);
        this.textMusicPlayTime.setEnabled(false);
        MusicComposite.addModifyListene(this.textMusicPlayTime);
        gridData = new GridData();
        gridData.widthHint = 60;
        this.textMusicPlayTime.setLayoutData((Object)gridData);
        Label lblms = new Label(paramComposite, 0);
        lblms.setText("(ms)");
        this.btnBindPlayTime = new Button(paramComposite, 32);
        this.btnBindPlayTime.setText(Messages.MusicComposite_AccordingSourceFile);
        this.btnBindPlayTime.setSelection(true);
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        gridData.verticalIndent = 2;
        this.btnBindPlayTime.setLayoutData((Object)gridData);
        this.btnBindPlayTime.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (MusicComposite.this.btnBindPlayTime.getSelection()) {
                    if (MusicComposite.this.textMusicActualTime != null) {
                        MusicComposite.this.textMusicPlayTime.setText(MusicComposite.this.textMusicActualTime.getText());
                    }
                    MusicComposite.this.textMusicPlayTime.setEnabled(false);
                } else {
                    MusicComposite.this.textMusicPlayTime.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblMusicPlayTime = new Label(paramComposite, 0);
        lblMusicPlayTime.setText(Messages.MusicComposite_SourceFilePlayTime);
        gridData = new GridData();
        gridData.horizontalIndent = 30;
        lblMusicPlayTime.setLayoutData((Object)gridData);
        this.textMusicActualTime = new Text(paramComposite, 2048);
        this.textMusicActualTime.setText("0");
        this.textMusicActualTime.setEnabled(false);
        MusicComposite.addModifyListene(this.textMusicActualTime);
        gridData = new GridData();
        gridData.widthHint = 60;
        this.textMusicActualTime.setLayoutData((Object)gridData);
        Label lblms2 = new Label(paramComposite, 0);
        lblms2.setText("(ms)");
        Button createButton = new Button(control, 0);
        createButton.setText(Messages.SettingComposite_0);
        createButton.setLayoutData((Object)new GridData(576));
        createButton.addListener(13, (Listener)new SettingComposite.CreateListener());
        return control;
    }

    @Override
    protected Object getParam() {
        MusicParam musicParam = new MusicParam();
        musicParam.setMusicSwitch(this.comboMusicSwitch.getSelectionIndex());
        musicParam.setMusicVolume(this.spinnerMusicVolume.getSelection());
        long actualDataSize = 0L;
        if (this.musicFileText.getText() != null && this.converFilePath != null) {
            actualDataSize = new File(this.converFilePath).length();
        }
        musicParam.setMusicActualDataSize((int)actualDataSize);
        String musicPlayTimeStr = this.textMusicPlayTime.getText();
        String musicActualTime = this.textMusicActualTime.getText();
        if (musicPlayTimeStr.equalsIgnoreCase(musicActualTime)) {
            musicParam.setMusicPlayDataSize(musicParam.getMusicActualDataSize());
        } else {
            int playDateSize = this.calculateDateSize(48000.0, 16.0, Double.valueOf(musicPlayTimeStr) / 1000.0);
            musicParam.setMusicPlayDataSize(playDateSize);
        }
        musicParam.setMusicFilePath(this.converFilePath);
        this.getSetting().setParamObj(musicParam);
        return musicParam;
    }

    @Override
    protected boolean checkInfo(Object objParam) {
        return true;
    }

    @Override
    protected boolean checkAllTextValue() {
        String textMusicActualTimeValue;
        int musicActualTimeValue;
        if (!this.musicFileText.isDisposed() && (this.musicFileText.getText() == null || this.musicFileText.getText().equals(""))) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_File_Not_Exit);
            return false;
        }
        if (!this.textMusicActualTime.isDisposed() && !this.checkTextValue(this.textMusicActualTime, 0, 8000)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.MusicComposite_SourceFilePlayTime) + Messages.ValidityCheck_EnterIntNumbers_Range + String.valueOf(0) + " " + Messages.ValidityCheck_EnterIntNumbers_To + String.valueOf(8000) + "!"));
            return false;
        }
        if (!this.textMusicPlayTime.isDisposed() && !this.checkTextValue(this.textMusicPlayTime, 0, musicActualTimeValue = Integer.parseInt(textMusicActualTimeValue = this.textMusicActualTime.getText()))) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.MusicComposite_PlayTime) + Messages.ValidityCheck_EnterIntNumbers_Range + String.valueOf(0) + " " + Messages.ValidityCheck_EnterIntNumbers_To + String.valueOf(musicActualTimeValue) + "!"));
            return false;
        }
        if (!this.spinnerMusicVolume.isDisposed() && !this.checkTextValue(this.spinnerMusicVolume, 0, 100)) {
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.commom_msg_warning, (String)(String.valueOf(Messages.MusicComposite_Volume) + Messages.ValidityCheck_EnterIntNumbers_Range + String.valueOf(0) + " " + Messages.ValidityCheck_EnterIntNumbers_To + String.valueOf(100) + "!"));
            return false;
        }
        return true;
    }

    private boolean checkMusicPath(String fileName) {
        if (fileName == null || "".equals(fileName)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_File_Path_Error);
            return false;
        }
        if (!new File(fileName).exists()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_File_Not_Exit);
            return false;
        }
        if (!this.checkMusicSuffix(fileName)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.MusicComposite_Invalid_Music_File);
            return false;
        }
        return true;
    }

    private boolean checkMusicSuffix(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return false;
        }
        String suffix = fileName.substring(index);
        String[] stringArray = this.musicSuffix;
        int n = this.musicSuffix.length;
        int n2 = 0;
        while (n2 < n) {
            String su = stringArray[n2];
            if (su.equalsIgnoreCase(suffix)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private int calculatePlayTime(double u32DataPlayLen, double u32Samplesize, double u32BitRate) {
        double filePlayTime = u32DataPlayLen * 8.0 / (u32Samplesize * u32BitRate * 2.0);
        DecimalFormat df = new DecimalFormat(".000");
        String filePlayTimeStr = df.format(filePlayTime);
        return Integer.parseInt(new DecimalFormat("0").format(Double.valueOf(filePlayTimeStr) * 1000.0));
    }

    private int calculateDateSize(double u32Samplesize, double u32BitRate, double u32PlayTime) {
        double u32DataPlayLen = u32Samplesize * u32BitRate * 2.0 * u32PlayTime / 8.0;
        return Integer.parseInt(new DecimalFormat("0").format((Object)u32DataPlayLen));
    }

    public String getMusicFilePath() {
        return this.musicFilePath;
    }

    public void setMusicFilePath(String musicFilePath) {
        this.musicFilePath = musicFilePath;
    }

    public String getConverFilePath() {
        return this.converFilePath;
    }

    public void setConverFilePath(String converFilePath) {
        this.converFilePath = converFilePath;
    }
}

