/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastplay.ui;

import com.hisilicon.fastplay.Messages;
import com.hisilicon.fastplay.hi.baseparam.HI_UNF_DISP;
import com.hisilicon.fastplay.model.baseparam.DispParamObj;
import com.hisilicon.fastplay.model.baseparam.WidgetParam;
import com.hisilicon.fastplay.ui.SettingComposite;
import com.hisilicon.fastplay.utility.CommonUtil;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DispTimingDialog
extends Dialog {
    private Pattern patten = Pattern.compile("^[0-9]*$");
    private DispParamObj dispParamObj;
    private DispParamObj lastDispParamObj;
    private WidgetParam wgetParam;
    private int dispIndex;
    private Text text_VFB;
    private Text text_VBB;
    private Text text_VACT;
    private Text text_HFB;
    private Text text_HBB;
    private Text text_HACT;
    private Text text_VPW;
    private Text text_ClkPara0;
    private Text text_ClkPara1;
    private Text text_PixFreq;
    private Text text_HPW;
    private Text text_VertFreq;
    private Text text_AspectRatioW;
    private Text text_AspectRatioH;
    private Combo combo_DataWidth;
    private Combo combo_ItfFormat;
    private Button btn_IDV;
    private Button btn_IHS;
    private Button btn_IVS;
    private Button btn_ClockReversal;
    private Button btn_DitherEnable;
    private Button btn_bInterlace;

    protected DispTimingDialog(Shell comShell, WidgetParam wgetParam, int dispIndex) {
        super(comShell);
        this.wgetParam = wgetParam;
        this.dispIndex = dispIndex;
    }

    protected Control createContents(Composite parent) {
        parent.getShell().setText(Messages.BaseparamComposite_DispTimingDialog_title);
        parent.setSize(880, 300);
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(8, true));
        GridData gridData = new GridData(1808);
        com.setLayoutData((Object)gridData);
        Label label_VFB = new Label(com, 0);
        label_VFB.setText(Messages.BaseparamComposite_DispTimingDialog_VFB);
        this.text_VFB = new Text(com, 2048);
        this.text_VFB.setText("3");
        this.text_VFB.setTextLimit(8);
        this.text_VFB.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vfb.name());
        this.addModifyListene(this.text_VFB);
        this.fillHorizontal((Control)this.text_VFB);
        Label label_VBB = new Label(com, 0);
        label_VBB.setText(Messages.BaseparamComposite_DispTimingDialog_VBB);
        this.text_VBB = new Text(com, 2048);
        this.text_VBB.setText("35");
        this.text_VBB.setTextLimit(8);
        this.text_VBB.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vbb.name());
        this.addModifyListene(this.text_VBB);
        this.fillHorizontal((Control)this.text_VBB);
        Label label_VACT = new Label(com, 0);
        label_VACT.setText(Messages.BaseparamComposite_DispTimingDialog_VACT);
        this.text_VACT = new Text(com, 2048);
        this.text_VACT.setText("768");
        this.text_VACT.setTextLimit(8);
        this.text_VACT.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vact.name());
        this.addModifyListene(this.text_VACT);
        this.fillHorizontal((Control)this.text_VACT);
        Label label_HFB = new Label(com, 0);
        label_HFB.setText(Messages.BaseparamComposite_DispTimingDialog_HFB);
        this.text_HFB = new Text(com, 2048);
        this.text_HFB.setText("24");
        this.text_HFB.setTextLimit(8);
        this.text_HFB.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hfb.name());
        this.addModifyListene(this.text_HFB);
        this.fillHorizontal((Control)this.text_HFB);
        Label label_HBB = new Label(com, 0);
        label_HBB.setText(Messages.BaseparamComposite_DispTimingDialog_HBB);
        this.text_HBB = new Text(com, 2048);
        this.text_HBB.setText("296");
        this.text_HBB.setTextLimit(8);
        this.text_HBB.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hbb.name());
        this.addModifyListene(this.text_HBB);
        this.fillHorizontal((Control)this.text_HBB);
        Label label_HACT = new Label(com, 0);
        label_HACT.setText(Messages.BaseparamComposite_DispTimingDialog_HACT);
        this.text_HACT = new Text(com, 2048);
        this.text_HACT.setText("1024");
        this.text_HACT.setTextLimit(8);
        this.text_HACT.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hact.name());
        this.addModifyListene(this.text_HACT);
        this.fillHorizontal((Control)this.text_HACT);
        Label label_VPW = new Label(com, 0);
        label_VPW.setText(Messages.BaseparamComposite_DispTimingDialog_VPW);
        this.text_VPW = new Text(com, 2048);
        this.text_VPW.setText("6");
        this.text_VPW.setTextLimit(8);
        this.text_VPW.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vpw.name());
        this.addModifyListene(this.text_VPW);
        this.fillHorizontal((Control)this.text_VPW);
        Label label_HPW = new Label(com, 0);
        label_HPW.setText(Messages.BaseparamComposite_DispTimingDialog_HPW);
        this.text_HPW = new Text(com, 2048);
        this.text_HPW.setText("136");
        this.text_HPW.setTextLimit(8);
        this.text_HPW.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.hpw.name());
        this.addModifyListene(this.text_HPW);
        this.fillHorizontal((Control)this.text_HPW);
        Label label_ClkPara0 = new Label(com, 0);
        label_ClkPara0.setText(Messages.BaseparamComposite_DispTimingDialog_ClkPara0);
        this.text_ClkPara0 = new Text(com, 2048);
        this.text_ClkPara0.setText("0x15000000");
        this.text_ClkPara0.setTextLimit(10);
        this.text_ClkPara0.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.clkPara0.name());
        this.fillHorizontal((Control)this.text_ClkPara0);
        Label label_ClkPara1 = new Label(com, 0);
        label_ClkPara1.setText(Messages.BaseparamComposite_DispTimingDialog_ClkPara1);
        this.text_ClkPara1 = new Text(com, 2048);
        this.text_ClkPara1.setText("0x201954a");
        this.text_ClkPara1.setTextLimit(10);
        this.text_ClkPara1.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.clkPara1.name());
        this.fillHorizontal((Control)this.text_ClkPara1);
        Label label_PixFreq = new Label(com, 0);
        label_PixFreq.setText(Messages.BaseparamComposite_DispTimingDialog_PixFreq);
        this.text_PixFreq = new Text(com, 2048);
        this.text_PixFreq.setText("65000");
        this.text_PixFreq.setTextLimit(8);
        this.text_PixFreq.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.pixFreq.name());
        this.addModifyListene(this.text_PixFreq);
        this.fillHorizontal((Control)this.text_PixFreq);
        Label label_VertFreq = new Label(com, 0);
        label_VertFreq.setText(Messages.BaseparamComposite_DispTimingDialog_VertFreq);
        this.text_VertFreq = new Text(com, 2048);
        this.text_VertFreq.setText("60000");
        this.text_VertFreq.setTextLimit(8);
        this.text_VertFreq.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.vertFreq.name());
        this.addModifyListene(this.text_VertFreq);
        this.fillHorizontal((Control)this.text_VertFreq);
        Label label_AspectRatioW = new Label(com, 0);
        label_AspectRatioW.setText(Messages.BaseparamComposite_DispTimingDialog_AspectRatioW);
        this.text_AspectRatioW = new Text(com, 2048);
        this.text_AspectRatioW.setText("4");
        this.text_AspectRatioW.setTextLimit(8);
        this.text_AspectRatioW.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.aspectRatioW.name());
        this.addModifyListene(this.text_AspectRatioW);
        this.fillHorizontal((Control)this.text_AspectRatioW);
        Label label_AspectRatioH = new Label(com, 0);
        label_AspectRatioH.setText(Messages.BaseparamComposite_DispTimingDialog_AspectRatioH);
        this.text_AspectRatioH = new Text(com, 2048);
        this.text_AspectRatioH.setText("3");
        this.text_AspectRatioH.setTextLimit(8);
        this.text_AspectRatioH.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.aspectRatioH.name());
        this.addModifyListene(this.text_AspectRatioH);
        this.fillHorizontal((Control)this.text_AspectRatioH);
        Label label_DataWidth = new Label(com, 0);
        label_DataWidth.setText(Messages.BaseparamComposite_DispTimingDialog_DataWidth);
        this.combo_DataWidth = new Combo(com, 8);
        this.combo_DataWidth.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.dataWidth.name());
        this.combo_DataWidth.setItems(CommonUtil.getEnumNames((Object[])HI_UNF_DISP.HI_UNF_DISP_INTF_DATA_WIDTH_E.values()));
        this.combo_DataWidth.select(2);
        this.fillHorizontal((Control)this.combo_DataWidth);
        Label label_ItfFormat = new Label(com, 0);
        label_ItfFormat.setText(Messages.BaseparamComposite_DispTimingDialog_ItfFormat);
        this.combo_ItfFormat = new Combo(com, 8);
        this.combo_ItfFormat.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.itfFormat.name());
        this.combo_ItfFormat.setItems(CommonUtil.getEnumNames((Object[])HI_UNF_DISP.HI_HI_UNF_DISP_INTF_DATA_FMT.values()));
        this.combo_ItfFormat.select(4);
        this.fillHorizontal((Control)this.combo_ItfFormat);
        this.btn_IDV = new Button(com, 32);
        this.btn_IDV.setText(Messages.BaseparamComposite_DispTimingDialog_IDV);
        this.btn_IDV.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.idv.name());
        this.beginHorizontal((Control)this.btn_IDV);
        this.btn_IHS = new Button(com, 32);
        this.btn_IHS.setText(Messages.BaseparamComposite_DispTimingDialog_IHS);
        this.btn_IHS.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ihs.name());
        this.beginHorizontal((Control)this.btn_IHS);
        this.btn_IVS = new Button(com, 32);
        this.btn_IVS.setText(Messages.BaseparamComposite_DispTimingDialog_IVS);
        this.btn_IVS.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ivs.name());
        this.beginHorizontal((Control)this.btn_IVS);
        this.btn_DitherEnable = new Button(com, 32);
        this.btn_DitherEnable.setText(Messages.BaseparamComposite_DispTimingDialog_DitherEnable);
        this.btn_DitherEnable.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.ditherEnable.name());
        this.beginHorizontal((Control)this.btn_DitherEnable);
        this.btn_bInterlace = new Button(com, 32);
        this.btn_bInterlace.setText(Messages.BaseparamComposite_DispTimingDialog_bInterlace);
        this.btn_bInterlace.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.bInterlace.name());
        this.beginHorizontal((Control)this.btn_bInterlace);
        this.btn_ClockReversal = new Button(com, 32);
        this.btn_ClockReversal.setText(Messages.BaseparamComposite_DispTimingDialog_ClockReversal);
        this.btn_ClockReversal.setData((Object)DispParamObj.BASE_DISP_ATTRNAME.clockReversal.name());
        this.beginHorizontal((Control)this.btn_ClockReversal);
        this.saveTimingParam();
        return super.createContents(parent);
    }

    protected GridData fillHorizontal(Control control) {
        GridData layoutData = new GridData(768);
        control.setLayoutData((Object)layoutData);
        return layoutData;
    }

    protected GridData beginHorizontal(Control control) {
        GridData btnGridData = new GridData(1, 1, true, true);
        control.setLayoutData((Object)btnGridData);
        return btnGridData;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.getTimingParamValue()) {
                this.okPressed();
            }
        } else if (1 == buttonId) {
            this.cancelPressed();
        }
    }

    private boolean getTimingParamValue() {
        if (!this.checkTimingParam()) {
            return false;
        }
        this.dispParamObj = new DispParamObj();
        this.dispParamObj.setVfb(Integer.parseInt(this.text_VFB.getText()));
        this.dispParamObj.setVbb(Integer.parseInt(this.text_VBB.getText()));
        this.dispParamObj.setVact(Integer.parseInt(this.text_VACT.getText()));
        this.dispParamObj.setHfb(Integer.parseInt(this.text_HFB.getText()));
        this.dispParamObj.setHbb(Integer.parseInt(this.text_HBB.getText()));
        this.dispParamObj.setHact(Integer.parseInt(this.text_HACT.getText()));
        this.dispParamObj.setVpw(Integer.parseInt(this.text_VPW.getText()));
        String strClkPara0 = this.text_ClkPara0.getText();
        String strClkPara1 = this.text_ClkPara1.getText();
        if (strClkPara0.startsWith("0x") || strClkPara0.startsWith("0X")) {
            strClkPara0 = strClkPara0.substring(2, strClkPara0.length());
        }
        if (strClkPara1.startsWith("0x") || strClkPara1.startsWith("0X")) {
            strClkPara1 = strClkPara1.substring(2, strClkPara1.length());
        }
        long clkPara0 = Long.valueOf(strClkPara0, 16);
        long clkPara1 = Long.valueOf(strClkPara1, 16);
        this.dispParamObj.setClkPara0((int)clkPara0);
        this.dispParamObj.setClkPara1((int)clkPara1);
        this.dispParamObj.setPixFreq(Integer.parseInt(this.text_PixFreq.getText()));
        this.dispParamObj.setHpw(Integer.parseInt(this.text_HPW.getText()));
        this.dispParamObj.setVertFreq(Integer.parseInt(this.text_VertFreq.getText()));
        this.dispParamObj.setAspectRatioW(Integer.parseInt(this.text_AspectRatioW.getText()));
        this.dispParamObj.setAspectRatioH(Integer.parseInt(this.text_AspectRatioH.getText()));
        this.dispParamObj.setDataWidth(this.combo_DataWidth.getSelectionIndex());
        this.dispParamObj.setItfFormat(this.combo_ItfFormat.getSelectionIndex());
        this.dispParamObj.setIdv(this.booleanToInt(this.btn_IDV.getSelection()));
        this.dispParamObj.setIhs(this.booleanToInt(this.btn_IHS.getSelection()));
        this.dispParamObj.setIvs(this.booleanToInt(this.btn_IVS.getSelection()));
        this.dispParamObj.setClockReversal(this.booleanToInt(this.btn_ClockReversal.getSelection()));
        this.dispParamObj.setDitherEnable(this.booleanToInt(this.btn_DitherEnable.getSelection()));
        this.dispParamObj.setbInterlace(this.booleanToInt(this.btn_bInterlace.getSelection()));
        return true;
    }

    private void saveTimingParam() {
        this.lastDispParamObj = this.wgetParam.getDispTimingDispParamObj().get(this.dispIndex);
        if (this.lastDispParamObj == null) {
            return;
        }
        this.text_VFB.setText(String.valueOf(this.lastDispParamObj.getVfb()));
        this.text_VBB.setText(String.valueOf(this.lastDispParamObj.getVbb()));
        this.text_VACT.setText(String.valueOf(this.lastDispParamObj.getVact()));
        this.text_HFB.setText(String.valueOf(this.lastDispParamObj.getHfb()));
        this.text_HBB.setText(String.valueOf(this.lastDispParamObj.getHbb()));
        this.text_HACT.setText(String.valueOf(this.lastDispParamObj.getHact()));
        this.text_VPW.setText(String.valueOf(this.lastDispParamObj.getVpw()));
        String clkPara0 = String.valueOf(Integer.toHexString(this.lastDispParamObj.getClkPara0()));
        String clkPara1 = String.valueOf(Integer.toHexString(this.lastDispParamObj.getClkPara1()));
        if (clkPara0 != null && !clkPara0.startsWith("0x")) {
            clkPara0 = "0x" + clkPara0;
        }
        if (clkPara1 != null && !clkPara1.startsWith("0x")) {
            clkPara1 = "0x" + clkPara1;
        }
        this.text_ClkPara0.setText(clkPara0);
        this.text_ClkPara1.setText(clkPara1);
        this.text_PixFreq.setText(String.valueOf(this.lastDispParamObj.getPixFreq()));
        this.text_HPW.setText(String.valueOf(this.lastDispParamObj.getHpw()));
        this.text_VertFreq.setText(String.valueOf(this.lastDispParamObj.getVertFreq()));
        this.text_AspectRatioW.setText(String.valueOf(this.lastDispParamObj.getAspectRatioW()));
        this.text_AspectRatioH.setText(String.valueOf(this.lastDispParamObj.getAspectRatioH()));
        this.combo_DataWidth.select(this.lastDispParamObj.getDataWidth());
        this.combo_ItfFormat.select(this.lastDispParamObj.getItfFormat());
        this.btn_IDV.setSelection(this.IntToBoolean(this.lastDispParamObj.getIdv()));
        this.btn_IHS.setSelection(this.IntToBoolean(this.lastDispParamObj.getIhs()));
        this.btn_IVS.setSelection(this.IntToBoolean(this.lastDispParamObj.getIvs()));
        this.btn_ClockReversal.setSelection(this.IntToBoolean(this.lastDispParamObj.getClockReversal()));
        this.btn_DitherEnable.setSelection(this.IntToBoolean(this.lastDispParamObj.getDitherEnable()));
        this.btn_bInterlace.setSelection(this.IntToBoolean(this.lastDispParamObj.getbInterlace()));
    }

    private boolean checkTimingParam() {
        int pixFreq = Integer.parseInt(this.text_PixFreq.getText());
        int vertFreq = Integer.parseInt(this.text_VertFreq.getText());
        String strClkPara0 = this.text_ClkPara0.getText();
        String strClkPara1 = this.text_ClkPara1.getText();
        if (strClkPara0 == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ClkPara0 " + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        if (strClkPara1 == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ClkPara1 " + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        if (strClkPara0.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ClkPara0 " + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        if (strClkPara1.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)("ClkPara1 " + Messages.Composite_Text_Can_Not_Empty));
            return false;
        }
        if (!SettingComposite.isValidHexString(strClkPara0)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.ClkPara0_execed);
            return false;
        }
        if (!SettingComposite.isValidHexString(strClkPara1)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.commom_msg_warning, (String)Messages.ClkPara1_execed);
            return false;
        }
        if (strClkPara0.startsWith("0x") || strClkPara0.startsWith("0X")) {
            strClkPara0 = strClkPara0.substring(2, strClkPara0.length());
        }
        if (strClkPara1.startsWith("0x") || strClkPara1.startsWith("0X")) {
            strClkPara1 = strClkPara1.substring(2, strClkPara1.length());
        }
        long clkPara0 = Long.valueOf(strClkPara0, 16);
        long clkPara1 = Long.valueOf(strClkPara1, 16);
        if (clkPara0 >= Long.valueOf("ffffffff", 16)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.ClkPara0_execed);
            return false;
        }
        if (clkPara1 >= Long.valueOf("ffffffff", 16)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.ClkPara1_execed);
            return false;
        }
        if (pixFreq < 20000 || pixFreq > 600000) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.PixFreq_size_execed);
            return false;
        }
        if (vertFreq >= 120000) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SettingComposite_14, (String)Messages.VertFreq_size_execed);
            return false;
        }
        return true;
    }

    private int booleanToInt(boolean bool) {
        return bool ? 1 : 0;
    }

    private boolean IntToBoolean(int i) {
        return i == 1;
    }

    protected void addModifyListene(Text text) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String textStr = text.getText();
                if (textStr == null) {
                    return;
                }
                if (textStr.isEmpty()) {
                    text.setText("0");
                    return;
                }
                if (!DispTimingDialog.this.patten.matcher(textStr).matches()) {
                    text.setText("0");
                    return;
                }
            }
        });
    }

    public DispParamObj getDispParamObj() {
        return this.dispParamObj;
    }

    public void setDispParamObj(DispParamObj dispParamObj) {
        this.dispParamObj = dispParamObj;
    }

    public DispParamObj getLastDispParamObj() {
        return this.lastDispParamObj;
    }

    public void setLastDispParamObj(DispParamObj lastDispParamObj) {
        this.lastDispParamObj = lastDispParamObj;
    }
}

