/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.utilitily.ConvertUtils;
import java.util.ArrayList;
import org.eclipse.osgi.util.NLS;

public class PropertiesUtility {
    public static final String DEVICE_SETTING_FOLDER = "Resources/Common/ChipProperties/";
    public static final int GET_INT_VALUE_ERROR = -1;
    private static ArrayList<UDProperty> properties = new ArrayList();
    protected boolean convertSuccess;

    protected static UDProperty get(String key) {
        for (UDProperty prop : properties) {
            if (!key.equals(prop.getKey())) continue;
            return prop;
        }
        return null;
    }

    public boolean loadFromFile(String chipName) {
        return false;
    }

    public void set(String key, String value) {
        UDProperty prop = PropertiesUtility.get(key);
        if (prop != null) {
            prop.setValue(value);
        } else {
            properties.add(new UDProperty(key, value));
        }
    }

    public static String queryForString(String key) {
        UDProperty prop = PropertiesUtility.get(key);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public Integer queryForInteger(String key) {
        UDProperty prop = PropertiesUtility.get(key);
        if (prop != null) {
            int rtValue;
            try {
                if (prop.getValue().toLowerCase().startsWith("0x")) {
                    Long tmpNum = Long.parseLong(prop.getValue().substring(2), 16);
                    rtValue = tmpNum.intValue();
                } else {
                    rtValue = Integer.parseInt(prop.getValue());
                }
            }
            catch (NumberFormatException e) {
                return null;
            }
            return rtValue;
        }
        return null;
    }

    protected boolean getParamBoolValue(String keyName, String fileName) {
        this.convertSuccess = false;
        String keyValueStr = PropertiesUtility.queryForString(keyName);
        if (keyValueStr != null && !keyValueStr.isEmpty()) {
            try {
                boolean result = ConvertUtils.stringToBoolean(keyValueStr);
                this.convertSuccess = true;
                return result;
            }
            catch (NumberFormatException e) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
                this.convertSuccess = false;
                return false;
            }
        }
        Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
        this.convertSuccess = false;
        return false;
    }

    protected int getParamIntValue(String keyName, String fileName) {
        String keyValueStr = PropertiesUtility.queryForString(keyName);
        if (keyValueStr != null && !keyValueStr.isEmpty()) {
            try {
                return ConvertUtils.stringToInt(keyValueStr);
            }
            catch (NumberFormatException e) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
                return -1;
            }
        }
        Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
        return -1;
    }

    protected String getParamStringValue(String keyName, String fileName) {
        String keyValueStr = PropertiesUtility.queryForString(keyName);
        if (keyValueStr != null && !keyValueStr.isEmpty()) {
            try {
                return keyValueStr;
            }
            catch (NumberFormatException e) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
                return null;
            }
        }
        Log.errorln(NLS.bind((String)Messages.MESSAGE_ERROR_PARAMETER_INPUT, (Object)keyName, (Object)fileName));
        return null;
    }

    static class UDProperty {
        private String key;
        private String value;

        UDProperty(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.getKey()) + "=" + this.getValue();
        }
    }
}

