/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.FT_STATUS;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class I2cUtils {
    public static int getbaudRateValue(String baudRateStr) {
        int baudRate = 0;
        if (baudRateStr.contains("k")) {
            baudRateStr = baudRateStr.substring(0, baudRateStr.indexOf("k"));
            baudRate = Integer.parseInt(baudRateStr) * 1000;
        } else if (baudRateStr.contains("K")) {
            baudRateStr = baudRateStr.substring(0, baudRateStr.indexOf("K"));
            baudRate = Integer.parseInt(baudRateStr) * 1000;
        } else {
            baudRate = Integer.parseInt(baudRateStr);
        }
        return baudRate;
    }

    public static <T> FT_STATUS getEnum(int index) {
        Class<FT_STATUS> clazz = FT_STATUS.class;
        T[] c = clazz.getEnumConstants();
        return (FT_STATUS)((Object)c[index]);
    }

    public static boolean checkI2cReturn(int input) {
        FT_STATUS returnValue = I2cUtils.getEnum(input);
        boolean result = false;
        switch (returnValue) {
            case FT_OK: {
                result = true;
                break;
            }
            case FT_INVALID_HANDLE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_HANDLE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_FOUND: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_FOUND);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED);
                    }
                });
                break;
            }
            case FT_IO_ERROR: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_IO_ERROR);
                    }
                });
                break;
            }
            case FT_INSUFFICIENT_RESOURCES: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INSUFFICIENT_RESOURCES);
                    }
                });
                break;
            }
            case FT_INVALID_PARAMETER: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_PARAMETER);
                    }
                });
                break;
            }
            case FT_INVALID_BAUD_RATE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_BAUD_RATE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_ERASE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED_FOR_ERASE);
                    }
                });
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_WRITE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_NOT_OPENED_FOR_WRITE);
                    }
                });
                break;
            }
            case FT_FAILED_TO_WRITE_DEVICE: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_FAILED_TO_WRITE_DEVICE);
                    }
                });
                break;
            }
            case FT_EEPROM_READ_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_READ_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_WRITE_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_WRITE_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_ERASE_FAILED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_ERASE_FAILED);
                    }
                });
                break;
            }
            case FT_EEPROM_NOT_PRESENT: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_NOT_PRESENT);
                    }
                });
                break;
            }
            case FT_EEPROM_NOT_PROGRAMMED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_EEPROM_NOT_PROGRAMMED);
                    }
                });
                break;
            }
            case FT_INVALID_ARGS: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_INVALID_ARGS);
                    }
                });
                break;
            }
            case FT_NOT_SUPPORTED: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_NOT_SUPPORTED);
                    }
                });
                break;
            }
            case FT_OTHER_ERROR: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_OTHER_ERROR);
                    }
                });
                break;
            }
            case FT_DEVICE_LIST_NOT_READY: {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Message_INFO, (String)Messages.Message_FT_DEVICE_LIST_NOT_READY);
                    }
                });
                break;
            }
        }
        return result;
    }

    public static void setMonitorMessage(IFastbootProgressMonitor fastbootMonitor, String message) {
        if (fastbootMonitor != null) {
            fastbootMonitor.errorln(message);
            fastbootMonitor.getEvent().setMessage(message);
        }
    }

    public static boolean checkI2cReturn(int input, IFastbootProgressMonitor fastbootMonitor) {
        FT_STATUS returnValue = I2cUtils.getEnum(input);
        boolean result = false;
        switch (returnValue) {
            case FT_OK: {
                result = true;
                break;
            }
            case FT_INVALID_HANDLE: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_INVALID_HANDLE);
                break;
            }
            case FT_DEVICE_NOT_FOUND: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_DEVICE_NOT_FOUND);
                break;
            }
            case FT_DEVICE_NOT_OPENED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_DEVICE_NOT_OPENED);
                break;
            }
            case FT_IO_ERROR: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_IO_ERROR);
                break;
            }
            case FT_INSUFFICIENT_RESOURCES: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_INSUFFICIENT_RESOURCES);
                break;
            }
            case FT_INVALID_PARAMETER: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_INVALID_PARAMETER);
                break;
            }
            case FT_INVALID_BAUD_RATE: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_INVALID_BAUD_RATE);
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_ERASE: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_DEVICE_NOT_OPENED_FOR_ERASE);
                break;
            }
            case FT_DEVICE_NOT_OPENED_FOR_WRITE: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_DEVICE_NOT_OPENED_FOR_WRITE);
                break;
            }
            case FT_FAILED_TO_WRITE_DEVICE: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_FAILED_TO_WRITE_DEVICE);
                break;
            }
            case FT_EEPROM_READ_FAILED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_EEPROM_READ_FAILED);
                break;
            }
            case FT_EEPROM_WRITE_FAILED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_EEPROM_WRITE_FAILED);
                break;
            }
            case FT_EEPROM_ERASE_FAILED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_EEPROM_ERASE_FAILED);
                break;
            }
            case FT_EEPROM_NOT_PRESENT: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_EEPROM_NOT_PRESENT);
                break;
            }
            case FT_EEPROM_NOT_PROGRAMMED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_EEPROM_NOT_PROGRAMMED);
                break;
            }
            case FT_INVALID_ARGS: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_INVALID_ARGS);
                break;
            }
            case FT_NOT_SUPPORTED: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_NOT_SUPPORTED);
                break;
            }
            case FT_OTHER_ERROR: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_OTHER_ERROR);
                break;
            }
            case FT_DEVICE_LIST_NOT_READY: {
                I2cUtils.setMonitorMessage(fastbootMonitor, Messages.Message_FT_DEVICE_LIST_NOT_READY);
                break;
            }
        }
        return result;
    }
}

