/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import com.hisilicon.fastboot.Activator;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.ProductLine;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.utilitily.JarUtility;
import com.hisilicon.fastboot.views.CmdMain;
import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.chips.Chip;
import com.soyatec.hisilicon.platform.api.chips.Tool;
import com.soyatec.hisilicon.platform.ui.internal.IniUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.layout.GridData;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class HiToolUtils {
    public static final String PRODUCTLINESSTR = "ProductLines";
    public static final String PRODUCTLINESTR = "ProductLine";
    public static final String ID = "id";
    public static final String TOOLREFNAME = "HiBurn";
    public static final String NAME = "name";
    public static final String PARAM = "param";
    public static final String TOOLREF = "ToolRef";
    public static final String CHIP = "Chip";
    public static final String JAVAHEASPACE = "Java heap space";
    public static final String ALLHOSTADDRESS = "0.0.0.0";
    public static final int SINGLESIZE = 0x100000;
    private static final String DEFAULT_TFTP_PORT_CMD = "cmd.exe /c netstat -aon|findstr :";
    private static final String DEFAULT_TFTP_PORT_LINUX_CMD = "/bin/sh -c netstat -tunlp|grep :";
    private static boolean isCmdLine = false;
    private static ToolType toolType;

    public static String getInstallPath() {
        if (HiToolUtils.isCmdLine()) {
            String jarDir = JarUtility.getJarDir();
            if (jarDir != null) {
                if (!jarDir.endsWith(File.separator)) {
                    jarDir = jarDir.concat(File.separator);
                }
                return jarDir;
            }
            Log.errorln("jar path is null.");
            return null;
        }
        String path = Platform.getInstallLocation().getURL().getPath();
        if (path.startsWith("//")) {
            return path;
        }
        if (path.startsWith("/")) {
            String osName = System.getProperties().getProperty("os.name");
            if (osName.toLowerCase().startsWith("windows")) {
                path = path.substring(1);
            } else {
                if (osName.toLowerCase().startsWith("linux")) {
                    return path;
                }
                path = path.substring(1);
            }
        }
        return path;
    }

    public static Locale getCurrentLocale() {
        String nl = IniUtils.getIniConfiguration((String)"osgi.nl");
        if (nl.length() == 0) {
            nl = Locale.getDefault().toString();
        }
        if (nl.equals(Locale.US.toString())) {
            return Locale.US;
        }
        if (nl.equals(Locale.SIMPLIFIED_CHINESE.toString())) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return Locale.getDefault();
    }

    public static String getChipName() {
        if (HiToolUtils.isCmdLine()) {
            return CmdMain.getChipName();
        }
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        ServiceReference sreference = bundleContext.getServiceReference(IDeviceManager.class);
        if (sreference == null) {
            return "Hi3798CV100";
        }
        IDeviceManager deviceManager = (IDeviceManager)bundleContext.getService(sreference);
        return deviceManager.getCurrentDevice();
    }

    public static void setWidthForOS(GridData gridData, int windowsWidth, int linuxWidth) {
        String osName = System.getProperties().getProperty("os.name");
        gridData.widthHint = osName.toLowerCase().startsWith("windows") ? windowsWidth : linuxWidth;
    }

    public static ProductLine.PRODUCTLINE getProductLine() {
        String ChinName = HiToolUtils.getChipName();
        UnknownDevice properties = new UnknownDevice(ChinName, HiToolUtils.getToolType());
        String type = properties.queryForString("TYPE");
        if (type == null) {
            return ProductLine.PRODUCTLINE.STB;
        }
        if (type.equalsIgnoreCase(ProductLine.PRODUCTLINE.STB.toString())) {
            return ProductLine.PRODUCTLINE.STB;
        }
        if (type.equalsIgnoreCase(ProductLine.PRODUCTLINE.BVT.toString())) {
            return ProductLine.PRODUCTLINE.BVT;
        }
        return ProductLine.PRODUCTLINE.DPT;
    }

    public static long getTftpSplitFileSize() {
        if (HiToolUtils.isCmdLine()) {
            return PreferenceConfig.getTftpSplitFileSize() * 0x100000;
        }
        return FastbootPreferences.getInt("hisilicon.fastboot.tftp.split.fileSize") * 0x100000;
    }

    public static String getPortCmd() {
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            return DEFAULT_TFTP_PORT_CMD;
        }
        if (osName.toLowerCase().startsWith("linux")) {
            return DEFAULT_TFTP_PORT_LINUX_CMD;
        }
        return DEFAULT_TFTP_PORT_LINUX_CMD;
    }

    public static boolean isJTagTransferMode(TransferWay transferWay) {
        return transferWay == TransferWay.JTAG || transferWay == TransferWay.JTAGAndNet || transferWay == TransferWay.JTAGAndSerial;
    }

    public static boolean isLinux() {
        String osName = System.getProperties().getProperty("os.name");
        return osName.toLowerCase().startsWith("linux");
    }

    public static boolean isDebugOn() {
        if (HiToolUtils.isCmdLine()) {
            return PreferenceConfig.isDebugPrint();
        }
        return FastbootPreferences.isDebugOn();
    }

    public static ToolType getToolType() {
        if (toolType == null) {
            toolType = HiToolUtils.isCmdLine() ? ToolType.Cmdline : ToolType.Composite;
        }
        return toolType;
    }

    public static boolean isCmdLine() {
        return isCmdLine;
    }

    public static void setCmdLine(boolean isCmdLine) {
        HiToolUtils.isCmdLine = isCmdLine;
    }

    public static ArrayList<Chip> getChip(String file) {
        ArrayList<Chip> chips = new ArrayList<Chip>();
        File f = new File(file);
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(f);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (doc == null) {
            return null;
        }
        Element root = doc.getRootElement();
        List<Element> productLines = HiToolUtils.getElementListByName(PRODUCTLINESSTR, root);
        if (productLines == null) {
            return null;
        }
        for (Element productLineElement : productLines) {
            List<Element> productLineList = HiToolUtils.getElementListByName(PRODUCTLINESTR, productLineElement);
            if (productLineList == null) {
                return null;
            }
            for (Element productLine : productLineList) {
                List<Element> ChipElementList;
                boolean isExsit;
                if (productLine == null) continue;
                String productLineId = productLine.attributeValue(ID);
                boolean bl = isExsit = productLineId != null && (productLineId.equalsIgnoreCase("STB") || productLineId.equalsIgnoreCase("DPT") || productLineId.equalsIgnoreCase("BVT"));
                if (!isExsit || (ChipElementList = HiToolUtils.getElementListByName(CHIP, productLine)) == null) continue;
                for (Element element : ChipElementList) {
                    Chip chip = new Chip();
                    String chipId = element.attributeValue(ID);
                    String chipName = element.attributeValue(NAME);
                    chip.setId(chipId);
                    chip.setName(chipName);
                    chip.setProductionLine(productLineId);
                    List<Element> toolRefList = HiToolUtils.getElementListByName(TOOLREF, element);
                    if (toolRefList == null) continue;
                    ArrayList<Tool> tools = new ArrayList<Tool>();
                    for (Element toolRef : toolRefList) {
                        String toolRefId = toolRef.attributeValue(ID);
                        Tool tool = new Tool();
                        String toolRefParam = toolRef.attributeValue(PARAM);
                        tool.setParam(toolRefParam);
                        tool.setId(toolRefId);
                        tools.add(tool);
                    }
                    chip.setToolList(tools);
                    chips.add(chip);
                }
            }
        }
        return chips;
    }

    private static List<Element> getElementListByName(String elementName, Element element) {
        if (elementName == null || element == null) {
            return null;
        }
        ArrayList<Element> elementList = new ArrayList<Element>();
        Iterator i = element.elementIterator(elementName);
        while (i.hasNext()) {
            elementList.add((Element)i.next());
        }
        return elementList;
    }
}

