/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.ui.BurnComposite;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DdrComposite
extends BurnComposite {
    protected Button startBurnButton;
    private Button browseButton;
    private Text fileText;

    public DdrComposite(Composite parent, int style, IBurner burner) {
        super(parent, style, burner);
    }

    protected Button createButton(Composite buttonComp, String label) {
        Button button = new Button(buttonComp, 0);
        button.setText(label);
        GridData layoutData = new GridData(576);
        layoutData.minimumWidth = 100;
        button.setLayoutData((Object)layoutData);
        return button;
    }

    protected List<Button> createButtons(Composite buttonComp) {
        ArrayList<Button> buttons = new ArrayList<Button>();
        this.fillButtons(buttonComp, buttons);
        return buttons;
    }

    protected void createButtonsControl(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        GridData layoutData = new GridData(1800);
        layoutData.horizontalSpan = 3;
        buttonComp.setLayoutData((Object)layoutData);
        List<Button> buttons = this.createButtons(buttonComp);
        buttonComp.setLayout((Layout)new GridLayout(buttons.size(), true));
    }

    @Override
    protected void createContents(Composite parent) {
        this.createDirectoryPathEditor(parent);
        this.createButtonsControl(parent);
    }

    protected void createDirectoryPathEditor(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.DdrComposite_DirectoryPath);
        this.fileText = new Text(parent, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)layoutData);
        this.fileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String filePath = DdrComposite.this.fileText.getText();
                if (filePath.trim().length() == 0) {
                    DdrComposite.this.fileText.setText("");
                }
            }
        });
        this.browseButton = new Button(parent, 0);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String filePath;
                DirectoryDialog dialog = new DirectoryDialog(DdrComposite.this.getShell(), 4096);
                String text = DdrComposite.this.fileText.getText();
                if (!text.isEmpty()) {
                    dialog.setFilterPath(text);
                }
                if ((filePath = dialog.open()) != null) {
                    DdrComposite.this.fileText.setText(filePath);
                }
            }
        });
    }

    @Override
    protected void burn() {
        IBurner burner = this.getBurner();
        if (this.checkStatus(burner.checkBeforeBurn())) {
            IFastbootProgressMonitor monitor = this.getProgressMonitor(ToolType.Composite);
            monitor.getEvent().setBurner(this.getBurner());
            burner.burn(monitor, this.fileText.getText());
        }
        this.enableButtons();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(4, false);
    }

    @Override
    protected void disableUI() {
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
        if (this.startBurnButton != null && !this.startBurnButton.isDisposed()) {
            this.startBurnButton.setEnabled(false);
        }
    }

    @Override
    protected void enableButtons() {
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
        if (this.startBurnButton != null && !this.startBurnButton.isDisposed()) {
            this.startBurnButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        this.enableButtons();
    }

    protected void fillButtons(final Composite buttonComp, List<Button> buttons) {
        this.startBurnButton = this.createButton(buttonComp, Messages.DdrComposite_StartBurn);
        this.startBurnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String file = DdrComposite.this.fileText.getText();
                if (new File(file).isDirectory()) {
                    DdrComposite.this.startBurnButton.setEnabled(false);
                    DdrComposite.this.burn();
                } else {
                    MessageDialog.openWarning((Shell)buttonComp.getShell(), (String)Messages.FASTBOOT_MessageDialog_Title, (String)Messages.DdrComposite_PleaseFile);
                }
            }
        });
        buttons.add(this.startBurnButton);
    }
}

