/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.sparse;

public class SparseChunkHeader {
    public static final int LENGTH = 12;
    public static final short CHUNK_TYPE_RAW = -13631;
    public static final short CHUNK_TYPE_FILL = -13630;
    public static final short CHUNK_TYPE_DONT_CARE = -13629;
    public short chunk_type;
    public short reserved1;
    public int chunk_sz;
    public int total_sz;

    public boolean fromBytes(byte[] data) {
        if (data.length < 12) {
            return false;
        }
        this.chunk_type = (short)((data[1] & 0xFF) << 8 | data[0] & 0xFF);
        this.reserved1 = (short)((data[3] & 0xFF) << 8 | data[2] & 0xFF);
        this.chunk_sz = (data[7] & 0xFF) << 24 | (data[6] & 0xFF) << 16 | (data[5] & 0xFF) << 8 | data[4] & 0xFF;
        this.total_sz = (data[11] & 0xFF) << 24 | (data[10] & 0xFF) << 16 | (data[9] & 0xFF) << 8 | data[8] & 0xFF;
        return true;
    }

    public byte[] toBytes() {
        byte[] data = new byte[]{(byte)(this.chunk_type & 0xFF), (byte)(this.chunk_type >> 8), (byte)(this.reserved1 & 0xFF), (byte)(this.reserved1 >> 8), (byte)(this.chunk_sz & 0xFF), (byte)(this.chunk_sz >> 8), (byte)(this.chunk_sz >> 16), (byte)(this.chunk_sz >> 24), (byte)(this.total_sz & 0xFF), (byte)(this.total_sz >> 8), (byte)(this.total_sz >> 16), (byte)(this.total_sz >> 24)};
        return data;
    }
}

