/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.jna.LibBootromByJNA;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.burnBootByLib.BootromStep;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.serial.workers.AbstractBurnerWorker;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CallLibBootromWorker
extends FastbootBurnerWorker {
    private static final int NO_CARE_CHAR = -1;
    private static SubProgressMonitor subMonitor;
    private static int isNotBareBurn;
    public LibBootromByJNA.JavaCallbackCancel callbackCancel = new LibBootromByJNA.JavaCallbackCancel(){

        @Override
        public boolean isCancel() {
            if (subMonitor == null) {
                return false;
            }
            return subMonitor.isCanceled();
        }
    };
    public LibBootromByJNA.JavaCallbackAdd callback = new LibBootromByJNA.JavaCallbackAdd(){

        @Override
        public void printInfo(int nStep, String comName, String printInfo, String debugInfo, int curStepSuccess) {
            if (HiToolUtils.isDebugOn() && monitor != null) {
                monitor.print(debugInfo);
            }
            CallLibBootromWorker.received(printInfo);
            CallLibBootromWorker.setReceived(printInfo);
            if (debugInfo != null && subMonitor != null && debugInfo.indexOf("%") != -1) {
                int progress = 0;
                try {
                    progress = Integer.parseInt(debugInfo.substring(0, debugInfo.indexOf("%")));
                    subMonitor.worked(progress);
                    subMonitor.notify();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (printInfo != null && printInfo.length() > 0 && UnknownDevice.isOpenLightDebug()) {
                if (curStepSuccess == 0) {
                    this.setLightDebug(nStep, printInfo, false);
                } else {
                    this.setLightDebug(nStep, printInfo, true);
                }
            }
        }

        private void setLightDebug(int nStep, String printInfo, boolean curStepSuccess) {
            if (nStep == -1) {
                return;
            }
            if (nStep != BootromStep.OPEN_SERIAL_COM.ordinal()) {
                if (nStep == BootromStep.SEND_TYPE_FRAME.ordinal()) {
                    if (curStepSuccess) {
                        CallLibBootromWorker.this.updateSerialLightToRight();
                        CallLibBootromWorker.this.readBootromInfoAck(printInfo);
                    } else {
                        CallLibBootromWorker.this.updateSerialLightToError();
                        CallLibBootromWorker.this.readBootromInfoNACK(printInfo);
                    }
                } else if (nStep == BootromStep.SEND_HEAD_DATA.ordinal() || nStep == BootromStep.SEND_AUX_CODE.ordinal() || nStep == BootromStep.SEND_PARAM_AREA.ordinal() || nStep == BootromStep.SEND_BOARD_FRAME.ordinal()) {
                    if (curStepSuccess) {
                        if (lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.SERIAL.name()) != null && ((Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.SERIAL.name())).intValue() == AbstractBurnerWorker.Light_State_E.abnormal.ordinal()) {
                            CallLibBootromWorker.this.updateSerialLightToRight();
                        }
                        if (((UnknownDevice)CallLibBootromWorker.this.burner.getBurnContext().getDeviceSetting()).isSupportDebugDDrTraining()) {
                            CallLibBootromWorker.this.updateSerialLightToRight();
                            CallLibBootromWorker.this.readBootromAndDDrAck(printInfo);
                        }
                    } else {
                        CallLibBootromWorker.this.readAuxAreaForLibBootrom(printInfo);
                        if (((UnknownDevice)CallLibBootromWorker.this.burner.getBurnContext().getDeviceSetting()).isSupportDebugDDrTraining()) {
                            CallLibBootromWorker.this.updateSerialLightToError();
                            CallLibBootromWorker.this.readBootromAndDDrNAck(printInfo);
                        }
                    }
                } else if (nStep == BootromStep.SEND_BOOT_IMAGE.ordinal()) {
                    if (printInfo.contains("*** Not upport current start mode")) {
                        AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                        if (CallLibBootromWorker.getLightView() != null) {
                            CallLibBootromWorker.this.updateLightColor(CallLibBootromWorker.getLightView().getFlashTypeMatchLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name()));
                        }
                    }
                } else if (nStep == BootromStep.WAIT_BOOT_RUN.ordinal()) {
                    if (curStepSuccess) {
                        CallLibBootromWorker.this.readBootInfo(printInfo);
                        if (isNotBareBurn == 1 && ((UnknownDevice)CallLibBootromWorker.this.burner.getBurnContext().getDeviceSetting()).isSupportDebugDDrTraining()) {
                            CallLibBootromWorker.this.updateSerialLightToRight();
                            CallLibBootromWorker.this.readBootromAndDDrAck(printInfo);
                        }
                    } else {
                        lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FASTBOOT_START.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                        if (isNotBareBurn == 1 && ((UnknownDevice)CallLibBootromWorker.this.burner.getBurnContext().getDeviceSetting()).isSupportDebugDDrTraining()) {
                            CallLibBootromWorker.this.updateSerialLightToError();
                            CallLibBootromWorker.this.readBootromAndDDrNAck(printInfo);
                        }
                    }
                    if (printInfo.contains("*** Not upport current start mode")) {
                        AbstractBurnerWorker.lightCurrentStateMap.put(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name(), AbstractBurnerWorker.Light_State_E.abnormal.ordinal());
                        if (CallLibBootromWorker.getLightView() != null) {
                            CallLibBootromWorker.this.updateLightColor(CallLibBootromWorker.getLightView().getFlashTypeMatchLbl(), (Integer)lightCurrentStateMap.get(AbstractBurnerWorker.Light_E.FLASH_AND_IMAGE_MATCH.name()));
                        }
                    }
                }
            }
        }
    };

    static {
        isNotBareBurn = 0;
    }

    public CallLibBootromWorker(IFrameSetting frameSetting, IBurner burner, SubProgressMonitor subProgressMonitor, ToolType toolType) {
        super(frameSetting, burner, toolType);
        CallLibBootromWorker.setSubMonitor(subProgressMonitor);
        String osName = System.getProperties().getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            System.setProperty("jna.encoding", "GBK");
        } else {
            System.setProperty("jna.encoding", "UTF-8");
        }
    }

    public static boolean bootDownloadByLib(String commName, int notBareBurn, int ddrOrFlash, String filePath, int[] caType, long[] initDdrAddr, int[] errorCode) {
        isNotBareBurn = notBareBurn;
        int burnResult = LibBootromByJNA.instance.bootrom_BootDownload(commName, notBareBurn, ddrOrFlash, filePath, caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static boolean bootDownloadByLib(String commName, int notBareBurn, int ddrOrFlash, String filePath, String chipName, int[] caType, long[] initDdrAddr, int[] errorCode) {
        isNotBareBurn = notBareBurn;
        int burnResult = LibBootromByJNA.instance.bootrom_BootDownloadByName(commName, notBareBurn, ddrOrFlash, filePath, chipName, HiToolUtils.getInstallPath(), caType, initDdrAddr, errorCode);
        return burnResult != 0;
    }

    public static void registerPrint(CallLibBootromWorker callLibBootromWorker) {
        LibBootromByJNA.instance.RegisterPrint(callLibBootromWorker.callback);
    }

    public static void registerCancel(CallLibBootromWorker callLibBootromWorker) {
        LibBootromByJNA.instance.RegisterCancel(callLibBootromWorker.callbackCancel);
    }

    public static SubProgressMonitor getSubMonitor() {
        return subMonitor;
    }

    public static void setSubMonitor(SubProgressMonitor subMonitor) {
        CallLibBootromWorker.subMonitor = subMonitor;
    }
}

