/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.preferences;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.preferences.FastbootPreferences;
import com.hisilicon.fastboot.preferences.PreferenceConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TFTPPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
PreferenceConstants {
    public static final String ID = "com.hisilicon.fastboot.preferences.TFTPPreferencePage";
    private BooleanFieldEditor tftpCrcEditor;
    private BooleanFieldEditor winSizeOpenEditor;
    private IntegerFieldEditor tftpBlockCountEditor;
    private IntegerFieldEditor losingPackageCountEditor;
    private BooleanFieldEditor losingpackageEditor;

    public TFTPPreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(FastbootPreferences.getPreferenceStore());
    }

    protected void createFieldEditors() {
        final Composite parent = this.getFieldEditorParent();
        IntegerFieldEditor tftpSpeedEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.speed", Messages.TFTPPreferencePage_TFTP_SPEED, parent);
        tftpSpeedEditor.setValidRange(1, 0x7FFFFFFE);
        this.addField((FieldEditor)tftpSpeedEditor);
        this.losingpackageEditor = new BooleanFieldEditor("hisilicon.fastboot.tftp.losingpackage.enable", Messages.TFTPPreferencePage_DEAL_WITH_LOSING_PACKAGE, parent){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
                if (TFTPPreferencePage.this.losingPackageCountEditor != null) {
                    TFTPPreferencePage.this.losingPackageCountEditor.setEnabled(newValue, parent);
                }
            }
        };
        this.addField((FieldEditor)this.losingpackageEditor);
        this.losingPackageCountEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.losingpackage.count", Messages.TFTPPreferencePage_MAX_LOSING_PACKAGES, parent);
        this.addField((FieldEditor)this.losingPackageCountEditor);
        this.losingPackageCountEditor.setEnabled(FastbootPreferences.getBoolean("hisilicon.fastboot.tftp.losingpackage.enable"), parent);
        this.losingPackageCountEditor.setValidRange(1, 0x7FFFFFFE);
        IntegerFieldEditor tftpRetryCountEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.retry.count", Messages.TFTPPreferencePage_TFTP_RETRY_COUNT, parent);
        this.addField((FieldEditor)tftpRetryCountEditor);
        tftpRetryCountEditor.setValidRange(0, 0x7FFFFFFE);
        IntegerFieldEditor tftpNoResponseTimeoutEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.timeout.noresponse", Messages.TFTPPreferencePage_TFTP_NO_RESPONSE_TIMEOUT, parent);
        this.addField((FieldEditor)tftpNoResponseTimeoutEditor);
        tftpNoResponseTimeoutEditor.setValidRange(3, 0x7FFFFFFE);
        IntegerFieldEditor tftpSplitFileEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.split.fileSize", Messages.TFTPPreferencePage_TFTP_SPLIT_FILE_SIZE, parent);
        this.addField((FieldEditor)tftpSplitFileEditor);
        tftpSplitFileEditor.setValidRange(30, 150);
        this.tftpCrcEditor = new BooleanFieldEditor("hisilicon.fastboot.tftp.crc.check", Messages.TFTPPreferencePage_TFTP_CRC_CHECK, parent){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
            }
        };
        this.addField((FieldEditor)this.tftpCrcEditor);
        this.winSizeOpenEditor = new BooleanFieldEditor("hisilicon.fastboot.tftp.windowSize.open", Messages.TFTPPreferencePage_TFTP_WindowSize_Open, parent){

            protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
                super.fireStateChanged(property, oldValue, newValue);
                if (TFTPPreferencePage.this.tftpBlockCountEditor != null) {
                    TFTPPreferencePage.this.tftpBlockCountEditor.setEnabled(newValue, parent);
                }
            }
        };
        this.addField((FieldEditor)this.winSizeOpenEditor);
        this.tftpBlockCountEditor = new IntegerFieldEditor("hisilicon.fastboot.tftp.windowSize.blockCount", Messages.TFTPPreferencePage_TFTP_WindowSize_BlockCount, parent);
        this.addField((FieldEditor)this.tftpBlockCountEditor);
        this.tftpBlockCountEditor.setEnabled(FastbootPreferences.getBoolean("hisilicon.fastboot.tftp.windowSize.open"), parent);
        this.tftpBlockCountEditor.setValidRange(1, 3);
    }
}

