/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers;

import com.hisilicon.fastboot.utilitily.HiToolUtils;

public class PackageData {
    byte[] data;
    private int pointer = 0;

    public PackageData(int fileLen) {
        this.data = new byte[fileLen];
        this.pointer = 0;
    }

    public void writeUByte(int value) {
        if (this.pointer + 1 > this.data.length) {
            return;
        }
        this.data[this.pointer] = (byte)(value & 0xFF);
        ++this.pointer;
    }

    public void writeUByte(int value, int position) {
        if (position + 1 > this.data.length) {
            return;
        }
        this.data[position] = (byte)(value & 0xFF);
    }

    public void writeUint(long value) {
        if (this.pointer + 4 > this.data.length) {
            return;
        }
        this.data[this.pointer] = (byte)(value >> 24 & 0xFFL);
        this.data[this.pointer + 1] = (byte)(value >> 16 & 0xFFL);
        this.data[this.pointer + 2] = (byte)(value >> 8 & 0xFFL);
        this.data[this.pointer + 3] = (byte)(value & 0xFFL);
        this.pointer += 4;
    }

    public void writeUlong(long value) {
        if (this.pointer + 8 > this.data.length) {
            return;
        }
        this.data[this.pointer] = (byte)(value >> 56 & 0xFFL);
        this.data[this.pointer + 1] = (byte)(value >> 48 & 0xFFL);
        this.data[this.pointer + 2] = (byte)(value >> 40 & 0xFFL);
        this.data[this.pointer + 3] = (byte)(value >> 32 & 0xFFL);
        this.data[this.pointer + 4] = (byte)(value >> 24 & 0xFFL);
        this.data[this.pointer + 5] = (byte)(value >> 16 & 0xFFL);
        this.data[this.pointer + 6] = (byte)(value >> 8 & 0xFFL);
        this.data[this.pointer + 7] = (byte)(value & 0xFFL);
        this.pointer += 8;
    }

    public void writeUint(long value, int position) {
        if (position + 4 > this.data.length) {
            return;
        }
        this.data[position] = (byte)(value >> 24 & 0xFFL);
        this.data[position + 1] = (byte)(value >> 16 & 0xFFL);
        this.data[position + 2] = (byte)(value >> 8 & 0xFFL);
        this.data[position + 3] = (byte)(value & 0xFFL);
    }

    public void writeUlong(long value, int position) {
        if (position + 8 > this.data.length) {
            return;
        }
        this.data[this.pointer] = (byte)(value >> 56 & 0xFFL);
        this.data[this.pointer + 1] = (byte)(value >> 48 & 0xFFL);
        this.data[this.pointer + 2] = (byte)(value >> 40 & 0xFFL);
        this.data[this.pointer + 3] = (byte)(value >> 32 & 0xFFL);
        this.data[this.pointer + 4] = (byte)(value >> 24 & 0xFFL);
        this.data[this.pointer + 5] = (byte)(value >> 16 & 0xFFL);
        this.data[this.pointer + 6] = (byte)(value >> 8 & 0xFFL);
        this.data[this.pointer + 7] = (byte)(value & 0xFFL);
    }

    public void writeUShort(int value) {
        if (this.pointer + 2 > this.data.length) {
            return;
        }
        this.data[this.pointer] = (byte)(value >> 8 & 0xFF);
        this.data[this.pointer + 1] = (byte)(value & 0xFF);
        this.pointer += 2;
    }

    public void writeUShort(int value, int position) {
        if (position + 2 > this.data.length) {
            return;
        }
        this.data[position] = (byte)(value >> 8 & 0xFF);
        this.data[position + 1] = (byte)(value & 0xFF);
    }

    public void writeBytes(byte[] bytes) {
        if (this.pointer + bytes.length > this.data.length) {
            return;
        }
        int i = 0;
        while (i < bytes.length) {
            this.data[this.pointer + i] = bytes[i];
            ++i;
        }
        this.pointer += bytes.length;
    }

    public void writeBytes(byte[] bytes, int position) {
        if (position + bytes.length > this.data.length) {
            return;
        }
        int i = 0;
        while (i < bytes.length) {
            this.data[position + i] = bytes[i];
            ++i;
        }
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public static boolean is32BitsSeries() {
        String chipName = HiToolUtils.getChipName();
        if (chipName == null) {
            return false;
        }
        boolean result = chipName.equalsIgnoreCase("Hi3716MV310") || chipName.equalsIgnoreCase("Hi3716MV320") || chipName.equalsIgnoreCase("Hi3716MV330") || chipName.equalsIgnoreCase("Hi3716EV500") || chipName.equalsIgnoreCase("Hi3716MV310_CA") || chipName.equalsIgnoreCase("Hi3110EV500_CA");
        return result;
    }
}

