/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.unknown;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UDFrameSetting
implements IFrameSetting {
    protected int[] preStep0;
    protected int[] preStep1;
    protected int[] ddrStep0;
    protected int address0;
    protected int address1;
    protected Integer address1NotNude = null;
    protected int address2;
    protected int fileLen0;
    protected int fileLen1;
    protected int stepLen0;
    protected int stepLen1;
    protected int startFrameTimeout;
    protected long ddrInitAddrByLibBootrom;

    private UDFrameSetting() {
    }

    public static UDFrameSetting build(UDProperties properties) {
        UDFrameSetting frameSetting = new UDFrameSetting();
        if (frameSetting.init(properties)) {
            return frameSetting;
        }
        return null;
    }

    private boolean init(UDProperties properties) {
        Integer address2Int;
        String preStep0Str = properties.queryForString("PRESTEP0");
        if (preStep0Str == null) {
            return false;
        }
        this.preStep0 = this.convertToInts(preStep0Str);
        String preStep1Str = properties.queryForString("PRESTEP1");
        if (preStep1Str == null) {
            return false;
        }
        this.preStep1 = this.convertToInts(preStep1Str);
        String ddrStep0Str = properties.queryForString("DDRSTEP0");
        if (ddrStep0Str == null) {
            return false;
        }
        this.ddrStep0 = this.convertToInts(ddrStep0Str);
        Integer address0Int = properties.queryForInteger("ADDRESS0");
        if (address0Int == null) {
            return false;
        }
        this.address0 = address0Int;
        Integer address1Int = properties.queryForInteger("ADDRESS1");
        if (address1Int == null) {
            return false;
        }
        this.address1 = address1Int;
        Integer address1NotNudeInt = properties.queryForInteger("ADDRESS1_NOTNUDE");
        if (address1NotNudeInt != null) {
            this.address1NotNude = address1NotNudeInt;
        }
        if ((address2Int = properties.queryForInteger("ADDRESS2")) == null) {
            return false;
        }
        this.address2 = address2Int;
        Integer fileLen0Int = properties.queryForInteger("FILELEN0");
        if (fileLen0Int == null) {
            return false;
        }
        this.fileLen0 = fileLen0Int;
        Integer fileLen1Int = properties.queryForInteger("FILELEN1");
        if (fileLen1Int == null) {
            return false;
        }
        this.fileLen1 = fileLen1Int;
        Integer stepLen0Int = properties.queryForInteger("STEPLEN0");
        if (stepLen0Int == null) {
            return false;
        }
        this.stepLen0 = stepLen0Int;
        Integer stepLen1Int = properties.queryForInteger("STEPLEN1");
        if (stepLen1Int == null) {
            return false;
        }
        this.stepLen1 = stepLen1Int;
        Integer startFrameTimeoutInt = properties.queryForInteger("STARTFRAMETIMEOUT");
        if (startFrameTimeoutInt == null) {
            return false;
        }
        this.startFrameTimeout = startFrameTimeoutInt;
        return true;
    }

    @Override
    public int[] getPrepareStep0() {
        return (int[])this.preStep0.clone();
    }

    @Override
    public int[] getDdrStep0() {
        return (int[])this.ddrStep0.clone();
    }

    @Override
    public int[] getPrepareStep1() {
        return (int[])this.preStep1.clone();
    }

    @Override
    public int getThirdFileAddress() {
        return this.address2;
    }

    @Override
    public FileInfo[] prepareFile() {
        FileInfo[] fileList = new FileInfo[2];
        int i = 0;
        while (i < fileList.length) {
            fileList[i] = new FileInfo();
            ++i;
        }
        fileList[0].setAddress(this.address0);
        if (this.address1NotNude != null) {
            fileList[1].setAddress(this.address1NotNude);
        } else {
            fileList[1].setAddress(this.address1);
        }
        fileList[0].setData(this.convertToByte(this.preStep0));
        fileList[1].setData(this.convertToByte(this.preStep1));
        fileList[0].setLength(this.stepLen0);
        fileList[1].setLength(this.stepLen1);
        return fileList;
    }

    @Override
    public FileInfo[] prepareFile(File file, FlashType flashType) throws IOException {
        FileInfo[] fileList = null;
        FileInputStream readStream = null;
        try {
            readStream = new FileInputStream(file);
            int fileLength = readStream.available();
            byte[] temp = new byte[fileLength];
            int read = readStream.read(temp);
            if (read != fileLength) {
                return null;
            }
            fileList = new FileInfo[3];
            int i = 0;
            while (i < 3) {
                fileList[i] = new FileInfo();
                ++i;
            }
            fileList[0].setAddress(this.address0);
            fileList[1].setAddress(this.address1);
            fileList[2].setAddress(this.address2);
            if (flashType == FlashType.ddr) {
                fileList[0].setData(this.convertToByte(this.ddrStep0));
            } else {
                fileList[0].setData(this.convertToByte(this.preStep0));
            }
            fileList[1].setData(temp);
            fileList[2].setData(temp);
            fileList[0].setLength(this.fileLen0);
            fileList[1].setLength(this.fileLen1);
            fileList[2].setLength(fileList[2].getData().length);
        }
        finally {
            if (readStream != null) {
                try {
                    readStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fileList;
    }

    @Override
    public FileInfo[] prepareProgrammerFile(File file) throws IOException {
        int bootSize;
        int[] fileData;
        FileInfo[] fileList;
        block20: {
            fileList = new FileInfo[2];
            int i = 0;
            while (i < fileList.length) {
                fileList[i] = new FileInfo();
                ++i;
            }
            fileList[0].setAddress(this.address0);
            fileList[1].setAddress(this.address2 + 0x1000000);
            FileInputStream readStream = null;
            fileData = null;
            try {
                readStream = new FileInputStream(file);
                int fileLength = readStream.available();
                byte[] temp = new byte[fileLength];
                int read = readStream.read(temp);
                if (read != fileLength) {
                    return null;
                }
                fileData = this.convertToInts(temp);
            }
            finally {
                if (readStream != null) {
                    try {
                        readStream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            bootSize = fileData[791] * 256 * 256 * 256 + fileData[790] * 256 * 256 + fileData[789] * 256 + fileData[788];
            if (bootSize <= fileData.length) break block20;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.PartitionComposite_msg_invalid_CABoot_file_please_check_the_file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            return null;
        }
        try {
            fileList[0].setLength(fileData.length - bootSize);
            fileList[1].setLength(bootSize);
            int[] data0 = new int[fileData.length - bootSize];
            int i = 0;
            while (i < fileData.length - bootSize) {
                data0[i] = fileData[i];
                ++i;
            }
            int[] data1 = new int[bootSize];
            int i2 = fileData.length - bootSize;
            while (i2 < fileData.length) {
                data1[i2 - (fileData.length - bootSize)] = fileData[i2];
                ++i2;
            }
            fileList[0].setData(this.convertToByte(data0));
            fileList[1].setData(this.convertToByte(data1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
        catch (OutOfMemoryError e) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.FASTBOOT_WARNING_Title, (String)Messages.ProgrammerFromatError);
                }
            });
            return null;
        }
        return fileList;
    }

    @Override
    public long getSendStartFrameTimeout() {
        return this.startFrameTimeout;
    }

    public long getDdrInitAddrByLibBootrom() {
        return this.ddrInitAddrByLibBootrom;
    }

    public void setDdrInitAddrByLibBootrom(long ddrInitAddrByLibBootrom) {
        this.ddrInitAddrByLibBootrom = ddrInitAddrByLibBootrom;
    }

    private byte[] convertToByte(int[] ints) {
        byte[] bytes = new byte[ints.length];
        int i = 0;
        while (i < ints.length) {
            bytes[i] = (byte)(ints[i] & 0xFF);
            ++i;
        }
        return bytes;
    }

    private int[] convertToInts(String str) {
        String[] temp = str.split(",");
        int[] result = new int[temp.length];
        int i = 0;
        while (i < temp.length) {
            result[i] = Integer.parseInt(temp[i].trim().replace("0x", ""), 16);
            ++i;
        }
        return result;
    }

    public int[] convertToInts(byte[] bytes) {
        int[] ints = new int[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            ints[i] = bytes[i] & 0xFF;
            ++i;
        }
        return ints;
    }
}

