/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.unknown;

import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IAddressBurner;
import com.hisilicon.fastboot.model.devices.IBootBurner;
import com.hisilicon.fastboot.model.devices.ICommonBurner;
import com.hisilicon.fastboot.model.devices.IEmmcBurner;
import com.hisilicon.fastboot.model.devices.IFlashSetting;
import com.hisilicon.fastboot.model.devices.IMergeBurner;
import com.hisilicon.fastboot.model.devices.IPartitionBurner;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.util.ArrayList;

public class UDFlashSetting
implements IFlashSetting {
    FlashType[] flashTypesForPartitionAndAddressBurner;
    FlashType[] flashTypesForEmmcBurner;
    FlashType[] flashTypesForBootBurner;
    FlashType[] flashTypesForMergeBurner;
    FlashType[] flashTypesForCommonBurner;
    FlashType[] flashTypesForCmdLineBurner;

    public static UDFlashSetting build(UDProperties properties) {
        UDFlashSetting flashSetting = new UDFlashSetting();
        if (flashSetting.init(properties)) {
            return flashSetting;
        }
        return null;
    }

    private UDFlashSetting() {
    }

    private boolean init(UDProperties properties) {
        Integer eepromInt;
        Integer notSpiInt;
        ArrayList<FlashType> flashList = new ArrayList<FlashType>();
        Integer notNandInt = properties.queryForInteger("NOTNAND");
        if (notNandInt == null) {
            flashList.add(FlashType.nand);
        }
        if ((notSpiInt = properties.queryForInteger("NOTSPI")) == null) {
            flashList.add(FlashType.spi);
        }
        if ((eepromInt = properties.queryForInteger("EEPROM")) != null && eepromInt == 1) {
            flashList.add(FlashType.eeprom);
        }
        this.flashTypesForPartitionAndAddressBurner = new FlashType[flashList.size()];
        flashList.toArray(this.flashTypesForPartitionAndAddressBurner);
        flashList.clear();
        if (notNandInt == null) {
            flashList.add(FlashType.nand);
        }
        if (notSpiInt == null) {
            flashList.add(FlashType.spi);
        }
        if (eepromInt != null && eepromInt == 1) {
            flashList.add(FlashType.eeprom);
        }
        flashList.add(FlashType.ddr);
        this.flashTypesForBootBurner = new FlashType[flashList.size()];
        flashList.toArray(this.flashTypesForBootBurner);
        flashList.clear();
        flashList.add(FlashType.emmc);
        Integer ufsInt = properties.queryForInteger("UFS");
        if (ufsInt != null && ufsInt == 1) {
            flashList.add(FlashType.ufs);
        }
        this.flashTypesForEmmcBurner = new FlashType[flashList.size()];
        flashList.toArray(this.flashTypesForEmmcBurner);
        flashList.clear();
        if (notNandInt == null) {
            flashList.add(FlashType.nand);
        }
        if (notSpiInt == null) {
            flashList.add(FlashType.spi);
        }
        if (eepromInt != null && eepromInt == 1) {
            flashList.add(FlashType.eeprom);
        }
        flashList.add(FlashType.emmc);
        this.flashTypesForMergeBurner = new FlashType[flashList.size()];
        flashList.toArray(this.flashTypesForMergeBurner);
        if (HiToolUtils.isCmdLine()) {
            this.flashTypesForCmdLineBurner = new FlashType[flashList.size()];
            flashList.toArray(this.flashTypesForCmdLineBurner);
        } else {
            this.flashTypesForCommonBurner = new FlashType[flashList.size()];
            flashList.toArray(this.flashTypesForCommonBurner);
        }
        flashList.clear();
        return true;
    }

    @Override
    public FlashType[] getFlashTypes(IBurner burner) {
        if (HiToolUtils.isCmdLine()) {
            return (FlashType[])this.flashTypesForCmdLineBurner.clone();
        }
        if (burner instanceof ICommonBurner) {
            return (FlashType[])this.flashTypesForCommonBurner.clone();
        }
        if (burner instanceof IEmmcBurner) {
            return (FlashType[])this.flashTypesForEmmcBurner.clone();
        }
        if (burner instanceof IMergeBurner) {
            return (FlashType[])this.flashTypesForMergeBurner.clone();
        }
        if (burner instanceof IPartitionBurner) {
            return (FlashType[])this.flashTypesForPartitionAndAddressBurner.clone();
        }
        if (burner instanceof IAddressBurner) {
            return (FlashType[])this.flashTypesForPartitionAndAddressBurner.clone();
        }
        if (burner instanceof IBootBurner) {
            return (FlashType[])this.flashTypesForBootBurner.clone();
        }
        return new FlashType[0];
    }

    @Override
    public String[] getFlashNames(IBurner burner) {
        FlashType[] flashTypes = this.getFlashTypes(burner);
        String[] result = new String[flashTypes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = flashTypes[i] == FlashType.nand ? "spi nand/nand" : (flashTypes[i] == FlashType.spi ? "spi nor" : flashTypes[i].name());
            ++i;
        }
        return result;
    }

    @Override
    public FlashType findFlashType(String name) {
        FlashType[] values;
        if (name.equalsIgnoreCase("spi nand/nand")) {
            name = FlashType.nand.name();
        } else if (name.equalsIgnoreCase("spi nor")) {
            name = FlashType.spi.name();
        }
        FlashType[] flashTypeArray = values = FlashType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FlashType flashType = flashTypeArray[n2];
            if (flashType.name().equalsIgnoreCase(name)) {
                return flashType;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public FlashType findFlashType(IBurner burner, String name) {
        FlashType[] values;
        if (name.equalsIgnoreCase("spi nand/nand")) {
            name = FlashType.nand.name();
        } else if (name.equalsIgnoreCase("spi nor")) {
            name = FlashType.spi.name();
        }
        FlashType[] flashTypeArray = values = this.getFlashTypes(burner);
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FlashType flashType = flashTypeArray[n2];
            if (flashType.name().equalsIgnoreCase(name)) {
                return flashType;
            }
            ++n2;
        }
        return null;
    }
}

