/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.unknown;

import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IBurnerContext;
import com.hisilicon.fastboot.model.devices.IDeviceSetting;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.devices.burners.AddressBurner;
import com.hisilicon.fastboot.model.devices.burners.BadCheckBurner;
import com.hisilicon.fastboot.model.devices.burners.BoardCheckBurner;
import com.hisilicon.fastboot.model.devices.burners.CheckSumBurner;
import com.hisilicon.fastboot.model.devices.burners.CommonBurner;
import com.hisilicon.fastboot.model.devices.burners.DdrBurner;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.devices.burners.FastbootBurner;
import com.hisilicon.fastboot.model.devices.burners.MergeBurner;
import com.hisilicon.fastboot.model.devices.burners.PartitionBurner;
import com.hisilicon.fastboot.model.devices.burners.bvt.BVTAddressBurnerWorker;
import com.hisilicon.fastboot.model.devices.burners.bvt.BVTEmmcBurnerWorker;
import com.hisilicon.fastboot.model.devices.burners.bvt.BVTFastbootBurnerWorker;
import com.hisilicon.fastboot.model.devices.burners.bvt.BVTPartitionBurnerWorker;
import com.hisilicon.fastboot.model.devices.unknown.UDProperties;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.serial.workers.EmmcPartitionBurnerWorker;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import java.util.ArrayList;

public class UDBurnerContext
implements IBurnerContext {
    IDeviceSetting deviceSetting;
    IBurner[] burners;

    private UDBurnerContext() {
    }

    public static UDBurnerContext build(UDProperties properties, IDeviceSetting deviceSetting, ToolType toolType) {
        UDBurnerContext burnerContext = new UDBurnerContext();
        if (burnerContext.init(properties, deviceSetting, toolType)) {
            return burnerContext;
        }
        return null;
    }

    private boolean init(UDProperties properties, IDeviceSetting deviceSetting, final ToolType toolType) {
        Integer boardCheckInt;
        Integer ddrBurn;
        Integer checkSumInt;
        Integer notSpiInt;
        Integer badCheckInt;
        this.deviceSetting = deviceSetting;
        if (properties == null) {
            return false;
        }
        ArrayList<AbstractBurner> burnerList = new ArrayList<AbstractBurner>();
        Integer commonPartition = properties.queryForInteger("CommonPartition");
        if (commonPartition != null && commonPartition == 1) {
            burnerList.add(new CommonBurner(deviceSetting.getBurnContext(), toolType));
            burnerList.add(new AddressBurner(deviceSetting.getBurnContext(), toolType));
            burnerList.add(new FastbootBurner(deviceSetting.getBurnContext(), toolType));
            Integer emmcInt = properties.queryForInteger("EMMC");
            if (emmcInt != null && emmcInt > 0) {
                ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
            }
        } else {
            Integer emmcInt;
            String boardType = properties.queryForString("TYPE");
            if (boardType == null || !boardType.equalsIgnoreCase("BVT")) {
                burnerList.add(new PartitionBurner(deviceSetting.getBurnContext(), toolType));
                burnerList.add(new AddressBurner(deviceSetting.getBurnContext(), toolType));
                burnerList.add(new FastbootBurner(deviceSetting.getBurnContext(), toolType));
                emmcInt = properties.queryForInteger("EMMC");
                if (emmcInt != null && emmcInt > 0) {
                    burnerList.add(new EmmcBurner(deviceSetting.getBurnContext(), toolType));
                    ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
                }
            } else {
                burnerList.add(new PartitionBurner(deviceSetting.getBurnContext(), toolType){

                    @Override
                    protected PartitionBurnerWorker getBurnerWorker() {
                        return new BVTPartitionBurnerWorker(this, this.toolType);
                    }
                });
                burnerList.add(new AddressBurner(deviceSetting.getBurnContext(), toolType){

                    @Override
                    protected BVTAddressBurnerWorker getBurnerWorker() {
                        if (!(this.worker instanceof BVTAddressBurnerWorker)) {
                            this.worker = new BVTAddressBurnerWorker(this, toolType);
                        }
                        return (BVTAddressBurnerWorker)this.worker;
                    }
                });
                burnerList.add(new FastbootBurner(deviceSetting.getBurnContext(), toolType){

                    @Override
                    protected FastbootBurnerWorker getBurnerWorker() {
                        return new BVTFastbootBurnerWorker(this.getFrameSetting(), this);
                    }
                });
                emmcInt = properties.queryForInteger("EMMC");
                if (emmcInt != null && emmcInt > 0) {
                    burnerList.add(new EmmcBurner(deviceSetting.getBurnContext(), toolType){

                        @Override
                        public EmmcPartitionBurnerWorker getBurnerWorker() {
                            return new BVTEmmcBurnerWorker(this, this.toolType);
                        }
                    });
                    ((UnknownDevice)deviceSetting).setEmmcType(emmcInt);
                }
            }
        }
        if ((badCheckInt = properties.queryForInteger("BADCHECK")) != null && badCheckInt == 1) {
            burnerList.add(new BadCheckBurner(deviceSetting.getBurnContext(), toolType));
        }
        if ((notSpiInt = properties.queryForInteger("NOTSPI")) == null) {
            burnerList.add(new MergeBurner(deviceSetting.getBurnContext(), toolType));
        }
        if ((checkSumInt = properties.queryForInteger("CHECKSUM")) != null && checkSumInt == 1) {
            burnerList.add(new CheckSumBurner(deviceSetting.getBurnContext(), toolType));
        }
        if ((ddrBurn = properties.queryForInteger("DDRBURN")) != null && ddrBurn == 1) {
            burnerList.add(new DdrBurner(deviceSetting.getBurnContext(), toolType));
        }
        if ((boardCheckInt = properties.queryForInteger("LIGHTDEBUG")) != null && boardCheckInt == 1) {
            burnerList.add(new BoardCheckBurner(deviceSetting.getBurnContext(), toolType));
        }
        this.burners = new IBurner[burnerList.size()];
        burnerList.toArray(this.burners);
        return true;
    }

    @Override
    public IBurner[] getBurners() {
        return (IBurner[])this.burners.clone();
    }

    @Override
    public IDeviceSetting getDeviceSetting() {
        return this.deviceSetting;
    }
}

