/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.ICheckerBoard;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.BoardBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.BoradCheckTab;
import gnu.io.SerialPort;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class BoardCheckBurner
extends AbstractBurner
implements ICheckerBoard {
    private ToolType toolType;

    public BoardCheckBurner(BurnContext burnContext, ToolType toolType) {
        super(burnContext, toolType);
        this.toolType = toolType;
    }

    @Override
    public List<String> getSteps() {
        return null;
    }

    @Override
    public ITab getTab() {
        return new BoradCheckTab();
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor) {
    }

    @Override
    public void check(final IFastbootProgressMonitor fastbootMonitor) {
        boolean needOpenSerial;
        if (fastbootMonitor != null) {
            fastbootMonitor.getEvent().init(EventType.CHECK);
        }
        LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        final BoardBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl = needOpenSerial = transferWay == TransferWay.Serial || transferWay == TransferWay.Net || transferWay == TransferWay.NetNonNude || transferWay == TransferWay.Uart2Compress;
        if (needOpenSerial) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Check Single Board Status"){

                /*
                 * Loose catch block
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean burn = worker.check(monitor);
                            event.setSuccess(burn);
                        }
                        catch (IOException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                        catch (ReceiveTimeOutException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                }
            });
            job.schedule();
        }
    }

    @Override
    public IStatus checkBeforeCheck() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        return null;
    }

    @Override
    protected BoardBurnerWorker getBurnerWorker() {
        return new BoardBurnerWorker(this, this.toolType);
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

