/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IChecker;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.model.devices.ITab;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.model.event.EventType;
import com.hisilicon.fastboot.model.event.FastbootEvent;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.BadCheckBurnerWorker;
import com.hisilicon.fastboot.ui.burners.tabs.BadCheckTab;
import gnu.io.SerialPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class BadCheckBurner
extends AbstractBurner
implements IChecker {
    private ToolType toolType;

    public BadCheckBurner(BurnContext burnContext, ToolType toolType) {
        super(burnContext, toolType);
        this.toolType = toolType;
    }

    protected IFrameSetting getFrameSetting() {
        return this.getBurnContext().getDeviceSetting().getFrameSetting();
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor) {
    }

    @Override
    public void check(final IFastbootProgressMonitor fastbootMonitor) {
        boolean needOpenSerial;
        if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
            fastbootMonitor.getEvent().init(EventType.CHECK);
        }
        LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        final BadCheckBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        worker.setFlashType(FlashType.nand);
        TransferWay transferWay = this.getBurnContext().getTransferWay();
        boolean bl = needOpenSerial = transferWay != TransferWay.Usb2I2c && transferWay != TransferWay.I2CBootrom && transferWay != TransferWay.USBBootrom && transferWay != TransferWay.USBNonNude && !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom();
        if (needOpenSerial) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Check Bad Blocks"){

                /*
                 * Loose catch block
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean burn = worker.check(monitor);
                            event.setSuccess(burn);
                        }
                        catch (IOException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                        catch (ReceiveTimeOutException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            worker.close();
                            return iStatus;
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                }
            });
            job.schedule();
        }
    }

    @Override
    public IStatus checkBeforeCheck() {
        IStatus validSerialPort = this.validSerialPort();
        if (!this.isOK(validSerialPort)) {
            return validSerialPort;
        }
        return null;
    }

    @Override
    public List<String> getSteps() {
        ArrayList<String> steps = new ArrayList<String>();
        steps.add(Messages.CheckerBurner_Step_1);
        steps.add(Messages.CheckerBurner_Step_2);
        steps.add(Messages.CheckerBurner_Step_3);
        steps.add(Messages.CheckerBurner_Step_4);
        steps.add(Messages.CheckerBurner_Step_5);
        return steps;
    }

    @Override
    public ITab getTab() {
        return new BadCheckTab();
    }

    @Override
    protected BadCheckBurnerWorker getBurnerWorker() {
        return new BadCheckBurnerWorker(this, this.toolType);
    }

    @Override
    public void eraseBad(final IFastbootProgressMonitor fastbootMonitor) {
        if (fastbootMonitor != null && fastbootMonitor.getEvent() != null) {
            fastbootMonitor.getEvent().init(EventType.ERASE);
        }
        LocalConfig localConfig = this.getBurnContext().getLocalConfig();
        final BadCheckBurnerWorker worker = this.getBurnerWorker();
        worker.setProgressMonitor(fastbootMonitor);
        worker.setFlashType(FlashType.nand);
        if (this.getBurnContext().getTransferWay() != TransferWay.Usb2I2c && this.getBurnContext().getTransferWay() != TransferWay.I2CBootrom && !((UnknownDevice)this.getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            SerialPort serialPort;
            if (fastbootMonitor != null && (serialPort = this.openSerailPort(fastbootMonitor, worker, localConfig.getComPort())) == null) {
                return;
            }
        } else if (fastbootMonitor != null) {
            fastbootMonitor.begin();
        }
        if (fastbootMonitor != null) {
            final FastbootEvent event = fastbootMonitor.getEvent();
            Job job = new Job("Check nand scrub"){

                /*
                 * Loose catch block
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            boolean eraseBad = worker.eraseBad(monitor);
                            event.setSuccess(eraseBad);
                        }
                        catch (IOException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            fastbootMonitor.finish();
                            worker.close();
                            return iStatus;
                        }
                        catch (ReceiveTimeOutException e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            fastbootMonitor.finish();
                            worker.close();
                            return iStatus;
                        }
                        catch (Throwable e) {
                            monitor.setCanceled(true);
                            e.printStackTrace();
                            fastbootMonitor.getEvent().setMessage(e.getMessage());
                            IStatus iStatus = Status.CANCEL_STATUS;
                            fastbootMonitor.finish();
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            worker.close();
                            return iStatus;
                        }
                    }
                    finally {
                        fastbootMonitor.finish();
                        worker.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.showProgressDialog(job);
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    fastbootMonitor.finish();
                }
            });
            job.schedule();
        }
    }

    @Override
    public void burn(IFastbootProgressMonitor monitor, String directory) {
    }
}

