/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.cmdline.adapter;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.PartitionInfo;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.cmdline.EEmmcImg;
import com.hisilicon.fastboot.model.cmdline.adapter.CommonAdapter;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import java.io.File;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.osgi.util.NLS;

public class EmmcImg
extends CommonAdapter {
    private UnknownDevice device;
    private String chipName;
    private String xmlPath;
    private String outputPath;
    private List<PartitionItem> partitionList;

    public boolean parseAllParameter(String[] args, int paramSize) {
        if (!this.parseChipName(args, paramSize)) {
            EmmcImg.printEmmcImgEg();
            return false;
        }
        if (!this.parseOutputFile(args, paramSize)) {
            EmmcImg.printEmmcImgEg();
            return false;
        }
        if (!this.parseXmlPath(args, paramSize)) {
            EmmcImg.printEmmcImgEg();
            return false;
        }
        return true;
    }

    public boolean parseChipName(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.chipName.name()));
            this.printChipNameOptions();
            return false;
        }
        if (paramSize >= EEmmcImg.chipName.ordinal()) {
            String chipName = args[EEmmcImg.chipName.ordinal()];
            if (chipName == null || chipName.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EEmmcImg.chipName.name()));
                this.printChipNameOptions();
                return false;
            }
            String upperCaseChipName = EmmcImg.convertChipName(chipName);
            UnknownDevice device = new UnknownDevice(upperCaseChipName, ToolType.Cmdline);
            if (!device.isValid()) {
                Log.errorln(Messages.FastbootView_Unsupported_Device);
                this.printChipNameOptions();
                return false;
            }
            this.setChipName(upperCaseChipName);
            this.setDevice(device);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.chipName.name()));
        this.printChipNameOptions();
        return false;
    }

    public boolean parseOutputFile(String[] args, int paramSize) {
        String outputFilePath;
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.outputFile.name()));
            return false;
        }
        if (paramSize >= EEmmcImg.outputFile.ordinal()) {
            boolean result;
            outputFilePath = args[EEmmcImg.outputFile.ordinal()];
            boolean bl = result = outputFilePath == null || outputFilePath.isEmpty();
            if (result) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EEmmcImg.outputFile.name()));
                return false;
            }
            File file = new File(outputFilePath);
            if (file.isDirectory()) {
                Log.errorln(NLS.bind((String)Messages.AbstractBurner_msg_the_file_can_not_be_a_directory, (Object)file.getName()));
                return false;
            }
        } else {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.outputFile.name()));
            return false;
        }
        this.setOutputPath(outputFilePath);
        return true;
    }

    public boolean parseXmlPath(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.xmlPath.name()));
            return false;
        }
        if (paramSize >= EEmmcImg.xmlPath.ordinal()) {
            File file;
            block6: {
                String xmlPath = args[EEmmcImg.xmlPath.ordinal()];
                file = new File(xmlPath);
                if (!file.exists() || !file.isFile()) {
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)xmlPath));
                    return false;
                }
                try {
                    PartitionInfo partitionInfo = PartitionItem.load(file, true);
                    List<PartitionItem> partitionList = partitionInfo.getChildren();
                    if (partitionList == null || partitionList.size() <= 0) break block6;
                    this.setXmlPath(xmlPath);
                    this.setPartitionList(partitionList);
                    return true;
                }
                catch (DocumentException e) {
                    Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)file.getName()));
                    e.printStackTrace();
                    return false;
                }
            }
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)file.getName()));
            return false;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EEmmcImg.xmlPath.name()));
        return false;
    }

    public static void printEmmcImgEg() {
        Log.println("hiburn.jar --emmcimg  <chipName>      <outputFile>              <xmlPath>           ");
        Log.println("hiburn.jar --emmcimg  hi3798cv200   image/emmcImg.bin    image/emmc_partitions.xml  ");
    }

    public String getChipName() {
        return this.chipName;
    }

    public void setChipName(String chipName) {
        this.chipName = chipName;
    }

    public UnknownDevice getDevice() {
        return this.device;
    }

    public void setDevice(UnknownDevice device) {
        this.device = device;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    public List<PartitionItem> getPartitionList() {
        return this.partitionList;
    }

    public void setPartitionList(List<PartitionItem> partitionList) {
        this.partitionList = partitionList;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }
}

