/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.cmdline.adapter;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.cmdline.EBurnBoot;
import com.hisilicon.fastboot.model.cmdline.adapter.CommonAdapter;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import java.io.File;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class BootBurn
extends CommonAdapter {
    private UnknownDevice device;
    private String chipName;
    private TransferWay mode;
    private String port;
    private FlashType flashType;
    private File bootFile;
    private File programmer;
    private List<String> serialPorts;

    public boolean parseAllParameter(String[] args, int paramSize) {
        if (!this.parseChipName(args, paramSize)) {
            BootBurn.printBurnBootEg();
            return false;
        }
        if (!this.parseMode(args, paramSize)) {
            BootBurn.printBurnBootEg();
            return false;
        }
        if (!this.parsePort(args, paramSize)) {
            this.printBurnBoot();
            return false;
        }
        if (!this.parseFlash(args, paramSize)) {
            BootBurn.printBurnBootEg();
            return false;
        }
        String bootFilePath = this.parseFile(args, paramSize, EBurnBoot.boot.name(), EBurnBoot.boot.ordinal());
        if (bootFilePath == null) {
            BootBurn.printBurnBootEg();
            return false;
        }
        this.setBootFile(new File(bootFilePath));
        String programmerFilePath = this.parseFile(args, paramSize, EBurnBoot.programmer.name(), EBurnBoot.programmer.ordinal());
        if (programmerFilePath != null) {
            this.setProgrammer(new File(programmerFilePath));
        }
        return true;
    }

    public boolean parseChipName(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.chipName.name()));
            this.printChipNameOptions();
            return false;
        }
        if (paramSize >= EBurnBoot.chipName.ordinal()) {
            boolean result;
            String chipName = args[EBurnBoot.chipName.ordinal()];
            boolean bl = result = chipName == null || chipName.isEmpty();
            if (result) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.chipName.name()));
                this.printChipNameOptions();
                return false;
            }
            String upperCaseChipName = BootBurn.convertChipName(chipName);
            UnknownDevice device = new UnknownDevice(upperCaseChipName, ToolType.Cmdline);
            if (!device.isValid()) {
                Log.errorln(Messages.FastbootView_Unsupported_Device);
                this.printChipNameOptions();
                return false;
            }
            this.setChipName(upperCaseChipName);
            this.setDevice(device);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.chipName.name()));
        this.printChipNameOptions();
        return false;
    }

    public boolean parseMode(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
            this.printModeOptions();
            return false;
        }
        if (paramSize >= EBurnBoot.mode.ordinal()) {
            String modeStr = args[EBurnBoot.mode.ordinal()];
            if (modeStr == null || modeStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            if (modeStr.equalsIgnoreCase(EMode.serial.name())) {
                this.setMode(TransferWay.Serial);
            } else if (modeStr.equalsIgnoreCase(EMode.jtag.name())) {
                this.setMode(TransferWay.JTAG);
            } else if (modeStr.equalsIgnoreCase(EMode.jtagandserial.name())) {
                this.setMode(TransferWay.JTAGAndSerial);
            } else {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)EBurnBoot.mode.name()));
                this.printModeOptions();
                return false;
            }
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.mode.name()));
        this.printModeOptions();
        return false;
    }

    public boolean parsePort(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.port.name()));
            return false;
        }
        if (paramSize >= EBurnBoot.port.ordinal()) {
            String portStr = args[EBurnBoot.port.ordinal()];
            if (portStr == null || portStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.mode.name()));
                return false;
            }
            this.setPort(portStr);
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.port.name()));
        return false;
    }

    public boolean parseFlash(String[] args, int paramSize) {
        if (args == null) {
            Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.flash.name()));
            this.printFlashOptions();
            return false;
        }
        if (paramSize >= EBurnBoot.flash.ordinal()) {
            String flashStr = args[EBurnBoot.flash.ordinal()];
            if (flashStr == null || flashStr.isEmpty()) {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_IsNull, (Object)EBurnBoot.flash.name()));
                this.printFlashOptions();
                return false;
            }
            if (flashStr.equalsIgnoreCase(EFlashType.nand.name())) {
                this.setFlashType(FlashType.nand);
            } else if (flashStr.equalsIgnoreCase(EFlashType.spi.name())) {
                this.setFlashType(FlashType.spi);
            } else if (flashStr.equalsIgnoreCase(EFlashType.emmc.name())) {
                this.setFlashType(FlashType.emmc);
            } else if (flashStr.equalsIgnoreCase(EFlashType.ddr.name())) {
                this.setFlashType(FlashType.ddr);
            } else {
                Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_Invalid, (Object)EBurnBoot.flash.name()));
                this.printFlashOptions();
                return false;
            }
            return true;
        }
        Log.errorln(NLS.bind((String)Messages.CMD_PARAMETER_NotFound, (Object)EBurnBoot.flash.name()));
        this.printFlashOptions();
        return false;
    }

    private void printModeOptions() {
        EMode[] eModes;
        Log.println("mode:");
        EMode[] eModeArray = eModes = EMode.values();
        int n = eModes.length;
        int n2 = 0;
        while (n2 < n) {
            EMode eMode = eModeArray[n2];
            Log.println(eMode.name());
            ++n2;
        }
    }

    private void printPortOption() {
        Log.println("Input Port:");
        if (this.serialPorts != null && this.serialPorts.size() > 0) {
            for (String serialPort : this.serialPorts) {
                Log.println(serialPort);
            }
        }
    }

    private void printFlashOptions() {
        EFlashType[] eFlashTypes;
        Log.println("Flash:");
        EFlashType[] eFlashTypeArray = eFlashTypes = EFlashType.values();
        int n = eFlashTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EFlashType eFlashType = eFlashTypeArray[n2];
            Log.println(eFlashType.name());
            ++n2;
        }
    }

    private void printBootOption() {
        Log.println("Input Boot file:");
    }

    private void printProgrammerOption() {
        Log.println("Input Programmer file:(Options)");
    }

    public static void printBurnBootEg() {
        Log.println("hiburn.jar --burnboot  <chipName>   <mode>  <port>  <flash>       <boot>                 [programmer]         ");
        Log.println("hiburn.jar --burnboot  hi3798cv200  serial   COM0     emmc    image/fastboot.bin   image/advca_programmer.sig ");
    }

    public void printBurnBoot() {
        BootBurn.printBurnBootEg();
        this.printChipNameOptions();
        this.printModeOptions();
        this.printPortOption();
        this.printFlashOptions();
        this.printBootOption();
        this.printProgrammerOption();
    }

    public UnknownDevice getDevice() {
        return this.device;
    }

    public void setDevice(UnknownDevice device) {
        this.device = device;
    }

    public String getChipName() {
        return this.chipName;
    }

    public void setChipName(String chipName) {
        this.chipName = chipName;
    }

    public TransferWay getMode() {
        return this.mode;
    }

    public void setMode(TransferWay mode) {
        this.mode = mode;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public FlashType getFlashType() {
        return this.flashType;
    }

    public void setFlashType(FlashType flashType) {
        this.flashType = flashType;
    }

    public File getBootFile() {
        return this.bootFile;
    }

    public void setBootFile(File bootFile) {
        this.bootFile = bootFile;
    }

    public File getProgrammer() {
        return this.programmer;
    }

    public void setProgrammer(File programmer) {
        this.programmer = programmer;
    }

    public List<String> getSerialPorts() {
        return this.serialPorts;
    }

    public void setSerialPorts(List<String> serialPorts) {
        this.serialPorts = serialPorts;
    }

    public static enum EFlashType {
        nand,
        spi,
        emmc,
        ddr;

    }

    public static enum EMode {
        serial,
        jtag,
        jtagandserial;

    }
}

