/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.badcheck;

import com.hisilicon.fastboot.model.badcheck.BadBlockModel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BadBlockWindow {
    protected Shell shell;
    private Label labelTitle;
    private Text informationText;
    private Button button;
    private BadBlockModel badBlock;

    public static void main(String[] args) {
        try {
            BadBlockWindow window = new BadBlockWindow();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void open() {
        Display display = Display.getDefault();
        this.createContents();
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createContents() {
        this.badBlock = new BadBlockModel();
        this.shell = new Shell();
        this.shell.setSize(800, 600);
        this.shell.setText("\u574f\u5757\u663e\u793a");
        GridLayout layout = new GridLayout(1, false);
        this.shell.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this.shell, 2048);
        composite.setToolTipText("ssss");
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.labelTitle = new Label(composite, 0);
        this.labelTitle.setText("\u574f\u5757\u4fe1\u606f");
        final Composite imageComposite = new Composite(composite, 2048);
        GridData imageComLayoutData = new GridData(4, 4, true, false, 1, 1);
        imageComLayoutData.heightHint = 50;
        imageComposite.setLayoutData((Object)imageComLayoutData);
        imageComposite.setBackground(Display.getCurrent().getSystemColor(5));
        imageComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(Display.getCurrent().getSystemColor(3));
                float[] blockAddress = new float[BadBlockWindow.this.badBlock.getBadAddress().length];
                int[] startAddress = new int[BadBlockWindow.this.badBlock.getBadAddress().length];
                int i = 0;
                while (i < BadBlockWindow.this.badBlock.getBadAddress().length) {
                    blockAddress[i] = (int)BadBlockWindow.this.badBlock.getBadAddress()[i] % BadBlockWindow.this.badBlock.getBlock() != 0 ? (float)BadBlockWindow.this.badBlock.getBadAddress()[i] / (float)BadBlockWindow.this.badBlock.getBlock() + 1.0f : (float)BadBlockWindow.this.badBlock.getBadAddress()[i] / (float)BadBlockWindow.this.badBlock.getBlock();
                    startAddress[i] = (int)((double)(blockAddress[i] * (float)(imageComposite.getSize().x - 4)) / (BadBlockWindow.this.badBlock.getChip() / (double)BadBlockWindow.this.badBlock.getBlock()));
                    if (i + 1 < BadBlockWindow.this.badBlock.getBadAddress().length && startAddress[i] != startAddress[i + 1]) {
                        gc.drawLine(startAddress[i], 0, startAddress[i], 60);
                    }
                    gc.drawLine(startAddress[i], 0, startAddress[i], 60);
                    ++i;
                }
            }
        });
        this.informationText = new Text(composite, 2058);
        this.informationText.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int i = 0;
        while (i < this.badBlock.getBadAddress().length) {
            String line = Long.toString(this.badBlock.getBadAddress()[i]);
            if (line != null) {
                this.informationText.append(line);
                this.informationText.append("\r\n");
            }
            ++i;
        }
        this.button = new Button(composite, 8);
        GridData buttonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        buttonGridData.widthHint = 120;
        buttonGridData.heightHint = 30;
        this.button.setLayoutData((Object)buttonGridData);
        this.button.setText("\u67e5\u770b\u574f\u5757");
    }
}

