/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translator {
    private final ResourceBundle resources;

    Translator() {
        this("net.sourceforge.jnlp.resources.Messages");
    }

    Translator(String s) {
        try {
            this.resources = ResourceBundle.getBundle(s);
        }
        catch (Exception ex) {
            throw new IllegalStateException("No bundles found for Locale: " + Locale.getDefault().toString() + "and missing base resource bundle in netx.jar:net/sourceforge/jnlp/resource/Messages.properties");
        }
    }

    Translator(ResourceBundle resources) {
        this.resources = resources;
    }

    public static Translator getInstance() {
        return TranslatorHolder.getTransaltor();
    }

    public static String R(String message) {
        return Translator.R(message, new Object[0]);
    }

    public static String R(String message, Object ... params) {
        return Translator.getInstance().getMessage(message, params);
    }

    public static String VVPossibleBrowserValues() {
        return Translator.R("VVPossibleBrowserValues", "rundll32 url.dll,FileProtocolHandler ", "BROWSER", "INTERNAL-HTML", "ALWAYS-ASK", "deployment.browser.path");
    }

    protected String getMessage(String key, Object ... args) {
        return MessageFormat.format(this.getMessage(key), args);
    }

    private String getMessage(String key) {
        try {
            String result = this.resources.getString(key);
            if (result.length() == 0) {
                return "";
            }
            return result;
        }
        catch (NullPointerException e) {
            return this.getMessage("RNoResource", key);
        }
        catch (ClassCastException | MissingResourceException e) {
            if (key == "RNoResource") {
                return "No localized text found";
            }
            return this.getMessage("RNoResource", key);
        }
    }

    private static class TranslatorHolder {
        private static final Translator INSTANCE = new Translator();

        private TranslatorHolder() {
        }

        private static Translator getTransaltor() {
            return INSTANCE;
        }
    }
}

