/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.net.URL;
import net.sourceforge.jnlp.AbstractLaunchHandler;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.util.BasicExceptionDialog;
import net.sourceforge.jnlp.util.logging.OutputController;
import net.sourceforge.swing.SwingUtils;

public class GuiLaunchHandler
extends AbstractLaunchHandler {
    private volatile JNLPSplashScreen splashScreen = null;
    private final Object mutex = new Object();
    private UpdatePolicy policy = UpdatePolicy.ALWAYS;

    public GuiLaunchHandler(OutputController outputStream) {
        super(outputStream);
    }

    @Override
    public void launchCompleted(ApplicationInstance application) {
    }

    @Override
    public void launchError(LaunchException exception) {
        BasicExceptionDialog.willBeShown();
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
            }
        });
        this.printMessage(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSplashScreen() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.splashScreen != null) {
                if (this.splashScreen.isSplashScreenValid()) {
                    this.splashScreen.setVisible(false);
                    this.splashScreen.stopAnimation();
                }
                this.splashScreen.dispose();
            }
        }
    }

    @Override
    public void launchStarting(ApplicationInstance application) {
        SwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiLaunchHandler.this.closeSplashScreen();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchInitialized(final JNLPFile file) {
        int preferredWidth = 500;
        int preferredHeight = 400;
        final URL splashImageURL = file.getInformation().getIconLocation(IconDesc.SPLASH, preferredWidth, preferredHeight);
        final ResourceTracker resourceTracker = new ResourceTracker(true);
        if (splashImageURL != null) {
            resourceTracker.addResource(splashImageURL, file.getFileVersion(), null, this.policy);
        }
        Object object = this.mutex;
        synchronized (object) {
            SwingUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GuiLaunchHandler.this.splashScreen = new JNLPSplashScreen(resourceTracker, file);
                    GuiLaunchHandler.this.splashScreen.setSplashImageURL(splashImageURL);
                }
            });
        }
        SwingUtils.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (GuiLaunchHandler.this.splashScreen != null) {
                    Object object = GuiLaunchHandler.this.mutex;
                    synchronized (object) {
                        if (GuiLaunchHandler.this.splashScreen.isSplashScreenValid()) {
                            GuiLaunchHandler.this.splashScreen.setVisible(true);
                        }
                    }
                }
            }
        });
    }

    @Override
    public boolean launchWarning(LaunchException warning) {
        this.printMessage(warning);
        return true;
    }

    @Override
    public boolean validationError(LaunchException error) {
        this.closeSplashScreen();
        this.printMessage(error);
        return true;
    }
}

