/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.actions;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.i2c.I2cConnection;
import org.soyatec.connector.api.i2c.II2cSettings;
import org.soyatec.connector.api.serial.ISerialSettings;
import org.soyatec.connector.api.serial.SerialConnection;
import org.soyatec.connector.api.telnet.ITelnetSettings;
import org.soyatec.connector.api.telnet.TelnetConnection;
import org.soyatec.connector.api.ui.config.i2c.I2cSetting;
import org.soyatec.connector.api.ui.config.serial.SerialSettings;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;
import org.soyatec.connector.manager.ui.ConnectionManagerDialog;

public class ConnectionManagerAction
extends Action {
    private static IConnectorSetting lastConnectorSetting;
    private String ID = "connectionManagerAction";

    public ConnectionManagerAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(this.ID);
    }

    public ConnectionManagerAction(String text) {
        this(text, null);
    }

    public void run() {
        ConnectionManager cManager = ConnectionManager.INSTANCE;
        IConnectorSetting setting = null;
        IConnection<?> connection = cManager.getActiveConnection();
        Collection<IConnectorSetting> allConnectionSettings = cManager.getAllConnectionSettings();
        if (connection == null) {
            setting = lastConnectorSetting != null ? lastConnectorSetting : (allConnectionSettings != null && allConnectionSettings.size() > 0 ? (IConnectorSetting)allConnectionSettings.toArray()[0] : cManager.getConnectors()[0]);
        } else if (connection instanceof SerialConnection) {
            IConnectorSetting[] connectors;
            SerialConnection serialConnection = (SerialConnection)connection;
            IConnectorSetting[] iConnectorSettingArray = connectors = cManager.getConnectors();
            int n = connectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorSetting iConnectorSetting = iConnectorSettingArray[n2];
                if (iConnectorSetting instanceof SerialConnectorSetting) {
                    SerialConnectorSetting serialConnectorSetting = (SerialConnectorSetting)iConnectorSetting;
                    SerialSettings serialSettings = serialConnectorSetting.getSerialSettings();
                    ISerialSettings serialSetting = serialConnection.getSettings();
                    serialSettings.update(serialSetting);
                    setting = iConnectorSetting;
                    break;
                }
                ++n2;
            }
        } else if (connection instanceof TelnetConnection) {
            IConnectorSetting[] connectors;
            TelnetConnection telnetConnection = (TelnetConnection)connection;
            IConnectorSetting[] iConnectorSettingArray = connectors = cManager.getConnectors();
            int n = connectors.length;
            int n3 = 0;
            while (n3 < n) {
                IConnectorSetting iConnectorSetting = iConnectorSettingArray[n3];
                if (iConnectorSetting instanceof TelnetConnectorSetting) {
                    TelnetConnectorSetting telnetConnectorSetting = (TelnetConnectorSetting)iConnectorSetting;
                    ITelnetSettings telnetSetting = telnetConnection.getSettings();
                    telnetConnectorSetting.getTelnetSetting().update(telnetSetting);
                    setting = iConnectorSetting;
                    break;
                }
                ++n3;
            }
        } else if (connection instanceof I2cConnection) {
            IConnectorSetting[] connectors;
            I2cConnection i2cConnection = (I2cConnection)connection;
            IConnectorSetting[] iConnectorSettingArray = connectors = cManager.getConnectors();
            int n = connectors.length;
            int n4 = 0;
            while (n4 < n) {
                IConnectorSetting iConnectorSetting = iConnectorSettingArray[n4];
                if (iConnectorSetting instanceof I2cConnectorSetting) {
                    I2cConnectorSetting i2cConnectorSetting = (I2cConnectorSetting)iConnectorSetting;
                    I2cSetting i2cSettings = i2cConnectorSetting.getI2cSettings();
                    II2cSettings i2cSetting = i2cConnection.getSettings();
                    i2cSettings.update(i2cSetting);
                    setting = iConnectorSetting;
                    break;
                }
                ++n4;
            }
        }
        ConnectionManagerAction.registerSetting(setting);
        if (setting != null) {
            ConnectionManagerDialog dialog = new ConnectionManagerDialog(Display.getDefault().getActiveShell(), cManager.getConnectors(), setting);
            dialog.open();
        }
    }

    public static void registerSetting(IConnectorSetting setting) {
        lastConnectorSetting = setting;
    }

    public static IConnectorSetting getLastConnectorSetting() {
        return lastConnectorSetting;
    }

    public static void setLastConnectorSetting(IConnectorSetting lastConnectorSetting) {
        ConnectionManagerAction.lastConnectorSetting = lastConnectorSetting;
    }
}

