/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager.actions;

import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.IConnectionManager;
import org.soyatec.connector.api.i2c.I2cConnection;
import org.soyatec.connector.api.i2c.II2cSettings;
import org.soyatec.connector.api.serial.ISerialSettings;
import org.soyatec.connector.api.serial.SerialConnection;
import org.soyatec.connector.api.serial.exceptions.PortBusyException;
import org.soyatec.connector.api.serial.exceptions.PortNotFoundException;
import org.soyatec.connector.api.telnet.ITelnetSettings;
import org.soyatec.connector.api.telnet.TelnetConnection;
import org.soyatec.connector.api.ui.config.telnet.TelnetSetting;
import org.soyatec.connector.manager.ConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.IManagerChangedListener;
import org.soyatec.connector.manager.Messages;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;
import org.soyatec.exceptions.TelnetLoginException;
import org.soyatec.exceptions.TimeoutException;

public class ConnectingAction
extends Action
implements IManagerChangedListener {
    private String ID = "connectionAction";

    public ConnectingAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(this.ID);
        this.setEnabled(true);
        ConnectionManager.INSTANCE.addManagerChangedListener(this);
    }

    public ConnectingAction(String text) {
        this(text, null);
    }

    boolean getNewEnabled() {
        String currentSettingKey = ConnectionManager.INSTANCE.getCurrentSettingKey();
        if (currentSettingKey == null) {
            return false;
        }
        IConnection<?> connection = this.getConnection();
        return connection == null || !connection.isConnected();
    }

    public IConnection<?> getConnection() {
        ConnectionManager m = ConnectionManager.INSTANCE;
        String currentSettings = m.getCurrentSettingKey();
        IConnectorSetting connectionSettings = m.getConnectionSettingsByKey(currentSettings);
        return m.getConnection(connectionSettings);
    }

    public void run() {
        ConnectionManager m = ConnectionManager.INSTANCE;
        String currentSettings = m.getCurrentSettingKey();
        IConnectorSetting connectionSettings = m.getConnectionSettingsByKey(currentSettings);
        if (connectionSettings instanceof SerialConnectorSetting) {
            try {
                SerialConnection connection = SerialConnection.createConnection((ISerialSettings)((SerialConnectorSetting)connectionSettings).getSerialSettings());
                if (connection != null) {
                    m.addConnection(connectionSettings, (IConnection<?>)connection);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)NLS.bind((String)Messages.ConnectingAction_SerialPort_Connecting_failed, (Object)((SerialConnectorSetting)connectionSettings).getSerialSettings().getSerialPort()));
            }
            catch (PortNotFoundException e) {
                e.printStackTrace();
            }
            catch (PortBusyException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCommOperationException e) {
                e.printStackTrace();
            }
        } else if (connectionSettings instanceof TelnetConnectorSetting) {
            this.connect(m, (TelnetConnectorSetting)connectionSettings);
        } else if (connectionSettings instanceof I2cConnectorSetting) {
            try {
                I2cConnection connection = I2cConnection.createConnection((II2cSettings)((I2cConnectorSetting)connectionSettings).getI2cSettings());
                if (connection != null) {
                    m.addConnection(connectionSettings, (IConnection<?>)connection);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void connect(final ConnectionManager m, final TelnetConnectorSetting connector) {
        this.setEnabled(false);
        Job job = new Job("Connecting"){

            protected IStatus run(IProgressMonitor monitor) {
                String[] err;
                block9: {
                    err = new String[1];
                    TelnetSetting telnetSetting = connector.getTelnetSetting();
                    TelnetConnection connection = null;
                    try {
                        connection = TelnetConnection.createConnection((ITelnetSettings)telnetSetting);
                        if (connection != null) {
                            boolean login = connection.login();
                            if (login) {
                                m.addConnection(connector, (IConnection<?>)connection);
                            }
                            connection.setConnectionManager((IConnectionManager)m);
                        }
                        return Status.OK_STATUS;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        err[0] = NLS.bind((String)Messages.ConnectingAction_Failed_to_Connect_Telnet, (Object)(String.valueOf(telnetSetting.getHost()) + ":" + telnetSetting.getNetworkPort()));
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                        err[0] = NLS.bind((String)Messages.ConnectingAction_Telnet_Timeout, (Object)(String.valueOf(telnetSetting.getHost()) + ":" + telnetSetting.getNetworkPort()));
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (TelnetLoginException e) {
                        e.printStackTrace();
                        err[0] = Messages.ConnectingAction_Telnet_Login_Error;
                        if (connection == null) break block9;
                        connection.close();
                    }
                }
                if (err[0] != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)err[0]);
                            ConnectingAction.this.setEnabled(true);
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Override
    public void connectionSettingRemoved(IConnectorSetting connectionSettings) {
        this.activeConnectionChanged();
    }

    @Override
    public void connectionSettingAdded(IConnectorSetting connectionSettings) {
        this.activeConnectionChanged();
    }

    @Override
    public void connected(IConnection<?> connection) {
        this.activeConnectionChanged();
    }

    @Override
    public void unconnectioned(IConnection<?> connection) {
        this.activeConnectionChanged();
    }

    @Override
    public void activeConnectionChanged() {
        boolean enabled2 = this.isEnabled();
        boolean newEnabled = this.getNewEnabled();
        this.firePropertyChange("enabled", enabled2, newEnabled);
        this.setEnabled(newEnabled);
    }
}

