/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.soyatec.connector.api.IModifiedListener;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.ISettingsPage;
import org.soyatec.connector.manager.PageBook;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;

public class ConnectorSettingDialog
extends Dialog {
    private String title = "Connector Settings";
    private IConnectorSetting[] fConnectors;
    private ISettingsPage[] fPages;
    private int fSelectedConnector;
    private int[] fPageIndex;
    private int fNPages;
    private PageBook fPageBook;
    private Text fTerminalTitleText;
    private Combo fCtlConnTypeCombo;
    private String chipName = "";

    public ConnectorSettingDialog(Shell shell, IConnectorSetting[] connectors, IConnectorSetting connector) {
        super(shell);
        this.fConnectors = this.getValidConnectors(connectors);
        this.fPages = new ISettingsPage[this.fConnectors.length];
        this.fPageIndex = new int[this.fConnectors.length];
        this.fSelectedConnector = -1;
        int i = 0;
        while (i < this.fConnectors.length) {
            if (this.fConnectors[i] == connector) {
                this.fSelectedConnector = i;
            }
            ++i;
        }
    }

    private IConnectorSetting[] getValidConnectors(IConnectorSetting[] connectors) {
        return connectors;
    }

    ISettingsPage getPage(int i) {
        if (this.fPages[i] == null) {
            if (this.fConnectors[i].getInitializationErrorMessage() != null) {
                final IConnectorSetting conn = this.fConnectors[i];
                this.fPages[i] = new ISettingsPage(){

                    @Override
                    public void createControl(PageBook fPageBook) {
                        Label l = new Label((Composite)fPageBook, 64);
                        String error = String.valueOf(conn.getType()) + " Connector not available.";
                        l.setText(error);
                        l.setForeground(l.getDisplay().getSystemColor(3));
                        String msg = "Can't initalize Connector " + conn.getType() + "\t" + conn.getInitializationErrorMessage();
                        MessageBox mb = new MessageBox(ConnectorSettingDialog.this.getShell(), 33);
                        mb.setText(error);
                        mb.setMessage(msg);
                        mb.open();
                    }

                    @Override
                    public void save() {
                    }

                    @Override
                    public void load() {
                    }

                    @Override
                    public void setModifiedListener(IModifiedListener l) {
                    }
                };
            } else {
                this.fPages[i] = this.fConnectors[i].makeSettingsPage();
            }
            this.fPages[i].createControl(this.fPageBook);
            ++this.fNPages;
            this.resize();
        }
        return this.fPages[i];
    }

    private void setupListeners() {
        if (this.fCtlConnTypeCombo == null) {
            return;
        }
        this.fCtlConnTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ConnectorSettingDialog.this.selectPage(ConnectorSettingDialog.this.fCtlConnTypeCombo.getSelectionIndex());
            }
        });
    }

    private void selectPage(int index) {
        this.fSelectedConnector = index;
        this.getPage(index);
        Control[] pages = this.fPageBook.getChildren();
        this.fPageBook.showPage(pages[this.fPageIndex[this.fSelectedConnector]]);
        this.updateOKButton();
    }

    private void updateOKButton() {
        if (this.getButton(0) != null) {
            boolean enable = false;
            if (this.getConnector() != null) {
                boolean bl = enable = this.getConnector().getInitializationErrorMessage() == null;
            }
            if (!enable && this.fConnectors.length == 0) {
                enable = true;
            }
            this.getButton(0).setEnabled(enable);
        }
    }

    public IConnectorSetting getConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fConnectors[this.fSelectedConnector];
        }
        return null;
    }

    void resize() {
        Point size = this.getShell().getSize();
        Point newSize = this.getShell().computeSize(-1, -1, true);
        newSize.x = Math.max(newSize.x, size.x);
        newSize.y = Math.max(newSize.y, size.y);
        if (newSize.x != size.x || newSize.y != size.y) {
            this.setShellSize(newSize);
        } else {
            this.fPageBook.getParent().layout();
        }
    }

    protected void setShellSize(Point size) {
        Rectangle bounds = this.getShell().getMonitor().getClientArea();
        this.getShell().setSize(Math.min(size.x, bounds.width), Math.min(size.y, bounds.height));
    }

    protected Control createDialogArea(Composite parent) {
        Composite ctlComposite = (Composite)super.createDialogArea(parent);
        this.setupPanel(ctlComposite);
        this.setupListeners();
        this.initFields();
        return ctlComposite;
    }

    private void initFields() {
        int i = 0;
        while (i < this.fConnectors.length) {
            this.fCtlConnTypeCombo.add(this.fConnectors[i].getType());
            ++i;
        }
        int selectedConnector = this.getInitialConnector();
        if (selectedConnector >= 0) {
            this.fCtlConnTypeCombo.select(selectedConnector);
            this.selectPage(selectedConnector);
        }
    }

    private int getInitialConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fSelectedConnector;
        }
        int i = 0;
        while (i < this.fConnectors.length) {
            if (this.fConnectors[i] instanceof TelnetConnectorSetting) {
                return i;
            }
            ++i;
        }
        if (this.fConnectors.length > 0) {
            return 0;
        }
        return -1;
    }

    private void setupPanel(Composite wndParent) {
        this.setupSettingsTypePanel(wndParent);
        if (this.fConnectors.length > 0) {
            this.setupConnTypePanel(wndParent);
            this.setupSettingsGroup(wndParent);
        }
    }

    private void setupSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Settings:");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.fPageBook = new PageBook((Composite)group, 0);
        this.fPageBook.setLayoutData(new GridData(768));
    }

    private void setupConnTypePanel(Composite parent) {
        Group wndGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        GridData gridData = new GridData(768);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)gridData);
        wndGroup.setText("Connection Type:");
        this.fCtlConnTypeCombo = new Combo((Composite)wndGroup, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fCtlConnTypeCombo.setLayoutData((Object)gridData);
    }

    private void setupSettingsTypePanel(Composite wndParent) {
        Group wndGroup = new Group(wndParent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)new GridData(768));
        wndGroup.setText("Chip");
        this.fTerminalTitleText = new Text((Composite)wndGroup, 2048);
        this.fTerminalTitleText.setText(this.chipName);
        this.fTerminalTitleText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectorSettingDialog.this.chipName = ConnectorSettingDialog.this.fTerminalTitleText.getText().trim();
            }
        });
        this.fTerminalTitleText.setLayoutData((Object)new GridData(768));
    }

    protected void okPressed() {
        ISettingsPage page = this.getPage(this.fSelectedConnector);
        page.save();
        super.okPressed();
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().pack();
    }

    protected Point getInitialSize() {
        return new Point(400, 600);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(68));
        this.createButton(parent, 0, "\u786e\u951f\u65a4\u62f7", false);
        this.createButton(parent, 1, "\u53d6\u951f\u65a4\u62f7", false);
    }

    public static void main(String[] args) {
        IConnectorSetting[] connectors = new IConnectorSetting[]{new SerialConnectorSetting(), new TelnetConnectorSetting(), new I2cConnectorSetting()};
        ConnectorSettingDialog serialSettingDialog = new ConnectorSettingDialog(new Shell(), connectors, connectors[0]);
        int open = serialSettingDialog.open();
        if (open == 1) {
            return;
        }
        IConnectorSetting connector = serialSettingDialog.getConnector();
        if (connector instanceof TelnetConnectorSetting) {
            TelnetConnectorSetting telnetConnector = (TelnetConnectorSetting)connector;
            System.out.println(telnetConnector.getTelnetSetting().getSummary());
        } else if (connector instanceof SerialConnectorSetting) {
            SerialConnectorSetting telnetConnector = (SerialConnectorSetting)connector;
            System.out.println(telnetConnector.getSerialSettings().getSummary());
        } else if (connector instanceof I2cConnectorSetting) {
            I2cConnectorSetting i2cConnector = (I2cConnectorSetting)connector;
            System.out.println(i2cConnector.getI2cSettings().getSummary());
        }
    }

    public String getChipName() {
        return this.chipName;
    }

    public void setChipName(String chipName) {
        if (chipName == null) {
            chipName = "";
        }
        this.chipName = chipName;
    }
}

