/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.soyatec.connector.api.IConnection;
import org.soyatec.connector.api.IConnectionManager;
import org.soyatec.connector.manager.IConnectorSetting;
import org.soyatec.connector.manager.IManagerChangedListener;
import org.soyatec.connector.manager.IManagerChangedListener2;
import org.soyatec.connector.manager.Messages;
import org.soyatec.connector.manager.actions.ComboContributionItem;
import org.soyatec.connector.manager.i2c.I2cConnectorSetting;
import org.soyatec.connector.manager.preferences.Preferences;
import org.soyatec.connector.manager.serial.SerialConnectorSetting;
import org.soyatec.connector.manager.telnet.TelnetConnectorSetting;
import org.soyatec.connector.manager.ui.IConnectionSettingNameUpdatedListener;

public class ConnectionManager
implements IConnectionManager {
    public static final ConnectionManager INSTANCE = new ConnectionManager();
    static IConnectorSetting[] connectors;
    private ComboContributionItem comboContributionItem;
    private List<IManagerChangedListener> listeners = new ArrayList<IManagerChangedListener>();
    private HashMap<String, IConnectorSetting> connectionSettings = new HashMap();
    private List<String> keys = new ArrayList<String>();
    private HashMap<IConnectorSetting, IConnection<?>> connections = new HashMap();
    private IConnectionSettingNameUpdatedListener nameListener = null;
    private IConnectorSetting currentSettings;

    static {
        Preferences.loadConnectorSettings();
        connectors = new IConnectorSetting[]{new SerialConnectorSetting(), new TelnetConnectorSetting(), new I2cConnectorSetting()};
    }

    private ConnectionManager() {
    }

    public IConnectorSetting[] getConnectors() {
        return (IConnectorSetting[])connectors.clone();
    }

    public void addConnectionSettings(IConnectorSetting settings) {
        if (settings == null) {
            return;
        }
        this.keys.add(settings.getID());
        this.connectionSettings.put(settings.getID(), settings);
        for (IManagerChangedListener l : this.listeners) {
            l.connectionSettingAdded(settings);
        }
    }

    public void clearAllConnectionSettings() {
        this.connectionSettings.clear();
    }

    public IConnection<?> getConnection(IConnectorSetting connectorSetting) {
        return this.connections.get(connectorSetting);
    }

    public void addConnection(IConnectorSetting setting, final IConnection<?> connection) {
        this.connections.put(setting, connection);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IManagerChangedListener listener : ConnectionManager.this.listeners) {
                    listener.connected(connection);
                }
            }
        });
    }

    public IConnectorSetting getConnectionSettingsByKey(String key) {
        return this.connectionSettings.get(key);
    }

    public Collection<IConnectorSetting> getAllConnectionSettings() {
        ArrayList<IConnectorSetting> connectorSettings = new ArrayList<IConnectorSetting>(this.connectionSettings.keySet().size());
        for (String key : this.keys) {
            if (connectorSettings.contains(this.connectionSettings.get(key))) continue;
            connectorSettings.add(this.connectionSettings.get(key));
        }
        return connectorSettings;
    }

    public IConnection<?> getActiveConnection() {
        return this.connections.get(this.currentSettings);
    }

    public void addManagerChangedListener(IManagerChangedListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeManagerChangedListener(IManagerChangedListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeConnectionSettingsByKey(String key) {
        final IConnectorSetting settings = this.getConnectionSettingsByKey(key);
        if (settings == null) {
            this.connectionSettings.remove(key);
            return;
        }
        IConnection<?> connection = this.getConnection(settings);
        if (connection != null) {
            connection.close();
        }
        this.keys.remove(key);
        this.connections.remove(settings);
        IConnectorSetting remove = this.connectionSettings.remove(key);
        if (remove == this.currentSettings) {
            this.currentSettings = null;
        }
        for (final IManagerChangedListener l : this.listeners) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    l.connectionSettingRemoved(settings);
                }
            });
        }
    }

    public String getCurrentSettingName() {
        IConnectorSetting[] array;
        if (this.currentSettings == null && (array = this.connectionSettings.values().toArray(new IConnectorSetting[this.connectionSettings.values().size()])).length > 0) {
            this.currentSettings = array[0];
        }
        return this.currentSettings == null ? null : this.currentSettings.getName();
    }

    public String getCurrentSettingKey() {
        IConnectorSetting[] array;
        if (this.currentSettings == null && (array = this.connectionSettings.values().toArray(new IConnectorSetting[this.connectionSettings.values().size()])).length > 0) {
            this.currentSettings = array[0];
        }
        return this.currentSettings == null ? null : this.currentSettings.getID();
    }

    public IConnectorSetting findByName(String name) {
        Collection<IConnectorSetting> values = this.connectionSettings.values();
        for (IConnectorSetting cc : values) {
            if (!name.equals(cc.getName())) continue;
            return cc;
        }
        return null;
    }

    public void setCurrentSettings(String name) {
        this.currentSettings = this.findByName(name);
        for (final IManagerChangedListener l : this.listeners) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    l.activeConnectionChanged();
                }
            });
        }
    }

    public void close(final IConnection<?> connection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                for (IManagerChangedListener l : ConnectionManager.this.listeners) {
                    if (!(l instanceof IManagerChangedListener2)) continue;
                    ((IManagerChangedListener2)l).unconnectioning(connection);
                }
            }
        });
        connection.close();
        this.connections.remove(this.getConnectionSettingsByKey(this.getCurrentSettingKey()));
        for (final IManagerChangedListener l : this.listeners) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    l.unconnectioned(connection);
                }
            });
        }
    }

    public void dispose() {
        this.listeners.clear();
        Collection<IConnection<?>> values = this.connections.values();
        for (IConnection<?> connection : values) {
            connection.close();
        }
        this.connections.clear();
        this.connectionSettings.clear();
    }

    public void notifyConnectionInterrupted(IConnection<?> connection) {
        if (connection != null) {
            Set<IConnectorSetting> keySet = this.connections.keySet();
            for (IConnectorSetting iConnectorSetting : keySet) {
                if (this.connections.get(iConnectorSetting) != connection) continue;
                this.connections.remove(iConnectorSetting);
                break;
            }
            this.close(connection);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)Messages.Warning, (String)Messages.ConnectionInterrupted);
                }
            });
        }
    }

    public void updatingName(IConnectorSetting oldSettings, String name) {
        oldSettings.setName(name);
        if (this.nameListener != null) {
            this.nameListener.nameUpdated(oldSettings);
        }
    }

    public IConnectionSettingNameUpdatedListener getNameListener() {
        return this.nameListener;
    }

    public void setNameListener(IConnectionSettingNameUpdatedListener nameListener) {
        this.nameListener = nameListener;
    }

    public ComboContributionItem getComboContributionItem() {
        return this.comboContributionItem;
    }

    public void setComboContributionItem(ComboContributionItem comboContributionItem) {
        this.comboContributionItem = comboContributionItem;
    }
}

