/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core.externaltools;

import com.soyatec.hisilicon.platform.core.externaltools.model.ExternalTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class ToolsLoader {
    private static final String EXTERNAL_FOLDER = "ExternalTools";
    private static final String TOOLS_XML = "tools.xml";
    public static final ToolsLoader instance = new ToolsLoader();
    private List<ExternalTool> externalTools = null;
    private Exception e = null;

    private ToolsLoader() {
        try {
            this.externalTools = this.parseTools();
        }
        catch (Exception e) {
            this.e = e;
        }
    }

    public List<ExternalTool> getExternalTools() throws Exception {
        if (this.e != null) {
            throw this.e;
        }
        return this.externalTools;
    }

    public File findsubfilesInExternalFolder(String subPath) {
        File subFile = new File(this.findExternalFolder(), subPath);
        return subFile;
    }

    private File findExternalFolder() {
        Location installLocation = Platform.getInstallLocation();
        String file = installLocation.getURL().getFile();
        File installFolder = new File(file);
        return new File(installFolder, EXTERNAL_FOLDER);
    }

    private List<ExternalTool> parseTools() throws Exception {
        ArrayList<ExternalTool> list = new ArrayList<ExternalTool>();
        File toolsXML = this.findsubfilesInExternalFolder(TOOLS_XML);
        SAXReader reader = new SAXReader();
        Document document = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(toolsXML);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            document = reader.read((InputStream)in);
            Element root = document.getRootElement();
            Iterator i_pe = root.elementIterator();
            while (i_pe.hasNext()) {
                String nameENAttr;
                Element e_pe = (Element)i_pe.next();
                String nameCNAttr = e_pe.attributeValue("nameCN");
                if (nameCNAttr == null || nameCNAttr.length() == 0) {
                    nameCNAttr = "";
                }
                if ((nameENAttr = e_pe.attributeValue("nameEN")) == null || nameENAttr.length() == 0) {
                    nameENAttr = "";
                }
                String exePath = this.convert(e_pe, "exePath");
                String descEN = this.convert(e_pe, "descEN");
                String descCN = this.convert(e_pe, "descCN");
                String iconPath = this.convert(e_pe, "iconPath");
                String docEN = this.convert(e_pe, "docEN");
                String docCN = this.convert(e_pe, "docCN");
                String chipName = this.convert(e_pe, "chipName");
                ExternalTool tool = new ExternalTool();
                tool.setNameCNAttr(nameCNAttr);
                tool.setNameENAttr(nameENAttr);
                tool.setDescCN(descCN);
                tool.setDescEN(descEN);
                tool.setIconPath(iconPath);
                tool.setExePath(exePath);
                tool.setDocCN(docCN);
                tool.setDocEN(docEN);
                tool.setChipName(chipName);
                list.add(tool);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return list;
    }

    private String convert(Element e_pe, String elementName) {
        try {
            return e_pe.element(elementName).getText();
        }
        catch (Exception e) {
            return "";
        }
    }
}

