/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core;

import com.soyatec.hisilicon.platform.core.PlatformCoreActivator;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.osgi.framework.Bundle;

public class ToolDescriptor {
    public IInstallableUnit iu;
    public ToolProperties props;
    private List<PluginDetail> plugins;

    public ToolDescriptor(IInstallableUnit iu) {
        this.iu = iu;
        this.props = new ToolProperties(PlatformCoreActivator.getDefault().getToolManager().getToolInfo(iu));
    }

    public IInstallableUnit getInstallableUnit() {
        return this.iu;
    }

    public String getId() {
        return this.props.getId();
    }

    public String getVersion() {
        return this.props.getVersion();
    }

    public String getName() {
        return this.props.getName();
    }

    public Map<String, String> getProperties() {
        return this.iu.getProperties();
    }

    public String[] getPluginIds() {
        List<PluginDetail> list = this.getPlugins();
        String[] pluginIds = new String[list.size()];
        int i = 0;
        while (i < pluginIds.length) {
            pluginIds[i] = list.get(i).getPluginId();
            ++i;
        }
        return pluginIds;
    }

    public List<PluginDetail> getPlugins() {
        if (this.plugins == null) {
            Set<String> list = PlatformCoreActivator.getDefault().getToolManager().getToolPlugins(this.iu);
            this.plugins = new ArrayList<PluginDetail>();
            for (String id : list) {
                String name = null;
                String providerName = null;
                String version = null;
                PluginDetail p = new PluginDetail();
                p.setPluginId(id);
                Bundle bundle = Platform.getBundle((String)id);
                try {
                    if (bundle != null) {
                        Dictionary headers = bundle.getHeaders();
                        name = headers.get("Bundle-Name") == null ? "" : (String)headers.get("Bundle-Name");
                        providerName = headers.get("Bundle-Vendor") == null ? "" : (String)headers.get("Bundle-Vendor");
                        version = headers.get("Bundle-Version") == null ? "" : (String)headers.get("Bundle-Version");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                p.setPluginName(name);
                p.setVersion(version);
                p.setProvider(providerName);
                this.plugins.add(p);
            }
        }
        return this.plugins;
    }

    public static class PluginDetail {
        private String provider;
        private String pluginName;
        private String version;
        private String pluginId;

        public String getProvider() {
            return this.provider == null ? "" : this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getPluginName() {
            return this.pluginName;
        }

        public void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }
    }

    public static class ToolProperties {
        private static final String DEFAULT_STING = "N/A";
        private String name = "N/A";
        private String version = "N/A";
        private String provider = "N/A";
        private String releaseDate = "N/A";
        private String state = "N/A";
        private String registerState = "N/A";
        private String registerDate = "N/A";
        private String license = "N/A";
        private String id = "N/A";
        private String copyright;
        private String description;
        private Map<String, String> properties;

        public ToolProperties() {
        }

        public ToolProperties(Map<String, String> map) {
            this.id = map.get("id");
            this.name = map.get("org.eclipse.equinox.p2.name");
            this.provider = map.get("org.eclipse.equinox.p2.provider");
            this.description = map.get("org.eclipse.equinox.p2.description");
            this.copyright = map.get("copyright");
            this.license = map.get("license");
            this.version = map.get("version");
            if (this.version != null) {
                int pos = this.version.lastIndexOf(46);
                this.releaseDate = this.version.substring(pos + 1);
                this.version = this.version.substring(0, pos);
            }
            this.properties = map;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public String getProperty(String key) {
            return this.properties.get(key);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCopyright() {
            return this.copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getReleaseDate() {
            return this.releaseDate;
        }

        public void setReleaseDate(String releaseDate) {
            this.releaseDate = releaseDate;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getRegisterState() {
            return this.registerState;
        }

        public void setRegisterState(String registerState) {
            this.registerState = registerState;
        }

        public String getRegisterDate() {
            return this.registerDate;
        }

        public void setRegisterDate(String registerDate) {
            this.registerDate = registerDate;
        }

        public String getLicense() {
            return this.license;
        }

        public void setLicense(String license) {
            this.license = license;
        }
    }
}

