/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.core;

import com.soyatec.hisilicon.platform.api.IDeviceManager;
import com.soyatec.hisilicon.platform.api.IHisiLog;
import com.soyatec.hisilicon.platform.api.IHisiLogManager;
import com.soyatec.hisilicon.platform.core.IPreferenceStorageManager;
import com.soyatec.hisilicon.platform.core.IToolManager;
import com.soyatec.hisilicon.platform.core.Messages;
import com.soyatec.hisilicon.platform.core.internal.DeviceManager;
import com.soyatec.hisilicon.platform.core.internal.HisiErrorLog;
import com.soyatec.hisilicon.platform.core.internal.HisiLogManager;
import com.soyatec.hisilicon.platform.core.internal.JaxbUtils;
import com.soyatec.hisilicon.platform.core.internal.PreferenceStorageManager;
import com.soyatec.hisilicon.platform.core.internal.PreferenceUtils;
import com.soyatec.hisilicon.platform.core.internal.ToolManager;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.IdentityHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;

public class PlatformCoreActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.soyatec.hisilicon.platform.core";
    private static PlatformCoreActivator plugin;
    private ServiceTracker packageAdminTracker;
    private ServiceTracker platformAdminTracker;
    private ServiceRegistration<IHisiLogManager> logManager;
    private ServiceRegistration<IDeviceManager> deviceManager;
    private IdentityHashMap<Object, ServiceReference<?>> services;
    ToolManager toolManager;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        PlatformCoreActivator.registerActivator(this);
        this.packageAdminTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.packageAdminTracker.open();
        this.platformAdminTracker = new ServiceTracker(context, PlatformAdmin.class.getName(), null);
        this.platformAdminTracker.open();
        this.logManager = context.registerService(IHisiLogManager.class, (Object)new HisiLogManager(), null);
        this.deviceManager = context.registerService(IDeviceManager.class, (Object)DeviceManager.getInstance(), null);
    }

    public static BundleContext getBundleContext() {
        return PlatformCoreActivator.getDefault().getBundle().getBundleContext();
    }

    public void stop(BundleContext context) throws Exception {
        PlatformCoreActivator.unregisterActivator();
        super.stop(context);
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        if (this.platformAdminTracker != null) {
            this.platformAdminTracker.close();
            this.platformAdminTracker = null;
        }
        this.logManager.unregister();
        this.deviceManager.unregister();
    }

    private static void registerActivator(PlatformCoreActivator activator) {
        plugin = activator;
    }

    private static void unregisterActivator() {
        plugin = null;
    }

    public static PlatformCoreActivator getDefault() {
        return plugin;
    }

    public <T> T getService(Class<T> serviceClass) throws Exception {
        String serviceName;
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(serviceName = serviceClass.getName());
        if (serviceRef == null) {
            throw new Exception(Messages.PlatformCoreActivator_0);
        }
        T service = serviceClass.cast(context.getService(serviceRef));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef);
        return service;
    }

    public <T> T getService(Class<T> serviceClass, String filter) throws Exception {
        ServiceReference[] serviceRef;
        BundleContext context = this.getBundle().getBundleContext();
        String serviceName = serviceClass.getName();
        try {
            serviceRef = context.getServiceReferences(serviceName, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new Exception(e);
        }
        if (serviceRef == null || serviceRef.length == 0) {
            throw new Exception(Messages.PlatformCoreActivator_1);
        }
        T service = serviceClass.cast(context.getService(serviceRef[0]));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef[0]);
        return service;
    }

    public void ungetService(Object service) {
        ServiceReference<?> serviceRef;
        if (this.services != null && service != null && (serviceRef = this.services.remove(service)) != null) {
            this.getBundle().getBundleContext().ungetService(serviceRef);
        }
    }

    public State getState() {
        return this.getPlatformAdmin().getState(false);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        }
        if (status != null) {
            PlatformCoreActivator.getDefault().getLog().log(status);
        }
    }

    public static IWorkbenchPage getActivePage() {
        return PlatformCoreActivator.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        return PlatformCoreActivator.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformCoreActivator.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public PackageAdmin getPackageAdmin() {
        if (this.packageAdminTracker == null) {
            return null;
        }
        return (PackageAdmin)this.packageAdminTracker.getService();
    }

    public PlatformAdmin getPlatformAdmin() {
        if (this.platformAdminTracker == null) {
            return null;
        }
        return (PlatformAdmin)this.platformAdminTracker.getService();
    }

    public IPreferenceStorageManager getPreferenceStorageManager() {
        return PreferenceStorageManager.getInstance();
    }

    public void saveXml(Object o, Writer writer) throws Exception {
        JaxbUtils.writeObject(o, writer);
    }

    public static IHisiLog getLogger(Plugin plugin) {
        return HisiErrorLog.getInstance(plugin);
    }

    public IToolManager getToolManager() {
        if (this.toolManager == null) {
            this.toolManager = new ToolManager();
        }
        return this.toolManager;
    }

    public Preferences getPreferenceNode(String pluginID, String nodeID) {
        return PreferenceUtils.getPreferenceNode(pluginID, nodeID);
    }

    public File getTempFile() {
        IPath append = plugin.getStateLocation().append(".temp");
        return append.toFile();
    }
}

