/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.view;

import com.hisilicon.terminal.view.PageBook;
import com.hisilicon.terminal.view.TerminalViewPlugin;
import com.hisilicon.terminal.view.ViewMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.ui.PlatformUI;

class TerminalSettingsDlg
extends Dialog {
    private Combo fCtlConnTypeCombo;
    private Text fTerminalTitleText;
    private final ITerminalConnector[] fConnectors;
    private final ISettingsPage[] fPages;
    private final int[] fPageIndex;
    private int fNPages;
    private int fSelectedConnector;
    private PageBook fPageBook;
    private IDialogSettings fDialogSettings;
    private String fTerminalTitle;
    private String fTitle = ViewMessages.TERMINALSETTINGS;

    public TerminalSettingsDlg(Shell shell, ITerminalConnector[] connectors, ITerminalConnector connector) {
        super(shell);
        this.fConnectors = this.getValidConnectors(connectors);
        this.fPages = new ISettingsPage[this.fConnectors.length];
        this.fPageIndex = new int[this.fConnectors.length];
        this.fSelectedConnector = -1;
        int i = 0;
        while (i < this.fConnectors.length) {
            if (this.fConnectors[i] == connector) {
                this.fSelectedConnector = i;
            }
            ++i;
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    private ITerminalConnector[] getValidConnectors(ITerminalConnector[] connectors) {
        ArrayList<ITerminalConnector> list = new ArrayList<ITerminalConnector>(Arrays.asList(connectors));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ITerminalConnector info = (ITerminalConnector)iterator.next();
            if ((!info.isInitialized() || info.getInitializationErrorMessage() == null) && !info.isHidden()) continue;
            iterator.remove();
        }
        connectors = list.toArray(new ITerminalConnector[list.size()]);
        return connectors;
    }

    ISettingsPage getPage(int i) {
        if (this.fPages[i] == null) {
            if (this.fConnectors[i].getInitializationErrorMessage() != null) {
                final ITerminalConnector conn = this.fConnectors[i];
                this.fPages[i] = new ISettingsPage(){

                    public void createControl(Composite parent) {
                        Label l = new Label(parent, 64);
                        String error = NLS.bind((String)ViewMessages.CONNECTOR_NOT_AVAILABLE, (Object)conn.getName());
                        l.setText(error);
                        l.setForeground(l.getDisplay().getSystemColor(3));
                        String msg = NLS.bind((String)ViewMessages.CANNOT_INITIALIZE, (Object)conn.getName(), (Object)conn.getInitializationErrorMessage());
                        MessageBox mb = new MessageBox(TerminalSettingsDlg.this.getShell(), 33);
                        mb.setText(error);
                        mb.setMessage(msg);
                        mb.open();
                    }

                    public void loadSettings() {
                    }

                    public void saveSettings() {
                    }

                    public boolean validateSettings() {
                        return false;
                    }

                    public void addListener(ISettingsPage.Listener listener) {
                    }

                    public void removeListener(ISettingsPage.Listener listener) {
                    }
                };
            } else {
                this.fPages[i] = this.fConnectors[i].makeSettingsPage();
            }
            this.fPages[i].createControl((Composite)this.fPageBook);
            ++this.fNPages;
            this.resize();
        }
        return this.fPages[i];
    }

    void resize() {
        Point size = this.getShell().getSize();
        Point newSize = this.getShell().computeSize(-1, -1, true);
        newSize.x = Math.max(newSize.x, size.x);
        newSize.y = Math.max(newSize.y, size.y);
        if (newSize.x != size.x || newSize.y != size.y) {
            this.setShellSize(newSize);
        } else {
            this.fPageBook.getParent().layout();
        }
    }

    protected void setShellSize(Point size) {
        Rectangle bounds = this.getShell().getMonitor().getClientArea();
        this.getShell().setSize(Math.min(size.x, bounds.width), Math.min(size.y, bounds.height));
    }

    protected void okPressed() {
        if (!this.validateSettings()) {
            String strTitle = ViewMessages.TERMINALSETTINGS;
            MessageBox mb = new MessageBox(this.getShell(), 33);
            mb.setText(strTitle);
            mb.setMessage(ViewMessages.INVALID_SETTINGS);
            mb.open();
            return;
        }
        if (this.fSelectedConnector >= 0) {
            this.getPage(this.fSelectedConnector).saveSettings();
        }
        this.fTerminalTitle = this.fTerminalTitleText.getText();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fSelectedConnector = -1;
        super.cancelPressed();
    }

    public int open() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        return super.open();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite ctlComposite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)ctlComposite, "org.eclipse.tm.terminal.view.terminal_settings");
        this.setupPanel(ctlComposite);
        this.setupListeners();
        this.initFields();
        return ctlComposite;
    }

    public void create() {
        super.create();
        this.updateOKButton();
    }

    private void initFields() {
        int i = 0;
        while (i < this.fConnectors.length) {
            this.fCtlConnTypeCombo.add(this.fConnectors[i].getName());
            ++i;
        }
        int selectedConnector = this.getInitialConnector();
        if (selectedConnector >= 0) {
            this.fCtlConnTypeCombo.select(selectedConnector);
            this.selectPage(selectedConnector);
        }
    }

    private int getInitialConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fSelectedConnector;
        }
        int i = 0;
        while (i < this.fConnectors.length) {
            if ("org.eclipse.tm.internal.terminal.serial.SerialConnector".equals(this.fConnectors[i].getId())) {
                return i;
            }
            ++i;
        }
        if (this.fConnectors.length > 0) {
            return 0;
        }
        return -1;
    }

    private boolean validateSettings() {
        if (this.fSelectedConnector < 0) {
            return true;
        }
        return this.getPage(this.fSelectedConnector).validateSettings();
    }

    private void setupPanel(Composite wndParent) {
        this.setupSettingsTypePanel(wndParent);
        if (this.fConnectors.length > 0) {
            this.setupConnTypePanel(wndParent);
            this.setupSettingsGroup(wndParent);
        }
    }

    private void setupSettingsTypePanel(Composite wndParent) {
        Group wndGroup = new Group(wndParent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)new GridData(768));
        wndGroup.setText(ViewMessages.VIEW_SETTINGS);
        Label label = new Label((Composite)wndGroup, 0);
        label.setText(ViewMessages.VIEW_TITLE);
        label.setLayoutData((Object)new GridData(1));
        this.fTerminalTitleText = new Text((Composite)wndGroup, 2048);
        this.fTerminalTitleText.setText(this.fTerminalTitle);
        this.fTerminalTitleText.setLayoutData((Object)new GridData(768));
    }

    private void setupConnTypePanel(Composite wndParent) {
        Group wndGroup = new Group(wndParent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        GridData gridData = new GridData(768);
        wndGroup.setLayout((Layout)gridLayout);
        wndGroup.setLayoutData((Object)gridData);
        wndGroup.setText(String.valueOf(ViewMessages.CONNECTIONTYPE) + ":");
        this.fCtlConnTypeCombo = new Combo((Composite)wndGroup, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.fCtlConnTypeCombo.setLayoutData((Object)gridData);
    }

    private void setupSettingsGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(String.valueOf(ViewMessages.SETTINGS) + ":");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(1808));
        this.fPageBook = new PageBook((Composite)group, 0);
        this.fPageBook.setLayoutData(new GridData(768));
    }

    private void setupListeners() {
        if (this.fCtlConnTypeCombo == null) {
            return;
        }
        this.fCtlConnTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TerminalSettingsDlg.this.selectPage(TerminalSettingsDlg.this.fCtlConnTypeCombo.getSelectionIndex());
            }
        });
    }

    public ITerminalConnector getConnector() {
        if (this.fSelectedConnector >= 0) {
            return this.fConnectors[this.fSelectedConnector];
        }
        return null;
    }

    private void selectPage(int index) {
        this.fSelectedConnector = index;
        this.getPage(index);
        Control[] pages = this.fPageBook.getChildren();
        this.fPageBook.showPage(pages[this.fPageIndex[this.fSelectedConnector]]);
        this.updateOKButton();
    }

    private void updateOKButton() {
        if (this.getButton(0) != null) {
            boolean enable = false;
            if (this.getConnector() != null) {
                boolean bl = enable = this.getConnector().getInitializationErrorMessage() == null;
            }
            if (!enable && this.fConnectors.length == 0) {
                enable = true;
            }
            this.getButton(0).setEnabled(enable);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings ds = TerminalViewPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = ds.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = ds.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    public void setTerminalTitle(String partName) {
        this.fTerminalTitle = partName;
    }

    public String getTerminalTitle() {
        return this.fTerminalTitle;
    }
}

