/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.terminal.textcanvas;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;

public abstract class VirtualCanvas
extends Canvas {
    private final Rectangle fVirtualBounds = new Rectangle(0, 0, 0, 0);
    private Rectangle fClientArea;
    private boolean fInUpdateScrollbars;
    private static boolean fInUpdateScrollbarsLogged;
    private final Rectangle fViewRectangle = new Rectangle(0, 0, 0, 0);

    public VirtualCanvas(Composite parent, int style) {
        super(parent, style | 0x40000 | 0x100000);
        this.fClientArea = this.getClientArea();
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                VirtualCanvas.this.paint(event.gc);
            }
        });
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                VirtualCanvas.this.fClientArea = VirtualCanvas.this.getClientArea();
                VirtualCanvas.this.onResize();
            }
        });
        this.getVerticalBar().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VirtualCanvas.this.scrollY((ScrollBar)e.widget);
            }
        });
        this.getHorizontalBar().addListener(13, new Listener(){

            public void handleEvent(Event e) {
                VirtualCanvas.this.scrollX((ScrollBar)e.widget);
            }
        });
    }

    protected void onResize() {
        this.updateViewRectangle();
    }

    protected void scrollX(ScrollBar hBar) {
        int hSelection = hBar.getSelection();
        int destX = -hSelection - this.fVirtualBounds.x;
        this.fVirtualBounds.x = -hSelection;
        this.scrollSmart(destX, 0);
        this.updateViewRectangle();
    }

    protected void scrollXDelta(int delta) {
        this.getHorizontalBar().setSelection(-this.fVirtualBounds.x + delta);
        this.scrollX(this.getHorizontalBar());
    }

    protected void scrollY(ScrollBar vBar) {
        int vSelection = vBar.getSelection();
        int destY = -vSelection - this.fVirtualBounds.y;
        if (destY != 0) {
            this.fVirtualBounds.y = -vSelection;
            this.scrollSmart(0, destY);
            this.updateViewRectangle();
        }
    }

    protected void scrollYDelta(int delta) {
        this.getVerticalBar().setSelection(-this.fVirtualBounds.y + delta);
        this.scrollY(this.getVerticalBar());
    }

    protected void scrollSmart(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            Rectangle rect = this.getBounds();
            this.scroll(deltaX, deltaY, 0, 0, rect.width, rect.height, false);
        }
    }

    protected void revealRect(Rectangle rect) {
        Rectangle visibleRect = this.getScreenRectInVirtualSpace();
        int deltaX = 0;
        if (rect.x < visibleRect.x) {
            deltaX = rect.x - visibleRect.x;
        } else if (visibleRect.x + visibleRect.width < rect.x + rect.width) {
            deltaX = rect.x + rect.width - (visibleRect.x + visibleRect.width);
        }
        if (deltaX != 0) {
            this.getHorizontalBar().setSelection(-this.fVirtualBounds.x + deltaX);
            this.scrollX(this.getHorizontalBar());
        }
        int deltaY = 0;
        if (rect.y < visibleRect.y) {
            deltaY = rect.y - visibleRect.y;
        } else if (visibleRect.y + visibleRect.height < rect.y + rect.height) {
            deltaY = rect.y + rect.height - (visibleRect.y + visibleRect.height);
        }
        if (deltaY != 0) {
            this.getVerticalBar().setSelection(-this.fVirtualBounds.y + deltaY);
            this.scrollY(this.getVerticalBar());
        }
    }

    protected void repaint(Rectangle r) {
        if (this.isDisposed()) {
            return;
        }
        if (this.inClipping(r, this.fClientArea)) {
            this.redraw(r.x, r.y, r.width, r.height, true);
            this.update();
        }
    }

    protected abstract void paint(GC var1);

    protected Color getTerminalBackgroundColor() {
        return this.getDisplay().getSystemColor(22);
    }

    protected void paintUnoccupiedSpace(GC gc, Rectangle clipping) {
        int width = this.fVirtualBounds.width + this.fVirtualBounds.x;
        int height = this.fVirtualBounds.height + this.fVirtualBounds.y;
        int marginWidth = clipping.x + clipping.width - width;
        int marginHeight = clipping.y + clipping.height - height;
        if (marginWidth > 0 || marginHeight > 0) {
            Color bg = this.getBackground();
            gc.setBackground(this.getTerminalBackgroundColor());
            if (marginWidth > 0) {
                gc.fillRectangle(width, clipping.y, marginWidth, clipping.height);
            }
            if (marginHeight > 0) {
                gc.fillRectangle(clipping.x, height, clipping.width, marginHeight);
            }
            gc.setBackground(bg);
        }
    }

    protected boolean inClipping(Rectangle clipping, Rectangle r) {
        if (r.x + r.width <= clipping.x) {
            return false;
        }
        if (clipping.x + clipping.width <= r.x) {
            return false;
        }
        if (r.y + r.height <= clipping.y) {
            return false;
        }
        return clipping.y + clipping.height > r.y;
    }

    protected Rectangle getScreenRectInVirtualSpace() {
        Rectangle r = new Rectangle(this.fClientArea.x - this.fVirtualBounds.x, this.fClientArea.y - this.fVirtualBounds.y, this.fClientArea.width, this.fClientArea.height);
        return r;
    }

    protected Rectangle getRectInVirtualSpace(Rectangle r) {
        return new Rectangle(r.x - this.fVirtualBounds.x, r.y - this.fVirtualBounds.y, r.width, r.height);
    }

    protected void setVirtualExtend(int width, int height) {
        this.fVirtualBounds.width = width;
        this.fVirtualBounds.height = height;
        this.updateScrollbars();
        this.updateViewRectangle();
    }

    protected void setVirtualOrigin(int x, int y) {
        if (this.fVirtualBounds.x != x || this.fVirtualBounds.y != y) {
            this.fVirtualBounds.x = x;
            this.fVirtualBounds.y = y;
            this.getHorizontalBar().setSelection(-x);
            this.getVerticalBar().setSelection(-y);
            this.updateViewRectangle();
        }
    }

    protected Rectangle getVirtualBounds() {
        return this.cloneRectangle(this.fVirtualBounds);
    }

    protected int virtualXtoScreen(int x) {
        return x + this.fVirtualBounds.x;
    }

    protected int virtualYtoScreen(int y) {
        return y + this.fVirtualBounds.y;
    }

    protected int screenXtoVirtual(int x) {
        return x - this.fVirtualBounds.x;
    }

    protected int screenYtoVirtual(int y) {
        return y - this.fVirtualBounds.y;
    }

    protected void updateViewRectangle() {
        if (this.fViewRectangle.x == -this.fVirtualBounds.x && this.fViewRectangle.y == -this.fVirtualBounds.y && this.fViewRectangle.width == this.fClientArea.width && this.fViewRectangle.height == this.fClientArea.height) {
            return;
        }
        this.fViewRectangle.x = -this.fVirtualBounds.x;
        this.fViewRectangle.y = -this.fVirtualBounds.y;
        this.fViewRectangle.width = this.fClientArea.width;
        this.fViewRectangle.height = this.fClientArea.height;
        this.viewRectangleChanged(this.fViewRectangle.x, this.fViewRectangle.y, this.fViewRectangle.width, this.fViewRectangle.height);
    }

    protected Rectangle getViewRectangle() {
        return this.cloneRectangle(this.fViewRectangle);
    }

    private Rectangle cloneRectangle(Rectangle r) {
        return new Rectangle(r.x, r.y, r.width, r.height);
    }

    protected void viewRectangleChanged(int x, int y, int width, int height) {
    }

    private void updateScrollbars() {
        if (!this.fInUpdateScrollbars) {
            this.fInUpdateScrollbars = true;
            try {
                this.doUpdateScrollbar();
            }
            finally {
                this.fInUpdateScrollbars = false;
            }
        } else if (!fInUpdateScrollbarsLogged) {
            fInUpdateScrollbarsLogged = true;
            TerminalPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.tm.terminal", 0, "Unexpected Recursion in terminal", (Throwable)new RuntimeException()));
        }
    }

    private void doUpdateScrollbar() {
        Rectangle clientArea = this.getClientArea();
        ScrollBar horizontal = this.getHorizontalBar();
        if (!this.isVisible() || horizontal.isVisible()) {
            horizontal.setPageIncrement(clientArea.width - horizontal.getIncrement());
            int max = this.fVirtualBounds.width;
            horizontal.setMaximum(max);
            horizontal.setThumb(clientArea.width);
        }
        ScrollBar vertical = this.getVerticalBar();
        if (!this.isVisible() || vertical.isVisible()) {
            vertical.setPageIncrement(clientArea.height - vertical.getIncrement());
            int max = this.fVirtualBounds.height;
            vertical.setMaximum(max);
            vertical.setThumb(clientArea.height);
        }
    }

    protected boolean isVertialBarVisible() {
        return this.getVerticalBar().isVisible();
    }

    protected void serVerticalBarVisible(boolean showVScrollBar) {
        ScrollBar vertical = this.getVerticalBar();
        vertical.setVisible(showVScrollBar);
        vertical.setSelection(0);
    }

    protected boolean isHorizontalBarVisble() {
        return this.getHorizontalBar().isVisible();
    }

    protected void setHorizontalBarVisible(boolean showHScrollBar) {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setVisible(showHScrollBar);
        horizontal.setSelection(0);
    }
}

