/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.connector.api.ui.config.telnet;

import org.soyatec.connector.api.telnet.ITelnetSettings;
import org.soyatec.connector.api.ui.config.telnet.TelnetProperties;

public class TelnetSetting
implements ITelnetSettings {
    protected String fHost;
    protected String fNetworkPort;
    protected String fTimeout;
    protected String fCommandPrompt;
    protected String fLoginPrompt;
    protected String fPasswordPrompt;
    protected String fLoginName;
    protected String fPassword;
    private final TelnetProperties fProperties = new TelnetProperties();

    public TelnetSetting() {
        this.fNetworkPort = this.fProperties.getDefaultNetworkPort();
    }

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String strHost) {
        this.fHost = strHost;
    }

    public String getNetworkPortString() {
        return this.fNetworkPort;
    }

    public int getNetworkPort() {
        try {
            return Integer.parseInt(this.fNetworkPort);
        }
        catch (NumberFormatException numberFormatException) {
            return 1313;
        }
    }

    public void setNetworkPort(String strNetworkPort) {
        this.fNetworkPort = strNetworkPort;
    }

    public String getSummary() {
        return String.valueOf(this.getHost()) + ":" + this.getNetworkPortString() + ":" + this.getTimeoutString() + ":" + this.getCommandPrompt() + ":" + this.getLoginPrompt() + ":" + this.getPasswordPrompt() + ":" + this.getLoginName() + ":" + this.getPassword();
    }

    public TelnetProperties getProperties() {
        return this.fProperties;
    }

    public int getTimeout() {
        try {
            return Integer.parseInt(this.fTimeout);
        }
        catch (NumberFormatException numberFormatException) {
            return 10;
        }
    }

    public String getTimeoutString() {
        return this.fTimeout;
    }

    public void setTimeout(String timeout) {
        this.fTimeout = timeout;
    }

    public String getStatusString(String strConnected) {
        return null;
    }

    public String getCommandPrompt() {
        return this.fCommandPrompt;
    }

    public void setCommandPrompt(String commandPrompt) {
        this.fCommandPrompt = commandPrompt;
    }

    public String getLoginPrompt() {
        return this.fLoginPrompt;
    }

    public void setLoginPrompt(String loginPrompt) {
        this.fLoginPrompt = loginPrompt;
    }

    public String getPasswordPrompt() {
        return this.fPasswordPrompt;
    }

    public void setPasswordPrompt(String passwordPrompt) {
        this.fPasswordPrompt = passwordPrompt;
    }

    public String getLoginName() {
        return this.fLoginName;
    }

    public void setLoginName(String loginName) {
        this.fLoginName = loginName;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public void update(ITelnetSettings telnetSetting) {
        this.fNetworkPort = String.valueOf(telnetSetting.getNetworkPort());
        this.fTimeout = String.valueOf(telnetSetting.getTimeout());
        this.fHost = telnetSetting.getHost();
        this.fCommandPrompt = telnetSetting.getCommandPrompt();
        this.fLoginPrompt = telnetSetting.getLoginPrompt();
        this.fPasswordPrompt = telnetSetting.getPasswordPrompt();
        this.fLoginName = telnetSetting.getLoginName();
        this.fPassword = telnetSetting.getPassword();
    }
}

