/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ObjectInputStream;
import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

@FunctionalInterface
public interface ObjectInputFilter {
    public Status checkInput(FilterInfo var1);

    public static final class Config {
        private static final Object serialFilterLock = new Object();
        private static final PlatformLogger configLog;
        private static final String SERIAL_FILTER_PROPNAME = "jdk.serialFilter";
        private static final ObjectInputFilter configuredFilter;
        private static ObjectInputFilter serialFilter;

        private Config() {
        }

        static void filterLog(PlatformLogger.Level level, String string, Object ... objectArray) {
            if (configLog != null) {
                if (PlatformLogger.Level.INFO.equals((Object)level)) {
                    configLog.info(string, objectArray);
                } else if (PlatformLogger.Level.WARNING.equals((Object)level)) {
                    configLog.warning(string, objectArray);
                } else {
                    configLog.severe(string, objectArray);
                }
            }
        }

        public static ObjectInputFilter getObjectInputFilter(ObjectInputStream objectInputStream) {
            Objects.requireNonNull(objectInputStream, "inputStream");
            return SharedSecrets.getJavaOISAccess().getObjectInputFilter(objectInputStream);
        }

        public static void setObjectInputFilter(ObjectInputStream objectInputStream, ObjectInputFilter objectInputFilter) {
            Objects.requireNonNull(objectInputStream, "inputStream");
            SharedSecrets.getJavaOISAccess().setObjectInputFilter(objectInputStream, objectInputFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectInputFilter getSerialFilter() {
            Object object = serialFilterLock;
            synchronized (object) {
                return serialFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setSerialFilter(ObjectInputFilter objectInputFilter) {
            Objects.requireNonNull(objectInputFilter, "filter");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new SerializablePermission("serialFilter"));
            }
            Object object = serialFilterLock;
            synchronized (object) {
                if (serialFilter != null) {
                    throw new IllegalStateException("Serial filter can only be set once");
                }
                serialFilter = objectInputFilter;
            }
        }

        public static ObjectInputFilter createFilter(String string) {
            Objects.requireNonNull(string, "pattern");
            return Global.createFilter(string, true);
        }

        public static ObjectInputFilter createFilter2(String string) {
            Objects.requireNonNull(string, "pattern");
            return Global.createFilter(string, false);
        }

        static {
            configuredFilter = AccessController.doPrivileged(() -> {
                String string = System.getProperty(SERIAL_FILTER_PROPNAME);
                if (string == null) {
                    string = Security.getProperty(SERIAL_FILTER_PROPNAME);
                }
                if (string != null) {
                    PlatformLogger platformLogger = PlatformLogger.getLogger("java.io.serialization");
                    platformLogger.info("Creating serialization filter from {0}", string);
                    try {
                        return Config.createFilter(string);
                    }
                    catch (RuntimeException runtimeException) {
                        platformLogger.warning("Error configuring filter: {0}", runtimeException);
                    }
                }
                return null;
            });
            configLog = configuredFilter != null ? PlatformLogger.getLogger("java.io.serialization") : null;
            serialFilter = configuredFilter;
        }

        static final class Global
        implements ObjectInputFilter {
            private final String pattern;
            private final List<Function<Class<?>, Status>> filters;
            private long maxStreamBytes;
            private long maxDepth;
            private long maxReferences;
            private long maxArrayLength;
            private final boolean checkComponentType;

            static ObjectInputFilter createFilter(String string, boolean bl) {
                Global global = new Global(string, bl);
                return global.isEmpty() ? null : global;
            }

            private Global(String string, boolean bl) {
                this.pattern = string;
                this.checkComponentType = bl;
                this.maxArrayLength = Long.MAX_VALUE;
                this.maxDepth = Long.MAX_VALUE;
                this.maxReferences = Long.MAX_VALUE;
                this.maxStreamBytes = Long.MAX_VALUE;
                String[] stringArray = string.split(";");
                this.filters = new ArrayList(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    boolean bl2;
                    String string3 = stringArray[i];
                    int n = string3.length();
                    if (n == 0 || this.parseLimit(string3)) continue;
                    boolean bl3 = bl2 = string3.charAt(0) == '!';
                    if (string3.indexOf(47) >= 0) {
                        throw new IllegalArgumentException("invalid character \"/\" in: \"" + string + "\"");
                    }
                    if (string3.endsWith("*")) {
                        if (string3.endsWith(".*")) {
                            string2 = string3.substring(bl2 ? 1 : 0, n - 1);
                            if (string2.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + string + "\"");
                            }
                            if (bl2) {
                                this.filters.add(clazz -> Global.matchesPackage(clazz, string2) ? Status.REJECTED : Status.UNDECIDED);
                                continue;
                            }
                            this.filters.add(clazz -> Global.matchesPackage(clazz, string2) ? Status.ALLOWED : Status.UNDECIDED);
                            continue;
                        }
                        if (string3.endsWith(".**")) {
                            string2 = string3.substring(bl2 ? 1 : 0, n - 2);
                            if (string2.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + string + "\"");
                            }
                            if (bl2) {
                                this.filters.add(clazz -> clazz.getName().startsWith(string2) ? Status.REJECTED : Status.UNDECIDED);
                                continue;
                            }
                            this.filters.add(clazz -> clazz.getName().startsWith(string2) ? Status.ALLOWED : Status.UNDECIDED);
                            continue;
                        }
                        string2 = string3.substring(bl2 ? 1 : 0, n - 1);
                        if (bl2) {
                            this.filters.add(clazz -> clazz.getName().startsWith(string2) ? Status.REJECTED : Status.UNDECIDED);
                            continue;
                        }
                        this.filters.add(clazz -> clazz.getName().startsWith(string2) ? Status.ALLOWED : Status.UNDECIDED);
                        continue;
                    }
                    string2 = string3.substring(bl2 ? 1 : 0);
                    if (string2.isEmpty()) {
                        throw new IllegalArgumentException("class or package missing in: \"" + string + "\"");
                    }
                    if (bl2) {
                        this.filters.add(clazz -> clazz.getName().equals(string2) ? Status.REJECTED : Status.UNDECIDED);
                        continue;
                    }
                    this.filters.add(clazz -> clazz.getName().equals(string2) ? Status.ALLOWED : Status.UNDECIDED);
                }
            }

            private boolean isEmpty() {
                return this.filters.isEmpty() && this.maxArrayLength == Long.MAX_VALUE && this.maxDepth == Long.MAX_VALUE && this.maxReferences == Long.MAX_VALUE && this.maxStreamBytes == Long.MAX_VALUE;
            }

            private boolean parseLimit(String string) {
                int n = string.indexOf(61);
                if (n < 0) {
                    return false;
                }
                String string2 = string.substring(n + 1);
                if (string.startsWith("maxdepth=")) {
                    this.maxDepth = Global.parseValue(string2);
                } else if (string.startsWith("maxarray=")) {
                    this.maxArrayLength = Global.parseValue(string2);
                } else if (string.startsWith("maxrefs=")) {
                    this.maxReferences = Global.parseValue(string2);
                } else if (string.startsWith("maxbytes=")) {
                    this.maxStreamBytes = Global.parseValue(string2);
                } else {
                    throw new IllegalArgumentException("unknown limit: " + string.substring(0, n));
                }
                return true;
            }

            private static long parseValue(String string) throws IllegalArgumentException {
                long l = Long.parseLong(string);
                if (l < 0L) {
                    throw new IllegalArgumentException("negative limit: " + string);
                }
                return l;
            }

            @Override
            public Status checkInput(FilterInfo filterInfo) {
                if (filterInfo.references() < 0L || filterInfo.depth() < 0L || filterInfo.streamBytes() < 0L || filterInfo.references() > this.maxReferences || filterInfo.depth() > this.maxDepth || filterInfo.streamBytes() > this.maxStreamBytes) {
                    return Status.REJECTED;
                }
                Class<?> clazz = filterInfo.serialClass();
                if (clazz != null) {
                    if (clazz.isArray()) {
                        if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > this.maxArrayLength) {
                            return Status.REJECTED;
                        }
                        if (!this.checkComponentType) {
                            return Status.UNDECIDED;
                        }
                        while ((clazz = clazz.getComponentType()).isArray()) {
                        }
                    }
                    if (clazz.isPrimitive()) {
                        return Status.UNDECIDED;
                    }
                    Class<?> clazz2 = clazz;
                    Optional<Status> optional = this.filters.stream().map(function -> (Status)((Object)((Object)function.apply(clazz2)))).filter(status -> status != Status.UNDECIDED).findFirst();
                    return optional.orElse(Status.UNDECIDED);
                }
                return Status.UNDECIDED;
            }

            private static boolean matchesPackage(Class<?> clazz, String string) {
                String string2 = clazz.getName();
                return string2.startsWith(string) && string2.lastIndexOf(46) == string.length() - 1;
            }

            public String toString() {
                return this.pattern;
            }
        }
    }

    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }

    public static interface FilterInfo {
        public Class<?> serialClass();

        public long arrayLength();

        public long depth();

        public long references();

        public long streamBytes();
    }
}

