/*
 * Decompiled with CFR 0.152.
 */
package org.soyatec.tftp.hitool;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.soyatec.tftp.hitool.TFTPTransfer;

public class TFTPService
implements Runnable {
    private Logger logger = LogManager.getLogger(TFTPService.class);
    public static final TFTPService TFTPSERVICE = new TFTPService();
    public static final String DEFAULT_TFTP_PORT_CMD = "cmd.exe /c netstat -aon|findstr :";
    public static final String DEFAULT_TFTP_PORT_LINUX_CMD = "bin/sh -c -tunlp|grep :";
    public static final String[] DEFAULT_TFTP_PORT_LINUX_CMD_LIST = new String[]{"/bin/sh", "-c", "-tunlp|grep :"};
    public static final String PORT_LINUX_CMD = "-tunlp|grep :";
    public static final String DEFAULT_TFTP_STRING_PORT = ":69";
    private HashSet<TFTPTransfer> transfers = new HashSet();
    private volatile boolean shutdownServer = false;
    private TFTP serverTftp = new TFTP();
    private static int winSizeBlockCount = 1;
    private static int settingRetransmit = 5;
    private static boolean winSizeOpen = false;
    private static boolean settingIgnoreBlockAck = true;
    private static boolean isUsb2EtherNet = false;
    private File serverDirectory;
    private boolean start = false;
    private int maxTimeoutRetries = 3;
    private int socketTimeout;
    private Thread serverThread;

    public static boolean isUsb2EtherNet() {
        return isUsb2EtherNet;
    }

    public static void setUsb2EtherNet(boolean isUsb2EtherNet) {
        TFTPService.isUsb2EtherNet = isUsb2EtherNet;
    }

    public File getServerDirectory() {
        return this.serverDirectory;
    }

    public static int getWinSizeBlockCount() {
        return winSizeBlockCount;
    }

    public static void setWinSizeBlockCount(int winSizeBlockCount) {
        TFTPService.winSizeBlockCount = winSizeBlockCount;
    }

    public static int getSettingRetransmit() {
        return settingRetransmit;
    }

    public static void setSettingRetransmit(int settingRetransmit) {
        TFTPService.settingRetransmit = settingRetransmit;
    }

    public static boolean isWinSizeOpen() {
        return winSizeOpen;
    }

    public static void setWinSizeOpen(boolean winSizeOpen) {
        TFTPService.winSizeOpen = winSizeOpen;
    }

    public static boolean isSettingIgnoreBlockAck() {
        return settingIgnoreBlockAck;
    }

    public static void setSettingIgnoreBlockAck(boolean settingIgnoreBlockAck) {
        TFTPService.settingIgnoreBlockAck = settingIgnoreBlockAck;
    }

    public void setServerDirectory(File serverDirectory) {
        this.serverDirectory = serverDirectory;
    }

    public boolean isStart() {
        return this.start;
    }

    public boolean start(File serverDirectory, InetAddress ipAddress, int port) throws SocketException {
        this.serverDirectory = serverDirectory;
        this.socketTimeout = this.serverTftp.getDefaultTimeout();
        this.serverTftp.setDefaultTimeout(0);
        try {
            this.serverTftp.open(port, ipAddress);
        }
        catch (SocketException e) {
            e.printStackTrace();
            return false;
        }
        this.logger.info("Tftp Server open suceess.");
        this.serverThread = new Thread((Runnable)this, "Tftp Server");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
        this.start = true;
        return true;
    }

    public boolean start(File serverDirectory, InetAddress ipAddress, String cmd, int port) throws SocketException {
        this.logger.info("serverDirectory:" + serverDirectory);
        this.logger.info("ipAddress:" + ipAddress);
        this.logger.info("ipAddress:" + cmd);
        if (cmd.equals(DEFAULT_TFTP_PORT_CMD)) {
            if (this.isPortUsing(DEFAULT_TFTP_PORT_CMD + port, port)) {
                return false;
            }
        } else {
            TFTPService.DEFAULT_TFTP_PORT_LINUX_CMD_LIST[2] = PORT_LINUX_CMD + String.valueOf(port);
            if (this.isPortUsing(DEFAULT_TFTP_PORT_LINUX_CMD_LIST, port)) {
                return false;
            }
        }
        return this.start(serverDirectory, ipAddress, port);
    }

    public boolean isPortUsing(String[] cmdList, int port) {
        BufferedReader br = null;
        Process process = null;
        try {
            String[] resultList;
            process = Runtime.getRuntime().exec(cmdList);
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String readLine = br.readLine();
            if (readLine == null) {
                return false;
            }
            String[] stringArray = resultList = readLine.split(" ");
            int n = resultList.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (str != null && str.trim().endsWith(String.valueOf(port))) {
                    this.logger.info("port :" + str);
                    return true;
                }
                try {
                    ++n2;
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (process != null) {
                process.destroy();
                process = null;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPortUsing(String cmd, int port) {
        BufferedReader br = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            block15: while (true) {
                String[] resultList;
                String readLine;
                if ((readLine = br.readLine()) == null) {
                    return false;
                }
                String[] stringArray = resultList = readLine.split(" ");
                int n = resultList.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) continue block15;
                    String str = stringArray[n2];
                    if (str != null && str.trim().endsWith(String.valueOf(port))) {
                        this.logger.info("port :" + str);
                        System.out.println("port :str");
                        return true;
                    }
                    ++n2;
                    continue;
                    break;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (process != null) {
                process.destroy();
                process = null;
            }
        }
    }

    public void stop() {
        this.shutdown();
        this.start = false;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                while (true) {
                    if (this.shutdownServer) {
                        return;
                    }
                    try {
                        this.logger.info("get package for a single board request");
                        TFTPPacket tftpPacket = this.serverTftp.receive();
                        TFTPTransfer tt = new TFTPTransfer(tftpPacket, this.socketTimeout, this.maxTimeoutRetries, this.serverDirectory, this.transfers);
                        this.logger.info("TFTPTransfer run");
                        this.logger.info("socketTimeout: " + this.socketTimeout);
                        this.logger.info("MaxTimeoutRetries: " + this.maxTimeoutRetries);
                        this.logger.info("ServerDirectory: " + this.serverDirectory);
                        HashSet<TFTPTransfer> hashSet = this.transfers;
                        synchronized (hashSet) {
                            this.transfers.add(tt);
                        }
                        Thread thread = new Thread(tt);
                        thread.setDaemon(true);
                        thread.start();
                        this.logger.info("TFTPTransfer Thread start.");
                    }
                    catch (IOException e) {
                        if (this.shutdownServer) continue;
                        this.logger.error("Unexpected Error in TFTP Server - Server shut down! + " + e.getMessage());
                    }
                }
            }
            catch (TFTPPacketException e) {
                if (!this.shutdownServer) {
                    this.logger.error("Unexpected Error in TFTP Server - Server shut down! + " + (Object)((Object)e));
                }
                this.shutdownServer = true;
                if (this.serverTftp != null && this.serverTftp.isOpen()) {
                    this.serverTftp.close();
                }
                this.logger.info("serverTftp: close.");
                return;
            }
        }
        finally {
            this.shutdownServer = true;
            if (this.serverTftp != null && this.serverTftp.isOpen()) {
                this.serverTftp.close();
            }
            this.logger.info("serverTftp: close.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownServer = true;
        HashSet<TFTPTransfer> hashSet = this.transfers;
        synchronized (hashSet) {
            Iterator<TFTPTransfer> it = this.transfers.iterator();
            while (it.hasNext()) {
                it.next().shutdown();
            }
        }
        try {
            this.serverTftp.close();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        try {
            if (this.serverThread != null) {
                this.serverThread.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.shutdownServer = false;
        this.logger.info("tftp server stop.");
    }

    public static enum ServerMode {
        GET_ONLY,
        PUT_ONLY,
        GET_AND_PUT;

    }
}

