/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.log;

import com.soyatec.hisilicon.platform.osgi.internal.PluginToolManager;
import com.soyatec.hisilicon.platform.osgi.internal.log.EclipseLogListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;

public class HiLogFormatter
extends Formatter {
    private EclipseLogListener eclipseLogListener;

    public HiLogFormatter(EclipseLogListener eclipseLogListener) {
        this.eclipseLogListener = eclipseLogListener;
    }

    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        sb.append(date.getYear() + 1900);
        sb.append('-');
        this.a2(sb, date.getMonth() + 1);
        sb.append('-');
        this.a2(sb, date.getDate());
        sb.append('T');
        this.a2(sb, date.getHours());
        sb.append(':');
        this.a2(sb, date.getMinutes());
        sb.append(':');
        this.a2(sb, date.getSeconds());
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else {
                sb.append(ch);
            }
            ++i;
        }
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<record");
        LogEntry logEntry = this.eclipseLogListener.getLogEntry();
        if (logEntry != null) {
            PluginToolManager pluginToolManager = PluginToolManager.getInstance();
            Bundle bundle = logEntry.getBundle();
            if (bundle != null) {
                String symbolicName = bundle.getSymbolicName();
                String toolName = pluginToolManager.getToolNameByBundleID(symbolicName);
                sb.append(" tool-symbolicName=\"" + symbolicName + "\"");
                sb.append(" tool-name=\"" + toolName + "\"");
            }
        }
        sb.append(" level=\"");
        if (logEntry != null) {
            Throwable exception = logEntry.getException();
            if (exception != null) {
                if (exception instanceof Error) {
                    sb.append("FATAL");
                } else {
                    sb.append("ERROR");
                }
            } else {
                this.escape(sb, record.getLevel().toString());
            }
        }
        sb.append("\"");
        sb.append(" millis=\"" + record.getMillis() + "\"");
        sb.append(">");
        sb.append("\n");
        sb.append("  <date>");
        this.appendISO8601(sb, record.getMillis());
        sb.append("</date>\n");
        sb.append("  <message>");
        if (record.getMessage() != null) {
            String message = this.formatMessage(record);
            this.escape(sb, message);
        } else {
            this.escape(sb, "No message");
        }
        sb.append("</message>");
        sb.append("\n");
        if (record.getThrown() != null) {
            sb.append("  <exception>");
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                this.escape(sb, sw.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            sb.append("  </exception>\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }

    @Override
    public String getHead(Handler h) {
        return "";
    }

    @Override
    public String getTail(Handler h) {
        return "";
    }
}

