/*
 * Decompiled with CFR 0.152.
 */
package com.soyatec.hisilicon.platform.osgi.internal.log;

import com.soyatec.hisilicon.platform.osgi.internal.PluginToolManager;
import com.soyatec.hisilicon.platform.osgi.internal.log.HiLogFormatter;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.equinox.log.internal.ExtendedLogEntryImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class EclipseLogListener
implements LogListener {
    static Logger logger = Logger.getLogger(EclipseLogListener.class.getName());
    private static LogEntry logEntry = null;
    private static String filteroutLogPattern = "BundleEvent.*|Access is denied|ServiceEvent.*";
    private static Pattern pattern = Pattern.compile(filteroutLogPattern, 2);
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EclipseLogListener(File logDirectory) {
        try {
            FileHandler fileHandler = new FileHandler(String.valueOf(logDirectory.getAbsolutePath()) + File.separator + "soyatec_%u.log", 0xA00000, 100, true);
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new HiLogFormatter(this));
            Object object = lock;
            synchronized (object) {
                logger.addHandler(fileHandler);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logged(LogEntry osgiLogEntry) {
        Object object = lock;
        synchronized (object) {
            if (!PluginToolManager.getInstance().isPlatformContainsBundle(osgiLogEntry.getBundle()) && !PluginToolManager.getInstance().isTool(osgiLogEntry.getBundle())) {
                return;
            }
            if (EclipseLogListener.isFilteroutLog(osgiLogEntry.getMessage())) {
                return;
            }
            logEntry = osgiLogEntry;
            Level javaUtilLogLevel = Level.INFO;
            switch (osgiLogEntry.getLevel()) {
                case 1: {
                    javaUtilLogLevel = Level.SEVERE;
                    break;
                }
                case 2: {
                    javaUtilLogLevel = Level.WARNING;
                    break;
                }
                case 3: {
                    javaUtilLogLevel = Level.INFO;
                    break;
                }
                case 4: {
                    javaUtilLogLevel = Level.INFO;
                    break;
                }
            }
            if (osgiLogEntry.getException() != null) {
                logger.log(javaUtilLogLevel, osgiLogEntry.getMessage(), osgiLogEntry.getException());
            } else {
                logger.log(javaUtilLogLevel, osgiLogEntry.getMessage());
            }
            logEntry = null;
        }
    }

    public void stop() {
    }

    private String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        Throwable root = this.getRoot(t);
        if (root != null) {
            pw.println("Root exception:");
            root.printStackTrace(pw);
        }
        return sw.toString();
    }

    private Throwable getRoot(Throwable t) {
        Throwable deeplyNested;
        Throwable root = null;
        if (t instanceof BundleException) {
            root = ((BundleException)t).getNestedException();
        }
        if (t instanceof InvocationTargetException) {
            root = ((InvocationTargetException)t).getTargetException();
        }
        if ((root instanceof InvocationTargetException || root instanceof BundleException) && (deeplyNested = this.getRoot(root)) != null) {
            root = deeplyNested;
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogEntry getLogEntry() {
        Object object = lock;
        synchronized (object) {
            return logEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logPlatformError(String message, Exception e) {
        Bundle platformBundle = PluginToolManager.getInstance().getPlatformBundle();
        if (platformBundle != null && !EclipseLogListener.isFilteroutLog(message)) {
            Object object = lock;
            synchronized (object) {
                logEntry = new ExtendedLogEntryImpl(platformBundle, null, null, 1, message, (Throwable)e);
                logger.log(Level.SEVERE, message, e);
                logEntry = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logPlatformInfo(String message) {
        if (message == null) {
            return;
        }
        Bundle platformBundle = PluginToolManager.getInstance().getPlatformBundle();
        if (platformBundle != null && !EclipseLogListener.isFilteroutLog(message)) {
            Object object = lock;
            synchronized (object) {
                logEntry = new ExtendedLogEntryImpl(platformBundle, null, null, 1, message, null);
                logger.log(Level.INFO, message);
                logEntry = null;
            }
        }
    }

    private static synchronized boolean isFilteroutLog(String log) {
        Matcher matcher;
        if (log == null) {
            return true;
        }
        if (pattern == null) {
            pattern = Pattern.compile(filteroutLogPattern, 2);
        }
        return (matcher = pattern.matcher(log)).matches();
    }
}

