/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.views;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.model.BoardConfig;
import com.hisilicon.fastboot.model.BurnContext;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.LocalConfig;
import com.hisilicon.fastboot.model.PartitionInfo;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.cmdline.CmdLineParam;
import com.hisilicon.fastboot.model.cmdline.CmdType;
import com.hisilicon.fastboot.model.cmdline.adapter.BootBurn;
import com.hisilicon.fastboot.model.cmdline.adapter.EmmcImg;
import com.hisilicon.fastboot.model.cmdline.adapter.NandImg;
import com.hisilicon.fastboot.model.config.BurnConfig;
import com.hisilicon.fastboot.model.config.PreferenceConfig;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.burners.CommonBurner;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.devices.burners.FastbootBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.model.monitor.CmdMonitor;
import com.hisilicon.fastboot.packagers.nand.FlashOption;
import com.hisilicon.fastboot.packagers.nand.ip.NandIPCommon;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.utilitily.LibUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.DocumentException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.soyatec.connector.api.serial.SerialHelper;

public class CmdMain {
    private static final String VERSION = "5.2.10";
    private static final int EXTRA_START = 1;
    private static final int EXTRA_COUNT = 2;
    private static CmdType curCmdType = null;
    private static String chipName = null;
    private IFastbootProgressMonitor progressMonitor;

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            CmdMain.help();
            return;
        }
        HiToolUtils.setCmdLine(true);
        CmdLineParam cmdLineParam = new CmdLineParam();
        CmdMain cmdMain = new CmdMain();
        if (!CmdMain.parseExtraParam(args, cmdLineParam)) {
            CmdMain.help();
            return;
        }
        if (!CmdMain.parseFirstParam(args, cmdLineParam, cmdMain)) {
            CmdMain.help();
            return;
        }
        System.exit(0);
    }

    public static CmdType getCurCmdType() {
        return curCmdType;
    }

    public static void setCurCmdType(CmdType curCmdType) {
        CmdMain.curCmdType = curCmdType;
    }

    public static String getChipName() {
        return chipName;
    }

    public static void setChipName(String chipName) {
        CmdMain.chipName = chipName;
    }

    private static boolean parseExtraParam(String[] args, CmdLineParam cmdLineParam) {
        boolean result;
        boolean bl = result = args[0] == null || !args[0].equalsIgnoreCase("--burn") && !args[0].equalsIgnoreCase("-b");
        if (result) {
            return true;
        }
        int extraParam = (args.length - 1) / 2;
        if (extraParam >= 1) {
            int index = 1;
            while (index <= extraParam) {
                block12: {
                    File file;
                    String argsName = args[index];
                    String argsValue = args[index + 1];
                    if (argsName == null || argsValue == null) {
                        Log.errorln(Messages.MESSAGE_UNEXPECTED_NULL);
                        return false;
                    }
                    if (cmdLineParam == null) {
                        Log.errorln(Messages.MESSAGE_EXTRA_PARAMETER_EMPTY);
                        return false;
                    }
                    if (argsName.equalsIgnoreCase("-x")) {
                        file = new File(argsValue);
                        if (!file.exists() || !file.isFile()) {
                            Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)argsValue));
                            return false;
                        }
                        cmdLineParam.setXmlPath(argsValue);
                        try {
                            PartitionInfo PartitionInfo2 = PartitionItem.load(file, true);
                            List<PartitionItem> partitionLists = PartitionInfo2.getChildren();
                            if (partitionLists != null && partitionLists.size() > 0) {
                                cmdLineParam.setPartitionList(partitionLists);
                                break block12;
                            }
                            Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)file.getAbsolutePath()));
                            return false;
                        }
                        catch (DocumentException e) {
                            Log.errorln(Messages.UanbleParseXml);
                            e.printStackTrace();
                            return false;
                        }
                    }
                    if (argsName.equalsIgnoreCase("-p")) {
                        file = new File(argsValue);
                        if (!file.exists() || !file.isFile()) {
                            Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)argsValue));
                            return false;
                        }
                        cmdLineParam.setProgrammerPath(argsValue);
                    }
                }
                index += 2;
            }
        }
        return true;
    }

    private static boolean parseFirstParam(String[] args, CmdLineParam cmdLineParam, CmdMain cmdMain) {
        boolean check;
        boolean bl = check = args == null || args.length == 0;
        if (check) {
            return false;
        }
        String cmdType = args[0];
        if (cmdType == null) {
            return false;
        }
        if (cmdMain.checkCmdType(cmdType, "--help", "-h")) {
            CmdMain.setCurCmdType(CmdType.help);
            CmdMain.help();
        } else if (cmdMain.checkCmdType(cmdType, "--version", "-v")) {
            CmdMain.setCurCmdType(CmdType.version);
            CmdMain.printVersion();
        } else if (cmdMain.checkCmdType(cmdType, "--burn", "-b")) {
            CmdMain.burn(cmdLineParam, cmdMain);
        } else if (cmdMain.checkCmdType(cmdType, "--burnboot", "-bb")) {
            CmdMain.burnBoot(args, cmdMain);
        } else if (cmdMain.checkCmdType(cmdType, "--nandimg", "-n")) {
            CmdMain.makeNandImage(args, cmdMain);
        } else if (cmdMain.checkCmdType(cmdType, "--emmcimg", "-e")) {
            CmdMain.makeEmmcImage(args, cmdMain);
        } else {
            return false;
        }
        return true;
    }

    private boolean checkCmdType(String cmdType, String fullCmdName, String shortCmdName) {
        return cmdType.equalsIgnoreCase(fullCmdName) || cmdType.equalsIgnoreCase(shortCmdName);
    }

    private static void makeNandImage(String[] args, CmdMain cmdMain) {
        CmdMain.setCurCmdType(CmdType.nandimg);
        NandImg nandImg = new NandImg(args);
        boolean parseResult = nandImg.parseAllParameter();
        if (!parseResult) {
            return;
        }
        CmdMain.setChipName(nandImg.getChipName());
        NandIPCommon nandIp = nandImg.getNandIp();
        String inputFile = nandImg.getInputFile();
        boolean isFastboot = nandImg.isFastboot();
        FlashOption flashOption = nandImg.getFlashOption();
        FileSystem fileSystem = nandImg.getFileSystem();
        boolean isSelectRandom = nandImg.isRandomizer();
        int blockSize = nandImg.getBlock();
        PartitionItem item = new PartitionItem();
        item.setChecked(true);
        item.setFlashType(FlashType.nand);
        item.setFileSystem(fileSystem);
        item.setFile(new File(inputFile));
        if (isFastboot) {
            item.setStart(0L);
        } else {
            item.setStart(1L);
        }
        PreferenceConfig preferenceConfig = new PreferenceConfig();
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return;
        }
        ArrayList<PartitionItem> partitions = new ArrayList<PartitionItem>();
        partitions.add(item);
        CmdMonitor cmdMonitor = new CmdMonitor();
        IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
        String outputDir = new File(inputFile).getParent();
        try {
            nandIp.make(outputDir, flashOption, partitions, blockSize, isSelectRandom, monitor, cmdMonitor);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.errorln("Throws ArrayIndexOutOfBoundsException exception.");
            return;
        }
    }

    private static void burn(CmdLineParam cmdLineParam, CmdMain cmdMain) {
        CmdMain.setCurCmdType(CmdType.burn);
        if (!LibUtils.loadRxtxSerialDLL()) {
            Log.errorln(Messages.CMD_FAILED_LOAD_RXTX);
            return;
        }
        BurnContext burnContext = CmdMain.loadBurnConfig(cmdLineParam.getXmlPath());
        if (burnContext == null) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"burn.config"));
            return;
        }
        PreferenceConfig preferenceConfig = new PreferenceConfig();
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return;
        }
        CmdMain.setChipName(BurnConfig.getChipName());
        List<PartitionItem> partitionList = CmdMain.getPartitionList(cmdLineParam);
        if (partitionList == null) {
            return;
        }
        String programmerPath = cmdLineParam.getProgrammerPath();
        File programmerFile = null;
        if (programmerPath != null) {
            programmerFile = new File(programmerPath);
        }
        cmdMain.burnByXML(partitionList, burnContext, programmerFile, ToolType.Cmdline);
    }

    private static List<PartitionItem> getPartitionList(CmdLineParam cmdLineParam) {
        List<PartitionItem> partitionList = null;
        String xmlPath = cmdLineParam.getXmlPath();
        if (xmlPath != null) {
            BurnConfig.setXmlPath(cmdLineParam.getXmlPath());
            partitionList = cmdLineParam.getPartitionList();
            if (partitionList == null) {
                Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)xmlPath));
                return null;
            }
        } else {
            String loadXmlPath = BurnConfig.getXmlPath();
            partitionList = CmdMain.loadPartitionList(cmdLineParam, loadXmlPath);
            if (partitionList == null) {
                return null;
            }
        }
        return partitionList;
    }

    private static void burnBoot(String[] args, CmdMain cmdMain) {
        CmdMain.setCurCmdType(CmdType.burnboot);
        int paramSize = args.length - 1;
        if (!LibUtils.loadRxtxSerialDLL()) {
            Log.errorln(Messages.CMD_FAILED_LOAD_RXTX);
            return;
        }
        BootBurn bootBurn = new BootBurn();
        List listSerialPorts = SerialHelper.listSerialPorts();
        bootBurn.setSerialPorts(listSerialPorts);
        boolean parseResult = bootBurn.parseAllParameter(args, paramSize);
        if (!parseResult) {
            return;
        }
        CmdMain.setChipName(bootBurn.getChipName());
        PreferenceConfig preferenceConfig = new PreferenceConfig();
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return;
        }
        BurnContext burnContext = CmdMain.loadBurnConfig(null);
        LocalConfig localConfig = burnContext.getLocalConfig();
        String comPort = bootBurn.getPort();
        TransferWay mode = bootBurn.getMode();
        localConfig.setComPort(comPort);
        burnContext.setTransferWay(mode);
        burnContext.setJtagFrequency(BurnConfig.getBoardConfig().getFrequency());
        FlashType flashType = bootBurn.getFlashType();
        File bootFile = bootBurn.getBootFile();
        File programmer = bootBurn.getProgrammer();
        FastbootBurner fastbootBurner = new FastbootBurner(burnContext, ToolType.Cmdline);
        if (programmer != null) {
            fastbootBurner.setProgrammerFile(programmer.getAbsolutePath());
        }
        if (bootFile != null) {
            fastbootBurner.setFile(bootFile.getAbsolutePath());
        }
        if (flashType != null) {
            fastbootBurner.setFlashType(flashType);
        }
        if (!CmdMain.checkStatus(fastbootBurner.checkBeforeBurn())) {
            return;
        }
        IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
        monitor.getEvent().setBurner(fastbootBurner);
        fastbootBurner.burn(monitor);
    }

    private static void makeEmmcImage(String[] args, CmdMain cmdMain) {
        CmdMain.setCurCmdType(CmdType.emmcimg);
        int paramSize = args.length - 1;
        EmmcImg emmcImg = new EmmcImg();
        boolean parseResult = emmcImg.parseAllParameter(args, paramSize);
        if (!parseResult) {
            return;
        }
        CmdMain.setChipName(CmdMain.getChipName());
        PreferenceConfig preferenceConfig = new PreferenceConfig();
        if (!preferenceConfig.isLoadResult()) {
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)"preference.config"));
            return;
        }
        List<PartitionItem> partitionList = emmcImg.getPartitionList();
        UnknownDevice device = emmcImg.getDevice();
        String outputPath = emmcImg.getOutputPath();
        if (device != null) {
            BurnContext burnContext = device.getBurnContext();
            EmmcBurner emmcBurner = new EmmcBurner(burnContext, ToolType.Cmdline);
            emmcBurner.setChildren(partitionList);
            if (emmcBurner.checkCreateImage() == null) {
                IFastbootProgressMonitor monitor = cmdMain.getProgressMonitor();
                monitor.getEvent().setBurner(emmcBurner);
                emmcBurner.setEmmcImgOutPath(outputPath);
                emmcBurner.createImage(monitor);
            } else {
                return;
            }
        }
    }

    private static List<PartitionItem> loadPartitionList(CmdLineParam cmdLineParam, String xmlPath) {
        List<PartitionItem> partitionLists;
        block5: {
            File file;
            block4: {
                partitionLists = null;
                try {
                    file = new File(xmlPath);
                    if (file.exists() && file.isFile()) break block4;
                    Log.errorln(NLS.bind((String)Messages.ERROR_CURRENT_XML_PATH_NOT_FOUND, (Object)xmlPath));
                    return null;
                }
                catch (DocumentException e) {
                    Log.errorln(Messages.UanbleParseXml);
                    e.printStackTrace();
                    return null;
                }
            }
            PartitionInfo PartitionInfo2 = PartitionItem.load(file, true);
            partitionLists = PartitionInfo2.getChildren();
            if (partitionLists != null && partitionLists.size() > 0) {
                cmdLineParam.setPartitionList(partitionLists);
                break block5;
            }
            Log.errorln(NLS.bind((String)Messages.MESSAGE_FAILED_To_LOAD_FILE, (Object)file.getName()));
            return null;
        }
        return partitionLists;
    }

    private void burnByXML(List<PartitionItem> partitionList, BurnContext burnContext, File programmerFile, ToolType toolType) {
        if (partitionList != null && partitionList.size() > 0) {
            CommonBurner commonBurner = new CommonBurner(burnContext, toolType);
            commonBurner.setChildren(partitionList);
            if (programmerFile != null) {
                commonBurner.setProgrammerFile(programmerFile.getAbsolutePath());
            }
            if (CmdMain.checkStatus(commonBurner.checkBeforeBurn())) {
                IFastbootProgressMonitor monitor = this.getProgressMonitor();
                monitor.getEvent().setBurner(commonBurner);
                commonBurner.burn(monitor);
            }
        } else {
            Log.errorln(Messages.UanbleParseXml);
            return;
        }
    }

    protected static boolean checkStatus(IStatus status) {
        boolean valid;
        if (status == Status.CANCEL_STATUS) {
            return false;
        }
        boolean bl = valid = status == null || status.isOK();
        if (!valid) {
            Log.errorln(status.getMessage());
        }
        return valid;
    }

    private static BurnContext loadBurnConfig(String XMLPath) {
        BurnConfig burnConfig = new BurnConfig(XMLPath);
        if (!burnConfig.isLoadResult()) {
            return null;
        }
        String deviceName = BurnConfig.getChipName();
        Log.println("The current select chip: " + deviceName);
        UnknownDevice ud = new UnknownDevice(deviceName, ToolType.Cmdline);
        if (!ud.isValid()) {
            Log.errorln(Messages.FastbootView_Unsupported_Device);
            return null;
        }
        LocalConfig localConfig = ud.getBurnContext().getLocalConfig();
        BoardConfig boardConfig = ud.getBurnContext().getBoardConfig();
        localConfig.setComPort(BurnConfig.getLocalConfig().getComPort());
        localConfig.setServerIp(BurnConfig.getLocalConfig().getServerIp());
        boardConfig.setIp(BurnConfig.getBoardConfig().getIp());
        boardConfig.setGateway(BurnConfig.getBoardConfig().getGateway());
        boardConfig.setSubnetMask(BurnConfig.getBoardConfig().getSubnetMask());
        boardConfig.setMac(BurnConfig.getBoardConfig().getMac());
        ud.getBurnContext().setTransferWay(BurnConfig.getTransferway());
        ud.getBurnContext().setJtagFrequency(BurnConfig.getBoardConfig().getFrequency());
        ud.getBurnContext().setUsbToEthernet(BurnConfig.isUSBToEthernet());
        return ud.getBurnContext();
    }

    private static void help() {
        CmdMain.printBurnByXml();
        Log.println("");
        BootBurn.printBurnBootEg();
        Log.println("");
        NandImg.printNandImgEg();
        Log.println(Messages.MESSAGE_HIBURN_NAND_IMG_GET_PAGESIZE_And_BLOCK);
        EmmcImg.printEmmcImgEg();
        Log.println("");
        Log.println("");
        Log.println("general options:");
        Log.println("--help    | -h    usage message");
        Log.println("--version | -v    version number and copyright");
        Log.println("--burn    | -b    this command will burn image to the flash according to the partition table xmlPath.");
        Log.println("                  first of all, you need to configure the burn.config file.");
        Log.println("--burnboot| -bb   This command is used to burn fastboot.");
        Log.println("--nandimg | -n    the commands is used to create nand image.");
        Log.println("--emmcimg | -e    the commands is used to create emmc image.");
    }

    private static void printVersion() {
        Log.println(String.valueOf(Messages.MESSAGE_HIBURN_VERSION_NAME) + VERSION);
        Log.println(Messages.MESSAGE_HIBURN_RESERVED);
    }

    private static void printBurnByXml() {
        Log.println("hiburn.jar --burn [-x xmlPath] [-p programmerPath]");
        Log.println(Messages.MESSAGE_HIBURN_BURN_BY_XML);
        Log.println(Messages.MESSAGE_HIBURN_BURN_NOTICE);
    }

    private IFastbootProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = IFastbootProgressMonitor.PROGRESSMONITORCMDLINE;
        }
        return this.progressMonitor;
    }
}

