/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import com.hisilicon.fastboot.log.Log;
import com.hisilicon.fastboot.utilitily.JarUtility;
import com.hisilicon.fastboot.utilitily.StringUtils;
import java.io.File;
import java.lang.reflect.Field;

public class LibUtils {
    private static final String OS_WIN = "windows";
    private static final String OS_32 = "x86";
    private static final String OS_64 = "x86_64";
    private static final String ARCH_LINUX_I386 = "i386";
    private static final String ARCH_LINUX_I686 = "i686";
    private static final String ARCH_LINUX_X86_64 = "x86_64";

    public static boolean loadRxtxSerialDLL() {
        String osName = System.getProperties().getProperty("os.name");
        String osArch = System.getProperties().getProperty("os.arch");
        Log.infoln("Current OS Name: " + osName);
        Log.infoln("Current OS Arch: " + osArch);
        try {
            if (osName.toLowerCase().startsWith(OS_WIN)) {
                LibUtils.loadWindowsRxtx(osArch);
            } else {
                LibUtils.loadLinuxRxtx(osArch);
            }
            return true;
        }
        catch (IllegalAccessException e) {
            Log.errorln(e.getMessage());
            return false;
        }
        catch (NoSuchFieldException e) {
            Log.errorln(e.getMessage());
            return false;
        }
    }

    private static void loadLinuxRxtx(String osArch) throws IllegalAccessException, NoSuchFieldException {
        StringBuilder path = new StringBuilder();
        String jarDir = JarUtility.getJarDir();
        if (jarDir != null) {
            path.append(jarDir);
            path.append(File.separator);
        }
        path.append("lib");
        path.append(File.separator);
        path.append("rxtx");
        path.append(File.separator);
        path.append("linux");
        path.append(File.separator);
        String dllPath = path.toString();
        if (osArch.toLowerCase().startsWith(ARCH_LINUX_I386) || osArch.toLowerCase().startsWith(ARCH_LINUX_I686) || osArch.toLowerCase().startsWith(OS_32)) {
            dllPath = String.valueOf(dllPath) + ARCH_LINUX_I686 + File.separator;
            LibUtils.addLibraryDir(dllPath);
            System.loadLibrary("rxtxParallel");
        } else {
            dllPath = String.valueOf(dllPath) + "x86_64" + File.separator;
            LibUtils.addLibraryDir(dllPath);
        }
        System.loadLibrary("rxtxSerial");
    }

    private static void loadWindowsRxtx(String osArch) throws IllegalAccessException, NoSuchFieldException {
        StringBuilder path = new StringBuilder();
        String jarDir = JarUtility.getJarDir();
        if (jarDir != null) {
            path.append(jarDir);
            path.append(File.separator);
        }
        path.append("lib");
        path.append(File.separator);
        path.append("rxtx");
        path.append(File.separator);
        path.append(OS_WIN);
        path.append(File.separator);
        String dllPath = path.toString();
        if (osArch.toLowerCase().startsWith(OS_32)) {
            dllPath = String.valueOf(dllPath) + OS_32 + File.separator;
            LibUtils.addLibraryDir(dllPath);
        } else {
            dllPath = String.valueOf(dllPath) + "x86_64" + File.separator;
            LibUtils.addLibraryDir(dllPath);
        }
        System.loadLibrary("rxtxSerial");
    }

    public static void addLibraryDir(String libraryPath) throws IllegalAccessException, NoSuchFieldException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            Object[] paths = (String[])field.get(null);
            int i = 0;
            while (i < paths.length) {
                if (libraryPath.equals(paths[i])) {
                    return;
                }
                ++i;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = libraryPath;
            field.set(null, tmp);
            paths = (String[])field.get(null);
            System.setProperty("java.library.path", StringUtils.join(paths, ";"));
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldException("Failed to get field handle to set library path");
        }
    }
}

