/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import com.hisilicon.fastboot.utilitily.FileUtils;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class GZipUtils {
    public static final int BUFFER = 65536;
    public static final String EXT = ".gz";

    public static File compress(IProgressMonitor uimonitor, File file, boolean delete, boolean tftpOccupied) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            File gzFile;
            fis = new FileInputStream(file);
            String outPutFileName = null;
            if (tftpOccupied) {
                outPutFileName = file.getPath();
            } else {
                String HiToolPath = HiToolUtils.getInstallPath();
                if (!file.getParent().equals(HiToolPath)) {
                    outPutFileName = String.valueOf(HiToolPath) + file.getName();
                }
            }
            outPutFileName = file.getPath();
            fos = new FileOutputStream(String.valueOf(outPutFileName) + EXT);
            if (!FileUtils.checkFreeSpace(new File(outPutFileName).getParent(), file.length())) {
                fis.close();
                fos.flush();
                fos.close();
                return null;
            }
            GZipUtils.compress(uimonitor, fis, fos);
            fis.close();
            fos.flush();
            fos.close();
            if (delete) {
                FileUtils.deleteFile(file);
            }
            File file2 = gzFile = new File(String.valueOf(outPutFileName) + EXT);
            return file2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static void compress(IProgressMonitor uimonitor, InputStream is, OutputStream os) throws IOException {
        int count;
        GZIPOutputStream gos = new GZIPOutputStream(os, 65536);
        byte[] data = new byte[65536];
        while ((count = is.read(data, 0, 65536)) != -1) {
            if (uimonitor != null && uimonitor.isCanceled()) break;
            gos.write(data, 0, count);
        }
        gos.finish();
        gos.flush();
        gos.close();
    }
}

