/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.utilitily;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private static final int DEFAULT_BUFFER_BIT_LEN = 256;
    protected byte[] buf;
    protected int bufsize;
    protected long bufmask;
    protected boolean bufdirty;
    protected int bufusedsize;
    protected long curpos;
    protected long bufstartpos;
    protected long bufendpos;
    protected long fileendpos;
    protected long initfilelen;

    public BufferedRandomAccessFile(File file, String mode) throws IOException, FileNotFoundException {
        super(file.getPath(), mode);
        this.init(file.getPath(), mode, 256);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long writeendpos = this.curpos + (long)len - 1L;
        if (writeendpos <= this.bufendpos) {
            System.arraycopy(b, off, this.buf, (int)(this.curpos - this.bufstartpos), len);
            this.bufdirty = true;
            this.bufusedsize = (int)(writeendpos - this.bufstartpos + 1L);
        } else {
            super.seek(this.curpos);
            super.write(b, off, len);
        }
        if (writeendpos > this.fileendpos) {
            this.fileendpos = writeendpos;
        }
        this.seek(writeendpos + 1L);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long readendpos = this.curpos + (long)len - 1L;
        if (readendpos <= this.bufendpos && readendpos <= this.fileendpos) {
            try {
                System.arraycopy(this.buf, (int)(this.curpos - this.bufstartpos), b, off, len);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        } else {
            if (readendpos > this.fileendpos) {
                len = (int)(this.length() - this.curpos + 1L);
            }
            super.seek(this.curpos);
            len = super.read(b, off, len);
            readendpos = this.curpos + (long)len - 1L;
        }
        this.seek(readendpos + 1L);
        return len;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.bufstartpos || pos > this.bufendpos) {
            this.flushbuf();
            if (pos >= 0L && pos <= this.fileendpos && this.fileendpos != 0L) {
                this.bufstartpos = pos & this.bufmask;
                this.bufusedsize = this.fillbuf();
            } else if (pos == 0L && this.fileendpos == 0L || pos == this.fileendpos + 1L) {
                this.bufstartpos = pos;
                this.bufusedsize = 0;
            }
            this.bufendpos = this.bufstartpos + (long)this.bufsize - 1L;
        }
        this.curpos = pos;
    }

    @Override
    public long length() throws IOException {
        return this.max(this.fileendpos + 1L, this.initfilelen);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.curpos;
    }

    @Override
    public void close() throws IOException {
        this.flushbuf();
        super.close();
    }

    private long max(long a, long b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    private void init(String name, String mode, int bufbitlen) throws IOException {
        this.initfilelen = super.length();
        this.fileendpos = this.initfilelen - 1L;
        this.curpos = super.getFilePointer();
        this.bufsize = 1 << bufbitlen;
        this.buf = new byte[this.bufsize];
        this.bufmask = (long)this.bufsize - 1L ^ 0xFFFFFFFFFFFFFFFFL;
        this.bufdirty = false;
        this.bufusedsize = 0;
        this.bufstartpos = -1L;
        this.bufendpos = -1L;
    }

    private void flushbuf() throws IOException {
        if (this.bufdirty) {
            if (super.getFilePointer() != this.bufstartpos) {
                super.seek(this.bufstartpos);
            }
            super.write(this.buf, 0, this.bufusedsize);
            this.bufdirty = false;
        }
    }

    private int fillbuf() throws IOException {
        super.seek(this.bufstartpos);
        this.bufdirty = false;
        return super.read(this.buf);
    }
}

