/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.ui.burners;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.PlatformType;
import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.define.IFastbootProgressMonitor;
import com.hisilicon.fastboot.model.devices.IEmmcBurner;
import com.hisilicon.fastboot.model.devices.burners.AbstractBurner;
import com.hisilicon.fastboot.model.devices.burners.EmmcBurner;
import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.serial.workers.PartitionBurnerWorker;
import com.hisilicon.fastboot.ui.burners.PartitionComposite;
import com.hisilicon.fastboot.ui.dialog.SelectHiProDialog;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.views.FastbootView;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class EmmcComposite
extends PartitionComposite {
    private Button uploadButton;
    private Button eraseButton;
    private Button createPartitionTable;
    private Button browseButton;
    private Button createImageButton;

    public EmmcComposite(Composite parent, int style, IBurner emmcBurn) {
        super(parent, style, emmcBurn);
    }

    @Override
    protected IContentProvider createContentProvider() {
        return new ViewerContentProvider();
    }

    @Override
    protected void createContents(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite com = new Composite(parent, 0);
        com.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(1808);
        com.setLayoutData((Object)gridData);
        this.useXMLPathAsParentButton = new Button(com, 32);
        GridData layoutData = new GridData();
        this.useXMLPathAsParentButton.setLayoutData((Object)layoutData);
        this.useXMLPathAsParentButton.setText(Messages.PartitionComposite_LABEL_Default_Use_XML_Path);
        this.useXMLPathAsParentButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String text = EmmcComposite.this.tableFileText.getText().trim();
                File file = new File(text);
                if (file.exists()) {
                    EmmcComposite.this.loadPartitionFile(file, EmmcComposite.this.useXMLPathAsParentButton.getSelection());
                }
            }
        });
        this.useXMLPathAsParentButton.setSelection(true);
        Label label = new Label(com, 0);
        label.setText(Messages.EmmcComposite_LABEL_PartitionFile);
        this.tableFileText = new Text(com, 2048);
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.tableFileText.setLayoutData((Object)layoutData);
        this.tableFileText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.handleEnterOnTableFileText();
            }
        });
        this.browseButton = new Button(com, 0);
        layoutData = new GridData();
        HiToolUtils.setWidthForOS(layoutData, 60, 70);
        this.browseButton.setLayoutData((Object)layoutData);
        this.browseButton.setText(LABEL_BROWSE);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.handleBrowseFile();
            }
        });
        this.saveButton = new Button(com, 0);
        this.saveButton.setLayoutData((Object)layoutData);
        this.saveButton.setText(LABEL_SAVE);
        this.saveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.savePartitionTable();
            }
        });
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        if (emmcType == 1) {
            this.createPartitionTable = new Button(com, 32);
            this.createPartitionTable.setText(Messages.EmmcComposite_Create_eMMC_Partition_Table);
            this.createPartitionTable.setLayoutData((Object)new GridData(1, 1, false, false));
            this.createPartitionTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IEmmcBurner burner = EmmcComposite.this.getBurner();
                    burner.setCreatePartitionTable(EmmcComposite.this.createPartitionTable.getSelection());
                }
            });
            this.createPartitionTable.setSelection(this.getBurner().isCreatePartitionTable());
        } else if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            this.createPartitionTable = new Button(com, 32);
            this.createPartitionTable.setText(Messages.EmmcComposite_Create_eMMC_Partition_Table);
            this.createPartitionTable.setVisible(false);
        }
        if (this.getBurner().getBurnContext().getPlatformType() == PlatformType.CA || ((UnknownDevice)this.getBurner().getBurnContext().getDeviceSetting()).isSupportBurnByLibBootrom()) {
            Label programmerFileLabel = new Label(com, 0);
            programmerFileLabel.setText(Messages.EmmcComposite_LABEL_PROGRAMER_FILE);
            GridData programmerLblGD = new GridData(1, 1, false, false);
            programmerFileLabel.setLayoutData((Object)programmerLblGD);
            this.programmerFileText = new Text(com, 2048);
            GridData programmerFileTextLayout = new GridData(4, 1, true, false);
            programmerFileTextLayout.horizontalSpan = 2;
            this.programmerFileText.setLayoutData((Object)programmerFileTextLayout);
            this.programmerFileText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String fileStr = EmmcComposite.this.programmerFileText.getText().trim();
                    ((AbstractBurner)((Object)EmmcComposite.this.getBurner())).setProgrammerFile(fileStr);
                    EmmcComposite.this.getBurner().getPratitionInfo().setProgrammerFile(new File(fileStr));
                }
            });
            this.programmerFileBrowseButton = new Button(com, 0);
            GridData programmerBtnLayout = new GridData(1, 1, false, false);
            HiToolUtils.setWidthForOS(programmerBtnLayout, 125, 145);
            programmerBtnLayout.horizontalSpan = 2;
            this.programmerFileBrowseButton.setLayoutData((Object)programmerBtnLayout);
            this.programmerFileBrowseButton.setText(LABEL_BROWSE);
            this.programmerFileBrowseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    EmmcComposite.this.handleBrwoseProgrammerFile();
                }
            });
        }
        this.createButtons(com);
        Control tableControl = this.createItemTable(com);
        this.itemViewer = (CheckboxTableViewer)tableControl.getData();
        this.itemViewer.setInput((Object)this.getBurner());
        GridData layoutData2 = new GridData(4, 4, true, true, 6, 1);
        tableControl.setLayoutData((Object)layoutData2);
        this.initData();
    }

    @Override
    protected Layout createLayout() {
        return new GridLayout(5, false);
    }

    @Override
    protected void initData() {
    }

    @Override
    protected String getCreateImageButtonCaption() {
        if (FastbootView.isSupportUfsSeries()) {
            return Messages.EmmcComposite_LABEL_CREATE_EmmcOrUfs_IMAGE;
        }
        return Messages.EmmcComposite_LABEL_CREATE_IMAGE;
    }

    @Override
    protected void enableButtons() {
        if (this.burnButton != null && !this.burnButton.isDisposed()) {
            this.burnButton.setEnabled(true);
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(true);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(true);
        }
        if (this.createImageButton != null && !this.createImageButton.isDisposed()) {
            this.createImageButton.setEnabled(true);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(true);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(true);
        }
        if (this.createPartitionTable != null && !this.createPartitionTable.isDisposed()) {
            this.createPartitionTable.setEnabled(true);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(true);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(true);
        }
    }

    @Override
    protected void enableUI() {
        super.enableUI();
        if (this.isDisposed()) {
            return;
        }
        this.enableButtons();
    }

    @Override
    protected void createButtons(Composite parent) {
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout((Layout)new GridLayout(4, true));
        GridData gd = new GridData();
        gd.horizontalSpan = 6;
        buttonComp.setLayoutData((Object)gd);
        this.burnButton = new Button(buttonComp, 0);
        this.burnButton.setText(LABEL_BURN);
        GridData layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.burnButton.setLayoutData((Object)layoutData);
        this.burnButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.burnButton.setEnabled(false);
                EmmcComposite.this.burn();
            }
        });
        int emmcType = ((UnknownDevice)this.burner.getBurnContext().getDeviceSetting()).getEmmcType();
        if (emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_NO_MBR_TYPE.ordinal() || emmcType == PartitionBurnerWorker.EMMC_TYPE_E.EMMC_HI3716CV200_CA_TYPE.ordinal()) {
            buttonComp.setLayout((Layout)new GridLayout(5, true));
            this.eraseButton = new Button(buttonComp, 0);
            this.eraseButton.setText(Messages.EmmcComposite_EmmcEraseAll);
            layoutData = new GridData(576);
            layoutData.widthHint = 120;
            this.eraseButton.setLayoutData((Object)layoutData);
            this.eraseButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (!EmmcComposite.this.isErase()) {
                        return;
                    }
                    EmmcComposite.this.eraseButton.setEnabled(false);
                    EmmcComposite.this.eraseAll();
                }
            });
        }
        this.uploadButton = new Button(buttonComp, 0);
        this.uploadButton.setText(LABEL_UPLOAD);
        layoutData = new GridData(576);
        layoutData.widthHint = 120;
        this.uploadButton.setLayoutData((Object)layoutData);
        this.uploadButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.uploadButton.setEnabled(false);
                EmmcComposite.this.upload();
            }
        });
        this.createImageButton = new Button(buttonComp, 0);
        this.createImageButton.setText(this.getCreateImageButtonCaption());
        layoutData = new GridData(576);
        HiToolUtils.setWidthForOS(layoutData, 130, 160);
        if (FastbootView.isSupportUfsSeries()) {
            layoutData.widthHint = 240;
        }
        this.createImageButton.setLayoutData((Object)layoutData);
        this.createImageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EmmcComposite.this.createImageButton.setEnabled(false);
                List<PartitionItem> children = EmmcComposite.this.getBurner().getPratitionInfo().getChildren();
                for (PartitionItem partitionItem : children) {
                    partitionItem.setChecked(true);
                }
                EmmcComposite.this.updateSelection();
                EmmcComposite.this.createImage();
            }
        });
        this.createUsbPackageButton = new Button(buttonComp, 0);
        this.createUsbPackageButton.setText(LABEL_CREATE_USB_PACKAGE);
        layoutData = new GridData(576);
        HiToolUtils.setWidthForOS(layoutData, 120, 160);
        this.createUsbPackageButton.setLayoutData((Object)layoutData);
        this.createUsbPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!EmmcComposite.this.checkStatus(((EmmcBurner)EmmcComposite.this.getBurner()).checkCreateHiproImage())) {
                    return;
                }
                List<PartitionItem> children = EmmcComposite.this.getBurner().getPratitionInfo().getChildren();
                int size = children.size();
                int i = 0;
                while (i < size) {
                    PartitionItem partition = children.get(i);
                    if (i == size - 1 && partition.isChecked() && !((EmmcBurner)EmmcComposite.this.getBurner()).getBurnerWorker().checkLastPartition(children)) {
                        return;
                    }
                    ++i;
                }
                SelectHiProDialog selectHiProDialog = new SelectHiProDialog(Display.getDefault().getActiveShell(), EmmcComposite.this.burner, children);
                int open = selectHiProDialog.open();
                if (open == 0) {
                    String selectHiProWay = selectHiProDialog.getSelectHiProWay();
                    if (selectHiProWay.equals("serial")) {
                        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Create HiPro-serial Image By Emmc", "ChipName: " + EmmcComposite.this.burner.getBurnContext().getDeviceSetting().getName());
                        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
                        EmmcComposite.this.handleCreateUsbPackage();
                    } else if (selectHiProWay.equals("usb")) {
                        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Create HiPro-usb Image By Emmc", "ChipName: " + EmmcComposite.this.burner.getBurnContext().getDeviceSetting().getName());
                        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
                        try {
                            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                            dialog.setOverwrite(true);
                            dialog.setFileName("hipro_usb.zip");
                            String filePath = dialog.open();
                            if (filePath != null) {
                                EmmcComposite.this.disableUI();
                                IFastbootProgressMonitor monitor = EmmcComposite.this.getProgressMonitor(ToolType.Composite);
                                monitor.getEvent().setBurner(EmmcComposite.this.getBurner());
                                filePath = dialog.getFilterPath();
                                String fileName = dialog.getFileName();
                                EmmcComposite.this.handleCreateHiProUsb(monitor, filePath, fileName);
                            }
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    return;
                }
            }
        });
        buttonComp.setLayoutData((Object)new GridData(4, 1, true, false, 5, 1));
    }

    @Override
    protected void disableUI() {
        super.disableUI();
        if (this.isDisposed()) {
            return;
        }
        if (this.eraseButton != null && !this.eraseButton.isDisposed()) {
            this.eraseButton.setEnabled(false);
        }
        if (this.uploadButton != null && !this.uploadButton.isDisposed()) {
            this.uploadButton.setEnabled(false);
        }
        if (this.createImageButton != null && !this.createImageButton.isDisposed()) {
            this.createImageButton.setEnabled(false);
        }
        if (this.browseButton != null && !this.browseButton.isDisposed()) {
            this.browseButton.setEnabled(false);
        }
        if (this.saveButton != null && !this.saveButton.isDisposed()) {
            this.saveButton.setEnabled(false);
        }
        if (this.createPartitionTable != null && !this.createPartitionTable.isDisposed()) {
            this.createPartitionTable.setEnabled(false);
        }
        if (this.programmerFileBrowseButton != null && !this.programmerFileBrowseButton.isDisposed()) {
            this.programmerFileBrowseButton.setEnabled(false);
        }
        if (this.createUsbPackageButton != null && !this.createUsbPackageButton.isDisposed()) {
            this.createUsbPackageButton.setEnabled(false);
        }
    }

    @Override
    public IEmmcBurner getBurner() {
        return (IEmmcBurner)super.getBurner();
    }

    @Override
    protected void handleCreateUsbPackage() {
        List<PartitionItem> children = this.getBurner().getPratitionInfo().getChildren();
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setOverwrite(true);
        dialog.setFileName("usb_update.bin");
        String filePath = dialog.open();
        if (filePath != null) {
            this.disableUI();
            IFastbootProgressMonitor monitor = this.getProgressMonitor(ToolType.Composite);
            monitor.getEvent().setBurner(this.getBurner());
            ((EmmcBurner)this.getBurner()).createHiProImage(monitor, filePath, children);
        }
    }

    private static class ViewerContentProvider
    implements IStructuredContentProvider {
        private ViewerContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof EmmcBurner) {
                return ((EmmcBurner)inputElement).getChildren().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

