/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.serial.workers;

import com.hisilicon.fastboot.model.ToolType;
import com.hisilicon.fastboot.model.define.IChecker;
import com.hisilicon.fastboot.model.receive.ReceiveTimeOutException;
import com.hisilicon.fastboot.serial.workers.AddressBurnerWorker;
import com.hisilicon.fastboot.serial.workers.CallLibJTAGWorker;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.soyatec.hisilicon.platform.api.statistics.HiToolStatistics;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BadCheckBurnerWorker
extends AddressBurnerWorker {
    private static StringBuilder content = new StringBuilder();

    public BadCheckBurnerWorker(IChecker checker, ToolType toolType) {
        super(checker, toolType);
    }

    public boolean initBoard() throws IOException, ReceiveTimeOutException {
        if (HiToolUtils.isDebugOn()) {
            this.println("InitBoard Start");
        }
        return this.bootDownload(null);
    }

    public boolean eraseBad(IProgressMonitor uimonitor) throws ReceiveTimeOutException, IOException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Nand Scrub", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Nand Scrub");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        monitor.getEvent().setSuccess(false);
        this.setProgressMonitor(uimonitor);
        uimonitor.beginTask("Erase Bad Blocks", 100);
        BadCheckBurnerWorker.deleteContent(content);
        uimonitor.setTaskName("Init Board");
        boolean initBoard = this.initBoard();
        if (!initBoard) {
            return false;
        }
        uimonitor.internalWorked(0.2);
        String received = this.getCurReceived();
        content.append(received);
        if (received.toUpperCase().indexOf("NAND") == -1) {
            this.warningln("No Nand Found.");
            return false;
        }
        uimonitor.setTaskName("Sending nand scrub command.");
        uimonitor.internalWorked(0.6);
        boolean sendCommand = this.sendCommand("nand scrub", 10000L);
        if (!sendCommand) {
            this.warningln("Failed to execute nand scrub command.");
            return false;
        }
        content.append(this.getCurReceived());
        monitor.getEvent().setSuccess(true);
        monitor.getEvent().setMessage(content.toString());
        this.infoln("Nand scrub successful.");
        return true;
    }

    public boolean check(IProgressMonitor uimonitor) throws ReceiveTimeOutException, IOException {
        HiToolStatistics.INSTANCE.logUsage("HiBurn", "Bad Check", "ChipName: " + this.burner.getBurnContext().getDeviceSetting().getName());
        HiToolStatistics.INSTANCE.logToolInUse("HiBurn");
        String versionInfo = this.getVersionInfo("Bad Check");
        CallLibJTAGWorker.printDebugInfo(versionInfo);
        try {
            monitor.getEvent().setSuccess(false);
            this.setProgressMonitor(uimonitor);
            uimonitor.beginTask("Check Bad Blocks", 100);
            BadCheckBurnerWorker.deleteContent(content);
            uimonitor.setTaskName("Init Board");
            boolean initBoard = this.initBoard();
            if (!initBoard) {
                return false;
            }
            uimonitor.internalWorked(0.2);
            String received = this.getCurReceived();
            content.append(received);
            if (received.toUpperCase().indexOf("NAND") == -1) {
                this.warningln("No Nand Found.");
                return false;
            }
            uimonitor.setTaskName("Sending Check command.");
            uimonitor.internalWorked(0.6);
            boolean sendCommand = this.sendCommand("nand bad", 10000L);
            if (!sendCommand) {
                this.warningln("Failed to get bad block info.");
                return false;
            }
            this.onAdataAvailable(serialReceived);
            content.append((CharSequence)serialReceived);
            monitor.getEvent().setSuccess(true);
            monitor.getEvent().setMessage(content.toString());
        }
        finally {
            uimonitor.done();
        }
        return true;
    }
}

