/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.perspectives;

import com.hisilicon.fastboot.model.devices.unknown.UnknownDevice;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import com.hisilicon.fastboot.views.FastbootView;
import com.hisilicon.fastboot.views.LightView;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class FastbootPerspective
implements IPerspectiveFactory {
    public static final String FASTBOOT_PERSPECTIVE_ID = FastbootPerspective.class.getName();
    String editorArea = null;
    String topFolderId = "topFolderId";
    String leftFolderId = "leftFolder";
    String rightFolderId = "rightFolder";
    String bottomFolderId = "bottomFolderId";

    public void createInitialLayout(IPageLayout layout) {
        this.editorArea = layout.getEditorArea();
        layout.setEditorAreaVisible(false);
        this.addViews(layout);
        this.updateCloseAble(layout);
    }

    private void addViews(IPageLayout layout) {
        IFolderLayout topFolder = layout.createFolder(this.topFolderId, 1, 0.85f, this.editorArea);
        topFolder.addView(FastbootView.ID);
        IFolderLayout bottomFolder = layout.createFolder(this.bottomFolderId, 4, 0.7f, this.topFolderId);
        bottomFolder.addView("org.eclipse.ui.console.ConsoleView");
        UnknownDevice.loadLightDebug(HiToolUtils.getChipName());
        if (UnknownDevice.isOpenLightDebug()) {
            IFolderLayout rightFolder = layout.createFolder(this.rightFolderId, 2, 0.12f, this.editorArea);
            rightFolder.addView(LightView.ID);
        }
    }

    private void updateCloseAble(IPageLayout layout) {
        layout.getViewLayout(FastbootView.ID).setCloseable(false);
        layout.getViewLayout("org.eclipse.ui.console.ConsoleView").setCloseable(false);
        if (UnknownDevice.isOpenLightDebug()) {
            layout.getViewLayout(LightView.ID).setCloseable(false);
        }
    }
}

