/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.nand;

import com.hisilicon.fastboot.packagers.nand.PageType;
import com.hisilicon.fastboot.packagers.nand.ecc.ECCType;

public class FlashOption {
    private ECCType eccType;
    private PageType pageType;
    private int oobSize;

    public FlashOption(ECCType eccType, PageType pageType, int oobSize) {
        this.eccType = eccType;
        this.pageType = pageType;
        this.oobSize = oobSize;
    }

    public ECCType getEccType() {
        return this.eccType;
    }

    public PageType getPageType() {
        return this.pageType;
    }

    public int getOOBSize() {
        return this.oobSize;
    }

    public void setOOBSize(int oobSize) {
        this.oobSize = oobSize;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        switch (this.pageType.getValue()) {
            case 0: {
                builder.append("512B");
                break;
            }
            case 1: {
                builder.append("2K");
                break;
            }
            case 2: {
                builder.append("4K");
                break;
            }
            case 3: {
                builder.append("8K");
                break;
            }
            case 4: {
                builder.append("16K");
                break;
            }
            case 5: {
                builder.append("32K");
                break;
            }
            case 6: {
                builder.append("Last");
                break;
            }
            default: {
                builder.append("512B");
            }
        }
        builder.append("/");
        switch (this.eccType.getValue()) {
            case 0: {
                builder.append("NoECC");
                break;
            }
            case 1: {
                builder.append("1bit");
                break;
            }
            case 2: {
                builder.append("4bit512");
                break;
            }
            case 3: {
                builder.append("16bit1k");
                break;
            }
            case 4: {
                builder.append("24bit1k");
                break;
            }
            case 5: {
                builder.append("40bit1k");
                break;
            }
            case 6: {
                builder.append("64bit1k");
                break;
            }
            case 7: {
                builder.append("8bit512");
                break;
            }
            case 8: {
                builder.append("13bit");
                break;
            }
            case 9: {
                builder.append("24bit1K");
                break;
            }
            case 10: {
                builder.append("27bit1K");
                break;
            }
            case 11: {
                builder.append("41bit1K");
                break;
            }
            case 12: {
                builder.append("60bit1K");
                break;
            }
            case 13: {
                builder.append("80bit1K");
                break;
            }
            case 14: {
                builder.append("Last");
                break;
            }
            default: {
                builder.append("NoECC");
            }
        }
        return builder.toString();
    }
}

