/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.packagers.hipro;

import com.hisilicon.fastboot.Messages;
import com.hisilicon.fastboot.model.FileSystem;
import com.hisilicon.fastboot.model.FlashType;
import com.hisilicon.fastboot.model.PartitionItem;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.packagers.PackageData;
import com.hisilicon.fastboot.packagers.hipro.CRC32A;
import com.hisilicon.fastboot.packagers.hipro.DownloadType;
import com.hisilicon.fastboot.packagers.hipro.UsbHeader;
import com.hisilicon.fastboot.packagers.hipro.UsbImageMap;
import com.hisilicon.fastboot.packagers.hipro.UsbManuInfo;
import com.hisilicon.fastboot.utilitily.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class HiproPackager {
    static int FILE_PART_SIZE = 0x400000;
    public static final int EMMC_FILE_BLOCK_SIZE = 8192;
    public static final int PACK_STATUS_SUCCESS = 0;
    public static final int PACK_STATUS_FAILED = 1;
    public static final int PACK_STATUS_USERCANCELED = -1;
    UsbHeader header;
    List<PartitionItem> partitionItems;
    private IBurner burner;

    public HiproPackager(IBurner burner) {
        this.burner = burner;
    }

    public void setPartitionItems(List<PartitionItem> items) {
        this.partitionItems = items;
    }

    protected int loadArguments(SubProgressMonitor monitor) {
        this.header = new UsbHeader();
        this.header.magicNum = 1280262468;
        UsbManuInfo manuInfo = new UsbManuInfo();
        manuInfo.manuId = 3;
        manuInfo.hardVersion = 1;
        manuInfo.softVersion = 0x1010101;
        manuInfo.snStart = 0;
        manuInfo.snEnd = -1;
        manuInfo.downloadType = DownloadType.BASIC;
        manuInfo.reserved = 0;
        ArrayList<UsbImageMap> imgList = new ArrayList<UsbImageMap>();
        int i = 0;
        while (i < this.partitionItems.size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            PartitionItem partItem = this.partitionItems.get(i);
            if (partItem.isChecked() && partItem.getFile() != null) {
                UsbImageMap img = new UsbImageMap();
                img.fileName = partItem.getFile().getPath();
                img.fileLength = partItem.getFile().length();
                img.startAddress = partItem.getStart();
                img.endAddress = img.startAddress + partItem.getLength();
                img.flashType = partItem.getFlashType();
                img.flashIndex = 0;
                if (partItem.getFileSystem() == FileSystem.yaffs) {
                    img.flashIndex |= 0x10000;
                }
                imgList.add(img);
            }
            ++i;
        }
        manuInfo.setImageMaps(imgList);
        ArrayList<UsbManuInfo> manuList = new ArrayList<UsbManuInfo>();
        manuList.add(manuInfo);
        this.header.setManuInfos(manuList);
        int hLength = 0;
        hLength = PackageData.is32BitsSeries() ? 18 : 22;
        int i2 = 0;
        while (i2 < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            hLength += this.header.getManuInfos().get(i2).getLength(this.burner);
            ++i2;
        }
        int hOffset = this.header.headerLength = hLength;
        int i3 = 0;
        while (i3 < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            int j = 0;
            while (j < this.header.getManuInfos().get(i3).getImageMaps().size()) {
                UsbImageMap img = this.header.getManuInfos().get(i3).getImageMaps().get(j);
                img.offset = hOffset;
                hOffset = (int)((long)hOffset + (8L + img.fileLength));
                ++j;
            }
            ++i3;
        }
        this.header.fileLength = hOffset;
        return 0;
    }

    protected int writeHeaderBytes(SubProgressMonitor monitor, String filePath) throws IOException {
        block21: {
            PackageData packData = new PackageData(this.header.headerLength);
            packData.writeUint(this.header.magicNum);
            packData.writeUint(0L);
            packData.writeUint(this.header.headerLength);
            if (PackageData.is32BitsSeries()) {
                packData.writeUint(this.header.fileLength);
            } else {
                packData.writeUlong(this.header.fileLength);
            }
            packData.writeUShort(this.header.getManuInfos().size());
            int workCount = 0;
            int i = 0;
            while (i < this.header.getManuInfos().size()) {
                workCount += this.header.getManuInfos().get(i).getImageMaps().size();
                ++i;
            }
            monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, workCount);
            i = 0;
            while (i < this.header.getManuInfos().size()) {
                if (monitor.isCanceled()) {
                    return -1;
                }
                UsbManuInfo manuInfo = this.header.getManuInfos().get(i);
                packData.writeUint(manuInfo.manuId);
                packData.writeUint(manuInfo.hardVersion);
                packData.writeUint(manuInfo.softVersion);
                packData.writeUint(manuInfo.snStart);
                packData.writeUint(manuInfo.snEnd);
                packData.writeUint(manuInfo.downloadType.getCode());
                packData.writeUint(manuInfo.reserved);
                packData.writeUShort(manuInfo.getImageMaps().size());
                int j = 0;
                while (j < manuInfo.getImageMaps().size()) {
                    if (monitor.isCanceled()) {
                        return -1;
                    }
                    UsbImageMap imageMap = manuInfo.getImageMaps().get(j);
                    packData.writeUint(imageMap.fileLength);
                    packData.writeUint(imageMap.offset);
                    if (PackageData.is32BitsSeries()) {
                        packData.writeUint(imageMap.startAddress);
                        packData.writeUint(imageMap.endAddress);
                    } else {
                        packData.writeUlong(imageMap.startAddress);
                        packData.writeUlong(imageMap.endAddress);
                    }
                    if (imageMap.flashType == FlashType.spi) {
                        packData.writeUint(0L);
                    } else if (imageMap.flashType == FlashType.nand) {
                        packData.writeUint(1L);
                    } else {
                        packData.writeUint(2L);
                    }
                    packData.writeUint(imageMap.flashIndex);
                    monitor.worked(1);
                    ++j;
                }
                ++i;
            }
            this.header.headerCrc = CRC32A.calculate(packData.getData());
            packData.writeUint(this.header.headerCrc, 4);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(filePath, true);
                    fos.write(packData.getData());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (fos != null) {
                        fos.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    fos.close();
                }
                throw throwable;
            }
            if (fos != null) {
                fos.close();
            }
        }
        monitor.done();
        return 0;
    }

    protected int writeImageBytes(SubProgressMonitor monitor, String filePath) throws IOException {
        int workCount = 0;
        int i = 0;
        while (i < this.header.getManuInfos().size()) {
            workCount += this.header.getManuInfos().get(i).getImageMaps().size();
            ++i;
        }
        monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, workCount);
        i = 0;
        while (i < this.header.getManuInfos().size()) {
            if (monitor.isCanceled()) {
                return -1;
            }
            int j = 0;
            while (j < this.header.getManuInfos().get(i).getImageMaps().size()) {
                int result;
                long fileSize;
                File file;
                CRC32A crc;
                int partCount;
                UsbImageMap imageMap;
                block14: {
                    if (monitor.isCanceled()) {
                        return -1;
                    }
                    imageMap = this.header.getManuInfos().get(i).getImageMaps().get(j);
                    partCount = 0;
                    partCount = imageMap.fileLength % (long)FILE_PART_SIZE == 0L ? (int)(imageMap.fileLength / (long)FILE_PART_SIZE) : (int)(imageMap.fileLength / (long)FILE_PART_SIZE) + 1;
                    crc = new CRC32A();
                    crc.start();
                    file = new File(filePath);
                    fileSize = file.length();
                    PackageData pd = new PackageData(8);
                    pd.writeUint(imageMap.fileLength);
                    pd.writeUint(0L);
                    FileOutputStream fos0 = null;
                    try {
                        try {
                            fos0 = new FileOutputStream(filePath, true);
                            fos0.write(pd.getData());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (fos0 != null) {
                                fos0.close();
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fos0 != null) {
                            fos0.close();
                        }
                        throw throwable;
                    }
                    if (fos0 != null) {
                        fos0.close();
                    }
                }
                if ((result = this.readAndWriteParts(monitor, filePath, imageMap, partCount, crc)) != 0) {
                    return result;
                }
                this.writeCrc(crc, file, fileSize);
                monitor.worked(1);
                ++j;
            }
            ++i;
        }
        monitor.done();
        return 0;
    }

    private void writeCrc(CRC32A crc, File file, long fileSize) throws FileNotFoundException, IOException {
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(fileSize + 4L);
                int crcValue = crc.getValue();
                PackageData pd = new PackageData(4);
                pd.writeUint(crcValue);
                raf.write(pd.getData());
            }
            catch (IOException e) {
                e.printStackTrace();
                if (raf != null) {
                    raf.close();
                }
            }
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    private int readAndWriteParts(SubProgressMonitor monitor, String filePath, UsbImageMap imageMap, int partCount, CRC32A crc) {
        int k = 0;
        while (k < partCount) {
            if (monitor.isCanceled()) {
                return -1;
            }
            int partSize = k == partCount - 1 ? (int)(imageMap.fileLength - (long)FILE_PART_SIZE * (long)(partCount - 1)) : FILE_PART_SIZE;
            RandomAccessFile iraf = null;
            FileOutputStream fos = null;
            try {
                try {
                    iraf = new RandomAccessFile(imageMap.fileName, "r");
                    iraf.seek((long)FILE_PART_SIZE * (long)k);
                    byte[] b = new byte[partSize];
                    int read = iraf.read(b);
                    if (read < 0) {
                        System.out.println("Read Error.");
                    }
                    crc.update(b);
                    fos = new FileOutputStream(filePath, true);
                    fos.write(b);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        if (iraf != null) {
                            iraf.close();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    return 1;
                }
            }
            finally {
                try {
                    if (iraf != null) {
                        iraf.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++k;
        }
        return 0;
    }

    public int doPackage(SubProgressMonitor monitor, String outputPath) {
        monitor.beginTask(Messages.BurnComposite_Create_Usb_Package_Text, 10);
        File file = new File(outputPath);
        int argResult = this.loadArguments(monitor);
        if (argResult != 0) {
            if (file.exists()) {
                FileUtils.deleteFile(file);
            }
            monitor.done();
            return argResult;
        }
        try {
            int writeHeaderResult = this.writeHeaderBytes(new SubProgressMonitor((IProgressMonitor)monitor, 3, 4), outputPath);
            if (writeHeaderResult != 0) {
                if (file.exists()) {
                    FileUtils.deleteFile(file);
                }
                monitor.done();
                return writeHeaderResult;
            }
            int writeImageResult = this.writeImageBytes(new SubProgressMonitor((IProgressMonitor)monitor, 6, 4), outputPath);
            if (writeImageResult != 0) {
                if (file.exists()) {
                    FileUtils.deleteFile(file);
                }
                monitor.done();
                return writeImageResult;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        monitor.done();
        return 0;
    }
}

