/*
 * Decompiled with CFR 0.152.
 */
package com.hisilicon.fastboot.model.devices.burners.bvt;

import com.hisilicon.fastboot.model.FileInfo;
import com.hisilicon.fastboot.model.TransferWay;
import com.hisilicon.fastboot.model.define.IBurner;
import com.hisilicon.fastboot.model.devices.IFrameSetting;
import com.hisilicon.fastboot.serial.workers.FastbootBurnerWorker;
import com.hisilicon.fastboot.utilitily.HiToolUtils;
import java.io.IOException;

public class BVTFastbootBurnerWorker
extends FastbootBurnerWorker {
    public BVTFastbootBurnerWorker(IFrameSetting frameSetting, IBurner burner) {
        super(frameSetting, burner, HiToolUtils.getToolType());
    }

    @Override
    public boolean sendStartFrame(FileInfo fileInfo) {
        if (this.burner.getBurnContext().getTransferWay() == TransferWay.USBBootrom || this.burner.getBurnContext().getTransferWay() == TransferWay.USBNonNude) {
            return this.sendUSBStartFrame();
        }
        String temp = null;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.frameSetting.getSendStartFrameTimeout()) {
            boolean handleCancel;
            if (this.uimonitor.isCanceled() && (handleCancel = this.handleCancel())) {
                return false;
            }
            this.onAdataAvailable(serialReceived);
            temp = serialReceived.toString();
            int indexOf = temp.indexOf("     ");
            if (indexOf == -1) continue;
            try {
                this.sendBytes(new byte[]{-86});
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

